"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'parameters can be used and referenced using param.ref'(test) {
        const stack = new lib_1.Stack();
        const child = new lib_1.Construct(stack, 'Child');
        const param = new lib_1.CfnParameter(child, 'MyParam', {
            default: 10,
            type: 'Integer',
            description: 'My first parameter'
        });
        new lib_1.CfnResource(stack, 'Resource', { type: 'Type', properties: { ReferenceToParam: param.value } });
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: {
                ChildMyParam3161BF5D: {
                    Default: 10,
                    Type: 'Integer',
                    Description: 'My first parameter'
                }
            },
            Resources: {
                Resource: {
                    Type: 'Type',
                    Properties: { ReferenceToParam: { Ref: 'ChildMyParam3161BF5D' } }
                }
            }
        });
        test.done();
    },
    'parameters are tokens, so they can be assigned without .ref and their Ref will be taken'(test) {
        const stack = new lib_1.Stack();
        const param = new lib_1.CfnParameter(stack, 'MyParam', { type: 'String' });
        test.deepEqual(stack.resolve(param), { Ref: 'MyParam' });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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