"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from unified_python_sdk.models.shared import enrichperson as shared_enrichperson
from unified_python_sdk.types import BaseModel
from unified_python_sdk.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)


class ListEnrichPeopleRequestTypedDict(TypedDict):
    connection_id: str
    r"""ID of the connection"""
    company_name: NotRequired[str]
    r"""The name of the company the person is associated with.  Not valid by itself."""
    email: NotRequired[str]
    r"""The email of the person to search"""
    linkedin_url: NotRequired[str]
    r"""The LinkedIn URL of the person to search"""
    name: NotRequired[str]
    r"""The name of the person to search"""
    twitter: NotRequired[str]
    r"""The twitter handle of the person to search"""


class ListEnrichPeopleRequest(BaseModel):
    connection_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""ID of the connection"""

    company_name: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The name of the company the person is associated with.  Not valid by itself."""

    email: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The email of the person to search"""

    linkedin_url: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The LinkedIn URL of the person to search"""

    name: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The name of the person to search"""

    twitter: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The twitter handle of the person to search"""


class ListEnrichPeopleResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    enrich_person: NotRequired[shared_enrichperson.EnrichPersonTypedDict]
    r"""Successful"""


class ListEnrichPeopleResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""

    status_code: int
    r"""HTTP response status code for this operation"""

    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""

    enrich_person: Optional[shared_enrichperson.EnrichPerson] = None
    r"""Successful"""
