"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .accountingattachment import AccountingAttachment, AccountingAttachmentTypedDict
from .accountinglineitem import AccountingLineitem, AccountingLineitemTypedDict
from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from unified_python_sdk.types import BaseModel


class PaymentCollectionMethod(str, Enum):
    SEND_INVOICE = "send_invoice"
    CHARGE_AUTOMATICALLY = "charge_automatically"


class AccountingInvoiceStatus(str, Enum):
    DRAFT = "DRAFT"
    VOIDED = "VOIDED"
    AUTHORIZED = "AUTHORIZED"
    PAID = "PAID"
    PARTIALLY_PAID = "PARTIALLY_PAID"
    PARTIALLY_REFUNDED = "PARTIALLY_REFUNDED"
    REFUNDED = "REFUNDED"


class AccountingInvoiceType(str, Enum):
    BILL = "BILL"
    INVOICE = "INVOICE"
    CREDITMEMO = "CREDITMEMO"


class AccountingInvoiceTypedDict(TypedDict):
    attachments: NotRequired[List[AccountingAttachmentTypedDict]]
    balance_amount: NotRequired[float]
    cancelled_at: NotRequired[datetime]
    contact_id: NotRequired[str]
    created_at: NotRequired[datetime]
    currency: NotRequired[str]
    discount_amount: NotRequired[float]
    due_at: NotRequired[datetime]
    id: NotRequired[str]
    invoice_at: NotRequired[datetime]
    invoice_number: NotRequired[str]
    lineitems: NotRequired[List[AccountingLineitemTypedDict]]
    notes: NotRequired[str]
    paid_amount: NotRequired[float]
    paid_at: NotRequired[datetime]
    payment_collection_method: NotRequired[PaymentCollectionMethod]
    posted_at: NotRequired[datetime]
    raw: NotRequired[Dict[str, Any]]
    refund_amount: NotRequired[float]
    refund_reason: NotRequired[str]
    refunded_at: NotRequired[datetime]
    send: NotRequired[bool]
    status: NotRequired[AccountingInvoiceStatus]
    tax_amount: NotRequired[float]
    total_amount: NotRequired[float]
    type: NotRequired[AccountingInvoiceType]
    updated_at: NotRequired[datetime]
    url: NotRequired[str]


class AccountingInvoice(BaseModel):
    attachments: Optional[List[AccountingAttachment]] = None

    balance_amount: Optional[float] = None

    cancelled_at: Optional[datetime] = None

    contact_id: Optional[str] = None

    created_at: Optional[datetime] = None

    currency: Optional[str] = None

    discount_amount: Optional[float] = None

    due_at: Optional[datetime] = None

    id: Optional[str] = None

    invoice_at: Optional[datetime] = None

    invoice_number: Optional[str] = None

    lineitems: Optional[List[AccountingLineitem]] = None

    notes: Optional[str] = None

    paid_amount: Optional[float] = None

    paid_at: Optional[datetime] = None

    payment_collection_method: Optional[PaymentCollectionMethod] = None

    posted_at: Optional[datetime] = None

    raw: Optional[Dict[str, Any]] = None

    refund_amount: Optional[float] = None

    refund_reason: Optional[str] = None

    refunded_at: Optional[datetime] = None

    send: Optional[bool] = None

    status: Optional[AccountingInvoiceStatus] = None

    tax_amount: Optional[float] = None

    total_amount: Optional[float] = None

    type: Optional[AccountingInvoiceType] = None

    updated_at: Optional[datetime] = None

    url: Optional[str] = None
