[![FactSet](https://raw.githubusercontent.com/factset/enterprise-sdk/main/docs/images/factset-logo.svg)](https://www.factset.com)

# Vermilion client library for Python

[![API Version](https://img.shields.io/badge/api-v1.0.0-blue)](https://developer.factset.com/api-catalog/vermilion-api)
[![PyPi](https://img.shields.io/pypi/v/fds.sdk.Vermilion)](https://pypi.org/project/fds.sdk.Vermilion/)
[![Apache-2 license](https://img.shields.io/badge/license-Apache2-brightgreen.svg)](https://www.apache.org/licenses/LICENSE-2.0)

Documentation on all available end points in the VRSAPI

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- SDK version: 1.2.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

For more information, please visit [https://developer.factset.com/contact](https://developer.factset.com/contact)

## Requirements

* Python >= 3.7

## Installation

### Poetry

```shell
poetry add fds.sdk.utils fds.sdk.Vermilion==1.2.0
```

### pip

```shell
pip install fds.sdk.utils fds.sdk.Vermilion==1.2.0
```

## Usage

1. [Generate authentication credentials](../../../../README.md#authentication).
2. Setup Python environment.
   1. Install and activate python 3.7+. If you're using [pyenv](https://github.com/pyenv/pyenv):

      ```sh
      pyenv install 3.9.7
      pyenv shell 3.9.7
      ```

   2. (optional) [Install poetry](https://python-poetry.org/docs/#installation).
3. [Install dependencies](#installation).
4. Run the following:

> [!IMPORTANT]
> The parameter variables defined below are just examples and may potentially contain non valid values. Please replace them with valid values.

### Example Code

```python
from fds.sdk.utils.authentication import ConfidentialClient

import fds.sdk.Vermilion
from fds.sdk.Vermilion.api import datasource_api
from fds.sdk.Vermilion.models import *
from dateutil.parser import parse as dateutil_parser
from pprint import pprint

# See configuration.py for a list of all supported configuration parameters.

# Examples for each supported authentication method are below,
# choose one that satisfies your use case.

# (Preferred) OAuth 2.0: FactSetOAuth2
# See https://github.com/FactSet/enterprise-sdk#oauth-20
# for information on how to create the app-config.json file
#
# The confidential client instance should be reused in production environments.
# See https://github.com/FactSet/enterprise-sdk-utils-python#authentication
# for more information on using the ConfidentialClient class
configuration = fds.sdk.Vermilion.Configuration(
    fds_oauth_client=ConfidentialClient('/path/to/app-config.json')
)

# Basic authentication: FactSetApiKey
# See https://github.com/FactSet/enterprise-sdk#api-key
# for information how to create an API key
# configuration = fds.sdk.Vermilion.Configuration(
#     username='USERNAME-SERIAL',
#     password='API-KEY'
# )

# Enter a context with an instance of the API client
with fds.sdk.Vermilion.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = datasource_api.DatasourceApi(api_client)
    tenant = "TENANT" # str | The code of the tenancy
    sort = ["name"] # [str] | The column to sort on. Append - to sort in descending order. If parameter is not given, no sorting will be done (optional)
    pagination_limit = 10 # int | Non-negative maximum number of entries to return. Default is 25 (optional) if omitted the server will use the default value of 25
    pagination_offset = 0 # int | Non-negative number of entries to skip. Default is 0 (optional) if omitted the server will use the default value of 0

    try:
        # Lists all datasources
        # example passing only required values which don't have defaults set
        # and optional values
        api_response = api_instance.get_all_data_sources(tenant, sort=sort, pagination_limit=pagination_limit, pagination_offset=pagination_offset)

        pprint(api_response)
    except fds.sdk.Vermilion.ApiException as e:
        print("Exception when calling DatasourceApi->get_all_data_sources: %s\n" % e)

    # # Get response, http status code and response headers
    # try:
    #     # Lists all datasources
    #     api_response, http_status_code, response_headers = api_instance.get_all_data_sources_with_http_info(tenant, sort=sort, pagination_limit=pagination_limit, pagination_offset=pagination_offset)


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.Vermilion.ApiException as e:
    #     print("Exception when calling DatasourceApi->get_all_data_sources: %s\n" % e)

    # # Get response asynchronous
    # try:
    #     # Lists all datasources
    #     async_result = api_instance.get_all_data_sources_async(tenant, sort=sort, pagination_limit=pagination_limit, pagination_offset=pagination_offset)
    #     api_response = async_result.get()


    #     pprint(api_response)
    # except fds.sdk.Vermilion.ApiException as e:
    #     print("Exception when calling DatasourceApi->get_all_data_sources: %s\n" % e)

    # # Get response, http status code and response headers asynchronous
    # try:
    #     # Lists all datasources
    #     async_result = api_instance.get_all_data_sources_with_http_info_async(tenant, sort=sort, pagination_limit=pagination_limit, pagination_offset=pagination_offset)
    #     api_response, http_status_code, response_headers = async_result.get()


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.Vermilion.ApiException as e:
    #     print("Exception when calling DatasourceApi->get_all_data_sources: %s\n" % e)

```

### Using Pandas

To convert an API response to a Pandas DataFrame, it is necessary to transform it first to a dictionary.
```python
import pandas as pd

response_dict = api_response.to_dict()['data']

simple_json_response = pd.DataFrame(response_dict)
nested_json_response = pd.json_normalize(response_dict)
```

### Debugging

The SDK uses the standard library [`logging`](https://docs.python.org/3/library/logging.html#module-logging) module.

Setting `debug` to `True` on an instance of the `Configuration` class sets the log-level of related packages to `DEBUG`
and enables additional logging in Pythons [HTTP Client](https://docs.python.org/3/library/http.client.html).

**Note**: This prints out sensitive information (e.g. the full request and response). Use with care.

```python
import logging
import fds.sdk.Vermilion

logging.basicConfig(level=logging.DEBUG)

configuration = fds.sdk.Vermilion.Configuration(...)
configuration.debug = True
```

### Configure a Proxy

You can pass proxy settings to the Configuration class:

* `proxy`: The URL of the proxy to use.
* `proxy_headers`: a dictionary to pass additional headers to the proxy (e.g. `Proxy-Authorization`).

```python
import fds.sdk.Vermilion

configuration = fds.sdk.Vermilion.Configuration(
    # ...
    proxy="http://secret:password@localhost:5050",
    proxy_headers={
        "Custom-Proxy-Header": "Custom-Proxy-Header-Value"
    }
)
```

### Custom SSL Certificate

TLS/SSL certificate verification can be configured with the following Configuration parameters:

* `ssl_ca_cert`: a path to the certificate to use for verification in `PEM` format.
* `verify_ssl`: setting this to `False` disables the verification of certificates.
  Disabling the verification is not recommended, but it might be useful during
  local development or testing.

```python
import fds.sdk.Vermilion

configuration = fds.sdk.Vermilion.Configuration(
    # ...
    ssl_ca_cert='/path/to/ca.pem'
)
```

### Request Retries

In case the request retry behaviour should be customized, it is possible to pass a `urllib3.Retry` object to the `retry` property of the Configuration.

```python
from urllib3 import Retry
import fds.sdk.Vermilion

configuration = fds.sdk.Vermilion.Configuration(
    # ...
)

configuration.retries = Retry(total=3, status_forcelist=[500, 502, 503, 504])
```


## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DatasourceApi* | [**get_all_data_sources**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DatasourceApi.md#get_all_data_sources) | **GET** /v1/{tenant}/data-sources | Lists all datasources
*DatasourceApi* | [**get_data_source_by_code**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DatasourceApi.md#get_data_source_by_code) | **GET** /v1/{tenant}/data-sources/{dataSourceCode} | Gets a datasource
*DatasourceApi* | [**get_data_source_data**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DatasourceApi.md#get_data_source_data) | **GET** /v1/{tenant}/data-sources/{dataSourceCode}/data | Gets the data for the datasource
*EntityApi* | [**get_entity_values_by_code**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/EntityApi.md#get_entity_values_by_code) | **GET** /v1/{tenant}/entities/{entityCode}/values | Gets the entity values
*ReportApi* | [**get_all_report_definitions**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportApi.md#get_all_report_definitions) | **GET** /v1/{tenant}/reports | Gets all report definitions
*ReportApi* | [**get_report_definition_by_code**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportApi.md#get_report_definition_by_code) | **GET** /v1/{tenant}/reports/{reportDefinitionCode} | Gets a report definition
*ReportInstanceApi* | [**cancel_report_generation**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceApi.md#cancel_report_generation) | **DELETE** /v1/{tenant}/report-instances/{reportInstanceId} | Cancels a report generation
*ReportInstanceApi* | [**download_report_file**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceApi.md#download_report_file) | **GET** /v1/{tenant}/report-instances/{reportInstanceId}/results/{reportFileName} | Gets the generated file
*ReportInstanceApi* | [**get_all_report_instances**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceApi.md#get_all_report_instances) | **GET** /v1/{tenant}/report-instances | Gets a list of report instances
*ReportInstanceApi* | [**get_report_generation_logs**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceApi.md#get_report_generation_logs) | **GET** /v1/{tenant}/report-instances/{reportInstanceId}/logs | Gets a list of logs for the report instance generation
*ReportInstanceApi* | [**get_report_instance_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceApi.md#get_report_instance_by_id) | **GET** /v1/{tenant}/report-instances/{reportInstanceId} | Gets a report instance based on the ID
*ReportInstanceApi* | [**start_report_generation**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceApi.md#start_report_generation) | **POST** /v1/report-instances/generate | Generates a report
*SCIMApi* | [**create_group**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#create_group) | **POST** /scim/v2/Groups | Creates a role
*SCIMApi* | [**create_user**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#create_user) | **POST** /scim/v2/Users | Creates a user
*SCIMApi* | [**delete_group_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#delete_group_by_id) | **DELETE** /scim/v2/Groups/{groupId} | Deletes a VRS role
*SCIMApi* | [**delete_user_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#delete_user_by_id) | **DELETE** /scim/v2/Users/{userId} | Deletes a VRS user
*SCIMApi* | [**get_all_groups**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#get_all_groups) | **GET** /scim/v2/Groups | Retrieves a list of VRS role
*SCIMApi* | [**get_all_users**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#get_all_users) | **GET** /scim/v2/Users | Retrieves a list of VRS users
*SCIMApi* | [**get_group_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#get_group_by_id) | **GET** /scim/v2/Groups/{groupId} | Retrieves a VRS role
*SCIMApi* | [**get_user_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#get_user_by_id) | **GET** /scim/v2/Users/{userId} | Retrieves a VRS User
*SCIMApi* | [**patch_group_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#patch_group_by_id) | **PATCH** /scim/v2/Groups/{groupId} | Add or remove a user to/from a group
*SCIMApi* | [**patch_user_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#patch_user_by_id) | **PATCH** /scim/v2/Users/{userId} | Add or remove VRS user attributes
*SCIMApi* | [**update_group_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#update_group_by_id) | **PUT** /scim/v2/Groups/{groupId} | Updates a VRS Group
*SCIMApi* | [**update_user_by_id**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SCIMApi.md#update_user_by_id) | **PUT** /scim/v2/Users/{userId} | Updates a VRS user
*VersionApi* | [**get_version**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/VersionApi.md#get_version) | **GET** /v1/version | Gets the version of VRS,WRS and DBServer
*WorkflowApi* | [**generate_schedule**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/WorkflowApi.md#generate_schedule) | **POST** /v1/{tenant}/schedules/{scheduleDefinitionCode} | Creates schedule for the specified schedule definition
*WorkflowApi* | [**get_schedule_definitions**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/WorkflowApi.md#get_schedule_definitions) | **GET** /v1/{tenant}/schedule-definitions | Retrieves a list of all schedule definitions
*WorkflowApi* | [**get_schedule_generation_logs**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/WorkflowApi.md#get_schedule_generation_logs) | **GET** /v1/{tenant}/schedules/{scheduleId}/logs | Gets the generation logs for a specific schedule
*WorkflowApi* | [**get_schedules**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/WorkflowApi.md#get_schedules) | **GET** /v1/{tenant}/schedules | Retrieves a list of all schedules
*WorkflowApi* | [**update_schedule_status**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/WorkflowApi.md#update_schedule_status) | **PATCH** /v1/{tenant}/schedules/{scheduleId}/{status} | Update schedule status for specified schedule


## Documentation For Models

 - [CreateScimUserJSONRequest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/CreateScimUserJSONRequest.md)
 - [CreatedScimUserJSONResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/CreatedScimUserJSONResponse.md)
 - [CreatedScimUserJSONResponseMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/CreatedScimUserJSONResponseMeta.md)
 - [DataSourceAllData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceAllData.md)
 - [DataSourceDTO](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceDTO.md)
 - [DataSourceData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceData.md)
 - [DataSourceDataInstance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceDataInstance.md)
 - [DataSourceInstance](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceInstance.md)
 - [DataSourceInstanceRows](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceInstanceRows.md)
 - [DataSourceList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceList.md)
 - [DataSourceListMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceListMeta.md)
 - [DataSourceListMetaPagination](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/DataSourceListMetaPagination.md)
 - [EntityDTO](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/EntityDTO.md)
 - [EntityFieldValueDTO](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/EntityFieldValueDTO.md)
 - [EntitySelection](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/EntitySelection.md)
 - [Error](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/Error.md)
 - [ErrorList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ErrorList.md)
 - [GenerateScheduleResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/GenerateScheduleResponse.md)
 - [RecordSetFieldValues](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/RecordSetFieldValues.md)
 - [RecordSetFields](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/RecordSetFields.md)
 - [ReportDefinitionDTO](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportDefinitionDTO.md)
 - [ReportDefinitionData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportDefinitionData.md)
 - [ReportDefinitionList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportDefinitionList.md)
 - [ReportGenerationRequest](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportGenerationRequest.md)
 - [ReportGenerationRequestBody](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportGenerationRequestBody.md)
 - [ReportInstanceDTO](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceDTO.md)
 - [ReportInstanceData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceData.md)
 - [ReportInstanceDataResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceDataResponse.md)
 - [ReportInstanceId](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceId.md)
 - [ReportInstanceList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceList.md)
 - [ReportInstanceListMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceListMeta.md)
 - [ReportInstanceLogDTO](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceLogDTO.md)
 - [ReportInstanceLogList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportInstanceLogList.md)
 - [ReportRevisionDTO](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ReportRevisionDTO.md)
 - [ScheduleData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleData.md)
 - [ScheduleDefinition](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleDefinition.md)
 - [ScheduleDefinitionOwnerRole](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleDefinitionOwnerRole.md)
 - [ScheduleDefinitionsList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleDefinitionsList.md)
 - [ScheduleGenerationLog](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleGenerationLog.md)
 - [ScheduleGenerationLogList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleGenerationLogList.md)
 - [ScheduleInstanceData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleInstanceData.md)
 - [ScheduleStatusUpdateResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScheduleStatusUpdateResponse.md)
 - [SchedulesList](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/SchedulesList.md)
 - [ScimEmail](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimEmail.md)
 - [ScimError](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimError.md)
 - [ScimGroup](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimGroup.md)
 - [ScimGroupListResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimGroupListResponse.md)
 - [ScimGroupMember](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimGroupMember.md)
 - [ScimGroupPatchOperation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimGroupPatchOperation.md)
 - [ScimGroupPatchOperationValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimGroupPatchOperationValue.md)
 - [ScimGroupPatchRequestBody](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimGroupPatchRequestBody.md)
 - [ScimMeta](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimMeta.md)
 - [ScimPhone](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimPhone.md)
 - [ScimPhoto](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimPhoto.md)
 - [ScimUser](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimUser.md)
 - [ScimUserGroup](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimUserGroup.md)
 - [ScimUserListResponse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimUserListResponse.md)
 - [ScimUserName](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimUserName.md)
 - [ScimUserPatchOperation](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimUserPatchOperation.md)
 - [ScimUserPatchRequestBody](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/ScimUserPatchRequestBody.md)
 - [Tenancy](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/Tenancy.md)
 - [VersionResponseBody](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/VersionResponseBody.md)
 - [VersionResponseBodyData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/Vermilion/v1/docs/VersionResponseBodyData.md)


## Documentation For Authorization


## FactSetApiKey

- **Type**: HTTP basic authentication


## FactSetOAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in fds.sdk.Vermilion.apis and fds.sdk.Vermilion.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from fds.sdk.Vermilion.api.default_api import DefaultApi`
- `from fds.sdk.Vermilion.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import fds.sdk.Vermilion
from fds.sdk.Vermilion.apis import *
from fds.sdk.Vermilion.models import *
```

## Contributing

Please refer to the [contributing guide](../../../../CONTRIBUTING.md).

## Copyright

Copyright 2022 FactSet Research Systems Inc

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

