"""
    VRS API documentation

    Documentation on all available end points in the VRSAPI  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.Vermilion.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.Vermilion.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.Vermilion.exceptions import ApiException
from fds.sdk.Vermilion.model.data_source_data import DataSourceData
from fds.sdk.Vermilion.model.data_source_data_instance import DataSourceDataInstance
from fds.sdk.Vermilion.model.data_source_list import DataSourceList
from fds.sdk.Vermilion.model.error_list import ErrorList





class DatasourceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_all_data_sources_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataSourceList,), 401: (ErrorList,), 403: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/data-sources',
                'operation_id': 'get_all_data_sources',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_data_source_by_code_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataSourceData,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/data-sources/{dataSourceCode}',
                'operation_id': 'get_data_source_by_code',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'data_source_code',
                ],
                'required': [
                    'tenant',
                    'data_source_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'data_source_code':
                        (str,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'data_source_code': 'dataSourceCode',
                },
                'location_map': {
                    'tenant': 'path',
                    'data_source_code': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_data_source_data_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (DataSourceDataInstance,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/data-sources/{dataSourceCode}/data',
                'operation_id': 'get_data_source_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'data_source_code',
                    'entity_codes',
                    'entity_keys',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                    'data_source_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'data_source_code':
                        (str,),
                    'entity_codes':
                        (str,),
                    'entity_keys':
                        (str,),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'data_source_code': 'dataSourceCode',
                    'entity_codes': 'entityCodes',
                    'entity_keys': 'entityKeys',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'data_source_code': 'path',
                    'entity_codes': 'query',
                    'entity_keys': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_all_data_sources(
        self,
        tenant,
        **kwargs
    ) -> DataSourceList:
        """Lists all datasources  # noqa: E501

        List all datasources the user has permission to see  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, no sorting will be done. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataSourceList
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_all_data_sources_endpoint.call_with_http_info(**kwargs)

    def get_all_data_sources_with_http_info(
        self,
        tenant,
        **kwargs
    ) -> typing.Tuple[DataSourceList, int, typing.MutableMapping]:
        """Lists all datasources  # noqa: E501

        List all datasources the user has permission to see  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, no sorting will be done. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataSourceList
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_all_data_sources_endpoint.call_with_http_info(**kwargs)

    def get_all_data_sources_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[DataSourceList]":
        """Lists all datasources  # noqa: E501

        List all datasources the user has permission to see  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, no sorting will be done. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataSourceList]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_all_data_sources_endpoint.call_with_http_info(**kwargs)

    def get_all_data_sources_with_http_info_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataSourceList, int, typing.MutableMapping]]":
        """Lists all datasources  # noqa: E501

        List all datasources the user has permission to see  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, no sorting will be done. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataSourceList, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_all_data_sources_endpoint.call_with_http_info(**kwargs)


    def get_data_source_by_code(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> DataSourceData:
        """Gets a datasource  # noqa: E501

        Gets a datasource based on the code passed  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataSourceData
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_by_code_endpoint.call_with_http_info(**kwargs)

    def get_data_source_by_code_with_http_info(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> typing.Tuple[DataSourceData, int, typing.MutableMapping]:
        """Gets a datasource  # noqa: E501

        Gets a datasource based on the code passed  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataSourceData
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_by_code_endpoint.call_with_http_info(**kwargs)

    def get_data_source_by_code_async(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> "ApplyResult[DataSourceData]":
        """Gets a datasource  # noqa: E501

        Gets a datasource based on the code passed  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataSourceData]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_by_code_endpoint.call_with_http_info(**kwargs)

    def get_data_source_by_code_with_http_info_async(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataSourceData, int, typing.MutableMapping]]":
        """Gets a datasource  # noqa: E501

        Gets a datasource based on the code passed  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataSourceData, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_by_code_endpoint.call_with_http_info(**kwargs)


    def get_data_source_data(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> DataSourceDataInstance:
        """Gets the data for the datasource  # noqa: E501

        Gets the data for the datasource. There are optional query parameters to filter the data  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            entity_codes (str): A series of query parameter used to filter the data for a datasource. This represents the entities for the datasource. E.g.: entityCodes=ACCOUNT&entityCodes=FUNDS. [optional]
            entity_keys (str): A series of query parameter used to filter the data for a datasource. This is the entity key value for an entity selection. E.g.: entityKeys=1&entityKeys=Test2. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataSourceDataInstance
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_data_endpoint.call_with_http_info(**kwargs)

    def get_data_source_data_with_http_info(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> typing.Tuple[DataSourceDataInstance, int, typing.MutableMapping]:
        """Gets the data for the datasource  # noqa: E501

        Gets the data for the datasource. There are optional query parameters to filter the data  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            entity_codes (str): A series of query parameter used to filter the data for a datasource. This represents the entities for the datasource. E.g.: entityCodes=ACCOUNT&entityCodes=FUNDS. [optional]
            entity_keys (str): A series of query parameter used to filter the data for a datasource. This is the entity key value for an entity selection. E.g.: entityKeys=1&entityKeys=Test2. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            DataSourceDataInstance
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_data_endpoint.call_with_http_info(**kwargs)

    def get_data_source_data_async(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> "ApplyResult[DataSourceDataInstance]":
        """Gets the data for the datasource  # noqa: E501

        Gets the data for the datasource. There are optional query parameters to filter the data  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            entity_codes (str): A series of query parameter used to filter the data for a datasource. This represents the entities for the datasource. E.g.: entityCodes=ACCOUNT&entityCodes=FUNDS. [optional]
            entity_keys (str): A series of query parameter used to filter the data for a datasource. This is the entity key value for an entity selection. E.g.: entityKeys=1&entityKeys=Test2. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[DataSourceDataInstance]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_data_endpoint.call_with_http_info(**kwargs)

    def get_data_source_data_with_http_info_async(
        self,
        tenant,
        data_source_code,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[DataSourceDataInstance, int, typing.MutableMapping]]":
        """Gets the data for the datasource  # noqa: E501

        Gets the data for the datasource. There are optional query parameters to filter the data  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            data_source_code (str): The code of the datasource

        Keyword Args:
            entity_codes (str): A series of query parameter used to filter the data for a datasource. This represents the entities for the datasource. E.g.: entityCodes=ACCOUNT&entityCodes=FUNDS. [optional]
            entity_keys (str): A series of query parameter used to filter the data for a datasource. This is the entity key value for an entity selection. E.g.: entityKeys=1&entityKeys=Test2. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(DataSourceDataInstance, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['data_source_code'] = \
            data_source_code
        return self.get_data_source_data_endpoint.call_with_http_info(**kwargs)


