"""
    VRS API documentation

    Documentation on all available end points in the VRSAPI  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.Vermilion.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.Vermilion.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.Vermilion.exceptions import ApiException
from fds.sdk.Vermilion.model.entity_field_value_dto import EntityFieldValueDTO
from fds.sdk.Vermilion.model.error_list import ErrorList





class EntityApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_entity_values_by_code_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (EntityFieldValueDTO,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/entities/{entityCode}/values',
                'operation_id': 'get_entity_values_by_code',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'entity_code',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                    'show_all',
                ],
                'required': [
                    'tenant',
                    'entity_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'entity_code':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                    'show_all':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'entity_code': 'entityCode',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                    'show_all': 'showAll',
                },
                'location_map': {
                    'tenant': 'path',
                    'entity_code': 'path',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                    'show_all': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_entity_values_by_code(
        self,
        tenant,
        entity_code,
        **kwargs
    ) -> EntityFieldValueDTO:
        """Gets the entity values  # noqa: E501

        Gets the entity values for the specified entity  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            entity_code (str): The code of the entity

        Keyword Args:
            sort ([str]): The entity field to sort on. Can only be sorted on entity key, description or secondary key fields. Append \"-\" to sort in descending order. If no parameter given, it will be sorted by key field in ascending order by default. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            show_all (int): Whether to show all field values for each entity row. Value should either be 1 or 0. Default is 0 (false). Otherwise, show all field values in a JSON array named \"fieldsWithValues\", with each array value being a string in the format of \"**<FIELD_NAME> : <FIELD_VALUE>**\". Both key and description field values will be included in this JSON array too.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityFieldValueDTO
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['entity_code'] = \
            entity_code
        return self.get_entity_values_by_code_endpoint.call_with_http_info(**kwargs)

    def get_entity_values_by_code_with_http_info(
        self,
        tenant,
        entity_code,
        **kwargs
    ) -> typing.Tuple[EntityFieldValueDTO, int, typing.MutableMapping]:
        """Gets the entity values  # noqa: E501

        Gets the entity values for the specified entity  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            entity_code (str): The code of the entity

        Keyword Args:
            sort ([str]): The entity field to sort on. Can only be sorted on entity key, description or secondary key fields. Append \"-\" to sort in descending order. If no parameter given, it will be sorted by key field in ascending order by default. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            show_all (int): Whether to show all field values for each entity row. Value should either be 1 or 0. Default is 0 (false). Otherwise, show all field values in a JSON array named \"fieldsWithValues\", with each array value being a string in the format of \"**<FIELD_NAME> : <FIELD_VALUE>**\". Both key and description field values will be included in this JSON array too.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            EntityFieldValueDTO
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['entity_code'] = \
            entity_code
        return self.get_entity_values_by_code_endpoint.call_with_http_info(**kwargs)

    def get_entity_values_by_code_async(
        self,
        tenant,
        entity_code,
        **kwargs
    ) -> "ApplyResult[EntityFieldValueDTO]":
        """Gets the entity values  # noqa: E501

        Gets the entity values for the specified entity  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            entity_code (str): The code of the entity

        Keyword Args:
            sort ([str]): The entity field to sort on. Can only be sorted on entity key, description or secondary key fields. Append \"-\" to sort in descending order. If no parameter given, it will be sorted by key field in ascending order by default. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            show_all (int): Whether to show all field values for each entity row. Value should either be 1 or 0. Default is 0 (false). Otherwise, show all field values in a JSON array named \"fieldsWithValues\", with each array value being a string in the format of \"**<FIELD_NAME> : <FIELD_VALUE>**\". Both key and description field values will be included in this JSON array too.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[EntityFieldValueDTO]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['entity_code'] = \
            entity_code
        return self.get_entity_values_by_code_endpoint.call_with_http_info(**kwargs)

    def get_entity_values_by_code_with_http_info_async(
        self,
        tenant,
        entity_code,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[EntityFieldValueDTO, int, typing.MutableMapping]]":
        """Gets the entity values  # noqa: E501

        Gets the entity values for the specified entity  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            entity_code (str): The code of the entity

        Keyword Args:
            sort ([str]): The entity field to sort on. Can only be sorted on entity key, description or secondary key fields. Append \"-\" to sort in descending order. If no parameter given, it will be sorted by key field in ascending order by default. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. Default is 25. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. Default is 0. [optional] if omitted the server will use the default value of 0
            show_all (int): Whether to show all field values for each entity row. Value should either be 1 or 0. Default is 0 (false). Otherwise, show all field values in a JSON array named \"fieldsWithValues\", with each array value being a string in the format of \"**<FIELD_NAME> : <FIELD_VALUE>**\". Both key and description field values will be included in this JSON array too.. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(EntityFieldValueDTO, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['entity_code'] = \
            entity_code
        return self.get_entity_values_by_code_endpoint.call_with_http_info(**kwargs)


