"""
    VRS API documentation

    Documentation on all available end points in the VRSAPI  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.Vermilion.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.Vermilion.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.Vermilion.exceptions import ApiException
from fds.sdk.Vermilion.model.error_list import ErrorList
from fds.sdk.Vermilion.model.report_definition_data import ReportDefinitionData
from fds.sdk.Vermilion.model.report_definition_list import ReportDefinitionList





class ReportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.get_all_report_definitions_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ReportDefinitionList,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/reports',
                'operation_id': 'get_all_report_definitions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_report_definition_by_code_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ReportDefinitionData,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/reports/{reportDefinitionCode}',
                'operation_id': 'get_report_definition_by_code',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'report_definition_code',
                ],
                'required': [
                    'tenant',
                    'report_definition_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'report_definition_code':
                        (str,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'report_definition_code': 'reportDefinitionCode',
                },
                'location_map': {
                    'tenant': 'path',
                    'report_definition_code': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def get_all_report_definitions(
        self,
        tenant,
        **kwargs
    ) -> ReportDefinitionList:
        """Gets all report definitions  # noqa: E501

        Gets all report definitions the user has permissions for  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportDefinitionList
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_definitions_endpoint.call_with_http_info(**kwargs)

    def get_all_report_definitions_with_http_info(
        self,
        tenant,
        **kwargs
    ) -> typing.Tuple[ReportDefinitionList, int, typing.MutableMapping]:
        """Gets all report definitions  # noqa: E501

        Gets all report definitions the user has permissions for  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportDefinitionList
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_definitions_endpoint.call_with_http_info(**kwargs)

    def get_all_report_definitions_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[ReportDefinitionList]":
        """Gets all report definitions  # noqa: E501

        Gets all report definitions the user has permissions for  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ReportDefinitionList]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_definitions_endpoint.call_with_http_info(**kwargs)

    def get_all_report_definitions_with_http_info_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ReportDefinitionList, int, typing.MutableMapping]]":
        """Gets all report definitions  # noqa: E501

        Gets all report definitions the user has permissions for  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ReportDefinitionList, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_definitions_endpoint.call_with_http_info(**kwargs)


    def get_report_definition_by_code(
        self,
        tenant,
        report_definition_code,
        **kwargs
    ) -> ReportDefinitionData:
        """Gets a report definition  # noqa: E501

        Gets a report defintion based on the code specified  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            report_definition_code (str): The code of the report definition

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportDefinitionData
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_definition_code'] = \
            report_definition_code
        return self.get_report_definition_by_code_endpoint.call_with_http_info(**kwargs)

    def get_report_definition_by_code_with_http_info(
        self,
        tenant,
        report_definition_code,
        **kwargs
    ) -> typing.Tuple[ReportDefinitionData, int, typing.MutableMapping]:
        """Gets a report definition  # noqa: E501

        Gets a report defintion based on the code specified  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            report_definition_code (str): The code of the report definition

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportDefinitionData
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_definition_code'] = \
            report_definition_code
        return self.get_report_definition_by_code_endpoint.call_with_http_info(**kwargs)

    def get_report_definition_by_code_async(
        self,
        tenant,
        report_definition_code,
        **kwargs
    ) -> "ApplyResult[ReportDefinitionData]":
        """Gets a report definition  # noqa: E501

        Gets a report defintion based on the code specified  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_definition_code (str): The code of the report definition

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ReportDefinitionData]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_definition_code'] = \
            report_definition_code
        return self.get_report_definition_by_code_endpoint.call_with_http_info(**kwargs)

    def get_report_definition_by_code_with_http_info_async(
        self,
        tenant,
        report_definition_code,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ReportDefinitionData, int, typing.MutableMapping]]":
        """Gets a report definition  # noqa: E501

        Gets a report defintion based on the code specified  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_definition_code (str): The code of the report definition

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ReportDefinitionData, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_definition_code'] = \
            report_definition_code
        return self.get_report_definition_by_code_endpoint.call_with_http_info(**kwargs)


