"""
    VRS API documentation

    Documentation on all available end points in the VRSAPI  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.Vermilion.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.Vermilion.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.Vermilion.exceptions import ApiException
from fds.sdk.Vermilion.model.error_list import ErrorList
from fds.sdk.Vermilion.model.generate_schedule_response import GenerateScheduleResponse
from fds.sdk.Vermilion.model.schedule_definitions_list import ScheduleDefinitionsList
from fds.sdk.Vermilion.model.schedule_generation_log_list import ScheduleGenerationLogList
from fds.sdk.Vermilion.model.schedule_status_update_response import ScheduleStatusUpdateResponse
from fds.sdk.Vermilion.model.schedules_list import SchedulesList





class WorkflowApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.generate_schedule_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 202: (GenerateScheduleResponse,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/schedules/{scheduleDefinitionCode}',
                'operation_id': 'generate_schedule',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'schedule_definition_code',
                    'set_to_running',
                ],
                'required': [
                    'tenant',
                    'schedule_definition_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'schedule_definition_code':
                        (str,),
                    'set_to_running':
                        (bool,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'schedule_definition_code': 'scheduleDefinitionCode',
                    'set_to_running': 'setToRunning',
                },
                'location_map': {
                    'tenant': 'path',
                    'schedule_definition_code': 'path',
                    'set_to_running': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_schedule_definitions_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ScheduleDefinitionsList,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/schedule-definitions',
                'operation_id': 'get_schedule_definitions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'schedule_type',
                    'report_date',
                    'last_updated_by',
                    'start_date',
                    'end_date',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                ],
                'nullable': [
                ],
                'enum': [
                    'schedule_type',
                    'report_date',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                    ('schedule_type',): {

                        "MANUAL": "MANUAL",
                        "REPEATING": "REPEATING",
                        "TEMPLATE": "TEMPLATE",
                        "ADHOC": "ADHOC"
                    },
                    ('report_date',): {

                        "LAST_DAY_OF_PREV_MONTH": "LAST_DAY_OF_PREV_MONTH",
                        "LAST_BUSINESS_DAY_OF_PREV_MONTH": "LAST_BUSINESS_DAY_OF_PREV_MONTH",
                        "CREATION_DATE": "CREATION_DATE",
                        "DAY_BEFORE_CREATION_DATE": "DAY_BEFORE_CREATION_DATE",
                        "BUSINESS_DAY_BEFORE_CREATION_DATE": "BUSINESS_DAY_BEFORE_CREATION_DATE",
                        "LAST_DAY_OF_MONTH_SCHEDULE_CREATED": "LAST_DAY_OF_MONTH_SCHEDULE_CREATED",
                        "LAST_BUSINESS_DAY_OF_MONTH_SCHEDULE_CREATED": "LAST_BUSINESS_DAY_OF_MONTH_SCHEDULE_CREATED",
                        "LAST_BUSINESS_DAY_OF_PREVIOUS_WEEK_SCHEDULE_CREATED": "LAST_BUSINESS_DAY_OF_PREVIOUS_WEEK_SCHEDULE_CREATED",
                        "LAST_BUSINESS_DAY_OF_WEEK_SCHEDULE_CREATED": "LAST_BUSINESS_DAY_OF_WEEK_SCHEDULE_CREATED",
                        "TWO_BUSINESS_DAYS_BEFORE_SCHEDULE_CREATED": "TWO_BUSINESS_DAYS_BEFORE_SCHEDULE_CREATED"
                    },
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'schedule_type':
                        (str,),
                    'report_date':
                        (str,),
                    'last_updated_by':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'schedule_type': 'scheduleType',
                    'report_date': 'reportDate',
                    'last_updated_by': 'lastUpdatedBy',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'schedule_type': 'query',
                    'report_date': 'query',
                    'last_updated_by': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_schedule_generation_logs_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ScheduleGenerationLogList,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/schedules/{scheduleId}/logs',
                'operation_id': 'get_schedule_generation_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'schedule_id',
                    'type',
                    'message',
                    'log_set',
                    'start_date',
                    'end_date',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                    'schedule_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'type',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                    ('type',): {

                        "INFO": "INFO",
                        "WARN": "WARN",
                        "SUCCESS": "SUCCESS",
                        "ERROR": "ERROR",
                        "DEBUG": "DEBUG",
                        "FINISHED": "FINISHED"
                    },
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'schedule_id':
                        (str,),
                    'type':
                        (str,),
                    'message':
                        (str,),
                    'log_set':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'schedule_id': 'scheduleId',
                    'type': 'type',
                    'message': 'message',
                    'log_set': 'logSet',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'schedule_id': 'path',
                    'type': 'query',
                    'message': 'query',
                    'log_set': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_schedules_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (SchedulesList,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/schedules',
                'operation_id': 'get_schedules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'status',
                    'start_date',
                    'end_date',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "INITIALISED": "INITIALISED",
                        "RUNNING": "RUNNING",
                        "CANCELLED": "CANCELLED",
                        "SUSPENDED": "SUSPENDED",
                        "FINISHED": "FINISHED",
                        "CLOSED": "CLOSED",
                        "GENERATING_TASKS": "GENERATING_TASKS"
                    },
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'status':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'status': 'status',
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'status': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.update_schedule_status_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ScheduleStatusUpdateResponse,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/schedules/{scheduleId}/{status}',
                'operation_id': 'update_schedule_status',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'schedule_id',
                    'status',
                ],
                'required': [
                    'tenant',
                    'schedule_id',
                    'status',
                ],
                'nullable': [
                ],
                'enum': [
                    'status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "INITIALISED": "INITIALISED",
                        "RUNNING": "RUNNING",
                        "CANCELLED": "CANCELLED",
                        "SUSPENDED": "SUSPENDED",
                        "FINISHED": "FINISHED",
                        "CLOSED": "CLOSED",
                        "GENERATING_TASKS": "GENERATING_TASKS"
                    },
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'schedule_id':
                        (str,),
                    'status':
                        (str,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'schedule_id': 'scheduleId',
                    'status': 'status',
                },
                'location_map': {
                    'tenant': 'path',
                    'schedule_id': 'path',
                    'status': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def generate_schedule(
        self,
        tenant,
        schedule_definition_code,
        **kwargs
    ) -> GenerateScheduleResponse:
        """Creates schedule for the specified schedule definition  # noqa: E501

        Creates schedule for the specified Schedule Definition code and sets to running based on the param in the JSON in the request body  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            schedule_definition_code (str): The schedule definition code for which to generate the schedule

        Keyword Args:
            set_to_running (bool): This parameter is used to set the generated schedule's status to Running.If parameter is set to true, the generated schedule will be set to Running. If no value is provided, the schedule will remain in Initialised status.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            GenerateScheduleResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_definition_code'] = \
            schedule_definition_code
        return self.generate_schedule_endpoint.call_with_http_info(**kwargs)

    def generate_schedule_with_http_info(
        self,
        tenant,
        schedule_definition_code,
        **kwargs
    ) -> typing.Tuple[GenerateScheduleResponse, int, typing.MutableMapping]:
        """Creates schedule for the specified schedule definition  # noqa: E501

        Creates schedule for the specified Schedule Definition code and sets to running based on the param in the JSON in the request body  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            schedule_definition_code (str): The schedule definition code for which to generate the schedule

        Keyword Args:
            set_to_running (bool): This parameter is used to set the generated schedule's status to Running.If parameter is set to true, the generated schedule will be set to Running. If no value is provided, the schedule will remain in Initialised status.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            GenerateScheduleResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_definition_code'] = \
            schedule_definition_code
        return self.generate_schedule_endpoint.call_with_http_info(**kwargs)

    def generate_schedule_async(
        self,
        tenant,
        schedule_definition_code,
        **kwargs
    ) -> "ApplyResult[GenerateScheduleResponse]":
        """Creates schedule for the specified schedule definition  # noqa: E501

        Creates schedule for the specified Schedule Definition code and sets to running based on the param in the JSON in the request body  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            schedule_definition_code (str): The schedule definition code for which to generate the schedule

        Keyword Args:
            set_to_running (bool): This parameter is used to set the generated schedule's status to Running.If parameter is set to true, the generated schedule will be set to Running. If no value is provided, the schedule will remain in Initialised status.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[GenerateScheduleResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_definition_code'] = \
            schedule_definition_code
        return self.generate_schedule_endpoint.call_with_http_info(**kwargs)

    def generate_schedule_with_http_info_async(
        self,
        tenant,
        schedule_definition_code,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[GenerateScheduleResponse, int, typing.MutableMapping]]":
        """Creates schedule for the specified schedule definition  # noqa: E501

        Creates schedule for the specified Schedule Definition code and sets to running based on the param in the JSON in the request body  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            schedule_definition_code (str): The schedule definition code for which to generate the schedule

        Keyword Args:
            set_to_running (bool): This parameter is used to set the generated schedule's status to Running.If parameter is set to true, the generated schedule will be set to Running. If no value is provided, the schedule will remain in Initialised status.. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(GenerateScheduleResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_definition_code'] = \
            schedule_definition_code
        return self.generate_schedule_endpoint.call_with_http_info(**kwargs)


    def get_schedule_definitions(
        self,
        tenant,
        **kwargs
    ) -> ScheduleDefinitionsList:
        """Retrieves a list of all schedule definitions  # noqa: E501

        Retrieves all schedule definitions the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            schedule_type (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule type. Accepts multiple values separated by a comma, e.g. ?scheduleType=REPEATING,TEMPLATE. [optional]
            report_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule report date.  Accepts multiple values separated by a comma, e.g. ?reportDate=LAST_DAY_OF_PREV_MONTH,CREATION_DATE. [optional]
            last_updated_by (str): Acts as a filter for the retrieval process. Filters the schedule definitions where the provided parameter value matches or is a substring of the last updated by value of the schedule definitions. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ScheduleDefinitionsList
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_schedule_definitions_endpoint.call_with_http_info(**kwargs)

    def get_schedule_definitions_with_http_info(
        self,
        tenant,
        **kwargs
    ) -> typing.Tuple[ScheduleDefinitionsList, int, typing.MutableMapping]:
        """Retrieves a list of all schedule definitions  # noqa: E501

        Retrieves all schedule definitions the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            schedule_type (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule type. Accepts multiple values separated by a comma, e.g. ?scheduleType=REPEATING,TEMPLATE. [optional]
            report_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule report date.  Accepts multiple values separated by a comma, e.g. ?reportDate=LAST_DAY_OF_PREV_MONTH,CREATION_DATE. [optional]
            last_updated_by (str): Acts as a filter for the retrieval process. Filters the schedule definitions where the provided parameter value matches or is a substring of the last updated by value of the schedule definitions. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ScheduleDefinitionsList
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_schedule_definitions_endpoint.call_with_http_info(**kwargs)

    def get_schedule_definitions_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[ScheduleDefinitionsList]":
        """Retrieves a list of all schedule definitions  # noqa: E501

        Retrieves all schedule definitions the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            schedule_type (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule type. Accepts multiple values separated by a comma, e.g. ?scheduleType=REPEATING,TEMPLATE. [optional]
            report_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule report date.  Accepts multiple values separated by a comma, e.g. ?reportDate=LAST_DAY_OF_PREV_MONTH,CREATION_DATE. [optional]
            last_updated_by (str): Acts as a filter for the retrieval process. Filters the schedule definitions where the provided parameter value matches or is a substring of the last updated by value of the schedule definitions. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ScheduleDefinitionsList]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_schedule_definitions_endpoint.call_with_http_info(**kwargs)

    def get_schedule_definitions_with_http_info_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ScheduleDefinitionsList, int, typing.MutableMapping]]":
        """Retrieves a list of all schedule definitions  # noqa: E501

        Retrieves all schedule definitions the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            schedule_type (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule type. Accepts multiple values separated by a comma, e.g. ?scheduleType=REPEATING,TEMPLATE. [optional]
            report_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions that match the given schedule report date.  Accepts multiple values separated by a comma, e.g. ?reportDate=LAST_DAY_OF_PREV_MONTH,CREATION_DATE. [optional]
            last_updated_by (str): Acts as a filter for the retrieval process. Filters the schedule definitions where the provided parameter value matches or is a substring of the last updated by value of the schedule definitions. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedule definitions based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ScheduleDefinitionsList, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_schedule_definitions_endpoint.call_with_http_info(**kwargs)


    def get_schedule_generation_logs(
        self,
        tenant,
        schedule_id,
        **kwargs
    ) -> ScheduleGenerationLogList:
        """Gets the generation logs for a specific schedule  # noqa: E501

        Gets the generation logs for a specific schedule based on the Schedule ID. Allows the user to sort and filter logs.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The scheduleId for which the logs are requested

        Keyword Args:
            type (str): Acts as a filter for the retrieval process. Filters the log instances that match the input type. [optional]
            message (str): Acts as a filter for the retrieval process. Filters the log instances that match the input message. [optional]
            log_set (str): Acts as a filter for the retrieval process. Filters the log instances that match the input logset. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ScheduleGenerationLogList
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        return self.get_schedule_generation_logs_endpoint.call_with_http_info(**kwargs)

    def get_schedule_generation_logs_with_http_info(
        self,
        tenant,
        schedule_id,
        **kwargs
    ) -> typing.Tuple[ScheduleGenerationLogList, int, typing.MutableMapping]:
        """Gets the generation logs for a specific schedule  # noqa: E501

        Gets the generation logs for a specific schedule based on the Schedule ID. Allows the user to sort and filter logs.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The scheduleId for which the logs are requested

        Keyword Args:
            type (str): Acts as a filter for the retrieval process. Filters the log instances that match the input type. [optional]
            message (str): Acts as a filter for the retrieval process. Filters the log instances that match the input message. [optional]
            log_set (str): Acts as a filter for the retrieval process. Filters the log instances that match the input logset. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ScheduleGenerationLogList
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        return self.get_schedule_generation_logs_endpoint.call_with_http_info(**kwargs)

    def get_schedule_generation_logs_async(
        self,
        tenant,
        schedule_id,
        **kwargs
    ) -> "ApplyResult[ScheduleGenerationLogList]":
        """Gets the generation logs for a specific schedule  # noqa: E501

        Gets the generation logs for a specific schedule based on the Schedule ID. Allows the user to sort and filter logs.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The scheduleId for which the logs are requested

        Keyword Args:
            type (str): Acts as a filter for the retrieval process. Filters the log instances that match the input type. [optional]
            message (str): Acts as a filter for the retrieval process. Filters the log instances that match the input message. [optional]
            log_set (str): Acts as a filter for the retrieval process. Filters the log instances that match the input logset. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ScheduleGenerationLogList]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        return self.get_schedule_generation_logs_endpoint.call_with_http_info(**kwargs)

    def get_schedule_generation_logs_with_http_info_async(
        self,
        tenant,
        schedule_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ScheduleGenerationLogList, int, typing.MutableMapping]]":
        """Gets the generation logs for a specific schedule  # noqa: E501

        Gets the generation logs for a specific schedule based on the Schedule ID. Allows the user to sort and filter logs.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The scheduleId for which the logs are requested

        Keyword Args:
            type (str): Acts as a filter for the retrieval process. Filters the log instances that match the input type. [optional]
            message (str): Acts as a filter for the retrieval process. Filters the log instances that match the input message. [optional]
            log_set (str): Acts as a filter for the retrieval process. Filters the log instances that match the input logset. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the log instances based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ScheduleGenerationLogList, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        return self.get_schedule_generation_logs_endpoint.call_with_http_info(**kwargs)


    def get_schedules(
        self,
        tenant,
        **kwargs
    ) -> SchedulesList:
        """Retrieves a list of all schedules  # noqa: E501

        Retrieves all schedules the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            status (str): Acts as a filter for the retrieval process. Filters the schedules that match the given status. Accepts multiple values separated by a comma, e.g. ?status=INITIALISED,RUNNING. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            SchedulesList
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_schedules_endpoint.call_with_http_info(**kwargs)

    def get_schedules_with_http_info(
        self,
        tenant,
        **kwargs
    ) -> typing.Tuple[SchedulesList, int, typing.MutableMapping]:
        """Retrieves a list of all schedules  # noqa: E501

        Retrieves all schedules the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            status (str): Acts as a filter for the retrieval process. Filters the schedules that match the given status. Accepts multiple values separated by a comma, e.g. ?status=INITIALISED,RUNNING. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            SchedulesList
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_schedules_endpoint.call_with_http_info(**kwargs)

    def get_schedules_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[SchedulesList]":
        """Retrieves a list of all schedules  # noqa: E501

        Retrieves all schedules the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            status (str): Acts as a filter for the retrieval process. Filters the schedules that match the given status. Accepts multiple values separated by a comma, e.g. ?status=INITIALISED,RUNNING. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[SchedulesList]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_schedules_endpoint.call_with_http_info(**kwargs)

    def get_schedules_with_http_info_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[SchedulesList, int, typing.MutableMapping]]":
        """Retrieves a list of all schedules  # noqa: E501

        Retrieves all schedules the user has permissions for. User has sort and filter parameters available to use.  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            status (str): Acts as a filter for the retrieval process. Filters the schedules that match the given status. Accepts multiple values separated by a comma, e.g. ?status=INITIALISED,RUNNING. [optional]
            start_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            end_date (str): Acts as a filter for the retrieval process. Filters the schedules based on their last updated date, the input date must be of the date format (d MMMMM yyyy 00:00:00).. [optional]
            sort ([str]): The column to sort on. Can add '-' to the start of the parameter value to sort in descending order.. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional] if omitted the server will use the default value of 25
            pagination_offset (int): Non-negative number of entries to skip. [optional] if omitted the server will use the default value of 0
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(SchedulesList, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_schedules_endpoint.call_with_http_info(**kwargs)


    def update_schedule_status(
        self,
        tenant,
        schedule_id,
        status,
        **kwargs
    ) -> ScheduleStatusUpdateResponse:
        """Update schedule status for specified schedule  # noqa: E501

        Updated the schedule status for the specified schedule id based on the given status  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The schedule id for which to update the status
            status (str): The schedule status that needs to be updated only if the transition is valid

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ScheduleStatusUpdateResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        kwargs['status'] = \
            status
        return self.update_schedule_status_endpoint.call_with_http_info(**kwargs)

    def update_schedule_status_with_http_info(
        self,
        tenant,
        schedule_id,
        status,
        **kwargs
    ) -> typing.Tuple[ScheduleStatusUpdateResponse, int, typing.MutableMapping]:
        """Update schedule status for specified schedule  # noqa: E501

        Updated the schedule status for the specified schedule id based on the given status  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The schedule id for which to update the status
            status (str): The schedule status that needs to be updated only if the transition is valid

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ScheduleStatusUpdateResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        kwargs['status'] = \
            status
        return self.update_schedule_status_endpoint.call_with_http_info(**kwargs)

    def update_schedule_status_async(
        self,
        tenant,
        schedule_id,
        status,
        **kwargs
    ) -> "ApplyResult[ScheduleStatusUpdateResponse]":
        """Update schedule status for specified schedule  # noqa: E501

        Updated the schedule status for the specified schedule id based on the given status  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The schedule id for which to update the status
            status (str): The schedule status that needs to be updated only if the transition is valid

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ScheduleStatusUpdateResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        kwargs['status'] = \
            status
        return self.update_schedule_status_endpoint.call_with_http_info(**kwargs)

    def update_schedule_status_with_http_info_async(
        self,
        tenant,
        schedule_id,
        status,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ScheduleStatusUpdateResponse, int, typing.MutableMapping]]":
        """Update schedule status for specified schedule  # noqa: E501

        Updated the schedule status for the specified schedule id based on the given status  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            schedule_id (str): The schedule id for which to update the status
            status (str): The schedule status that needs to be updated only if the transition is valid

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ScheduleStatusUpdateResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['schedule_id'] = \
            schedule_id
        kwargs['status'] = \
            status
        return self.update_schedule_status_endpoint.call_with_http_info(**kwargs)


