# generated by datamodel-codegen:
#   filename:  openapi (2).json
#   timestamp: 2025-07-09T20:11:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class CDPDescribeResponse(BaseModel):
    success: bool = Field(..., title="Success")
    cdp_page_url: str = Field(..., title="Url")
    cdp_browser_url: str = Field(..., title="Browser Url")
    cdp_devtools_url: str = Field(..., title="Devtools Url")


class ChromeStartRequest(BaseModel):
    resolution: Optional[str] = Field("1920x1080", title="Resolution")


class ChromeStartResponse(BaseModel):
    success: bool = Field(..., title="Success")
    message: str = Field(..., title="Message")


class ChromeStatusResponse(BaseModel):
    running: bool = Field(..., title="Running")
    message: str = Field(..., title="Message")


class CreateSnapshotsResponse(BaseModel):
    success: bool = Field(..., title="Success")
    initial_snapshot_path: Optional[str] = Field(None, title="Initial Snapshot Path")
    final_snapshot_path: Optional[str] = Field(None, title="Final Snapshot Path")
    message: str = Field(..., title="Message")


class HealthResponse(BaseModel):
    status: str = Field(..., title="Status")
    timestamp: str = Field(..., title="Timestamp")
    service: str = Field(..., title="Service")


class LogActionRequest(BaseModel):
    action_type: str = Field(..., title="Action Type")
    sql: Optional[str] = Field(None, title="Sql")
    args: Optional[str] = Field(None, title="Args")
    path: Optional[str] = Field(None, title="Path")
    raw_payload: Optional[str] = Field(None, title="Raw Payload")


class LogActionResponse(BaseModel):
    success: bool = Field(..., title="Success")
    message: str = Field(..., title="Message")


class QueryRequest(BaseModel):
    query: str = Field(..., title="Query")
    args: Optional[List] = Field(None, title="Args")
    read_only: Optional[bool] = Field(True, title="Read Only")


class QueryResponse(BaseModel):
    success: bool = Field(..., title="Success")
    columns: Optional[List[str]] = Field(None, title="Columns")
    rows: Optional[List[List]] = Field(None, title="Rows")
    rows_affected: Optional[int] = Field(None, title="Rows Affected")
    last_insert_id: Optional[int] = Field(None, title="Last Insert Id")
    error: Optional[str] = Field(None, title="Error")
    message: str = Field(..., title="Message")


class ResetRequest(BaseModel):
    timestamp: Optional[int] = Field(None, title="Timestamp")
    seed: Optional[int] = Field(None, title="Seed")


class ResetResponse(BaseModel):
    success: bool = Field(..., title="Success")
    message: str = Field(..., title="Message")


class ResourceMode(Enum):
    ro = "ro"
    rw = "rw"


class ResourceType(Enum):
    db = "sqlite"
    cdp = "cdp"


class TableSchema(BaseModel):
    name: str = Field(..., title="Name")
    sql: str = Field(..., title="Sql")
    columns: List[Dict[str, Any]] = Field(..., title="Columns")


class TimestampResponse(BaseModel):
    timestamp: str = Field(..., title="Timestamp")


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class DescribeResponse(BaseModel):
    success: bool = Field(..., title="Success")
    resource_name: str = Field(..., title="Resource Name")
    tables: Optional[List[TableSchema]] = Field(None, title="Tables")
    error: Optional[str] = Field(None, title="Error")
    message: str = Field(..., title="Message")


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class Resource(BaseModel):
    name: str = Field(..., title="Name")
    type: ResourceType
    mode: ResourceMode
    label: Optional[str] = Field(None, title="Label")
