from collections.abc import Callable, Iterable, Iterator
from typing import overload

__all__ = ['CA', 'ca']

class CA[I]:
    def __init__(self, *items: Iterable[I]) -> None: ...
    def __iter__(self) -> Iterator[I]: ...
    def __reversed__(self) -> Iterator[I]: ...
    def __bool__(self) -> bool: ...
    def __len__(self) -> int: ...
    @overload
    def __getitem__(self, idx: int) -> I: ...
    @overload
    def __getitem__(self, idx: slice) -> CA[I]: ...
    @overload
    def __setitem__(self, idx: int, vals: I) -> None: ...
    @overload
    def __setitem__(self, idx: slice, vals: Iterable[I]) -> None: ...
    @overload
    def __delitem__(self, idx: int) -> None: ...
    @overload
    def __delitem__(self, idx: slice) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def pushl(self, *items: I) -> None: ...
    def pushr(self, *items: I) -> None: ...
    def popl(self) -> I: ...
    def popr(self) -> I: ...
    def popld(self, default: I) -> I: ...
    def poprd(self, default: I) -> I: ...
    def poplt(self, maximum: int) -> tuple[I, ...]: ...
    def poprt(self, maximum: int) -> tuple[I, ...]: ...
    def rotl(self, n: int = 1) -> None: ...
    def rotr(self, n: int = 1) -> None: ...
    def map[U](self, f: Callable[[I], U]) -> CA[U]: ...
    @overload
    def foldl[L](self, f: Callable[[I, I], I]) -> I: ...
    @overload
    def foldl[L](self, f: Callable[[L, I], L], start: L) -> L: ...
    @overload
    def foldr[R](self, f: Callable[[I, I], I]) -> I: ...
    @overload
    def foldr[R](self, f: Callable[[I, R], R], start: R) -> R: ...
    def capacity(self) -> int: ...
    def empty(self) -> None: ...
    def fraction_filled(self) -> float: ...
    def resize(self, minimum_capacity: int = 2) -> None: ...

def ca[T](*items: T) -> CA[T]: ...
