# Licensed to the Software Freedom Conservancy (SFC) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The SFC licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

"""The Keys implementation."""


class Keys(object):
    """Set of special keys codes."""

    # Number Pad Keys
    NUMPAD0 = 7
    NUMPAD1 = 8
    NUMPAD2 = 9
    NUMPAD3 = 10
    NUMPAD4 = 11
    NUMPAD5 = 12
    NUMPAD6 = 13
    NUMPAD7 = 14
    NUMPAD8 = 15
    NUMPAD9 = 16

    # Letter Pad Keys (Lower Case)
    A = 29
    B = 30
    C = 31
    D = 32
    E = 33
    F = 34
    G = 35
    H = 36
    I = 37
    J = 38
    K = 39
    L = 40
    M = 41
    N = 42
    O = 43
    P = 44
    Q = 45
    R = 46
    S = 47
    T = 48
    U = 49
    V = 50
    W = 51
    X = 52
    Y = 53
    Z = 54

    # Dial Pad Keys
    CALL = 5
    ENDCALL = 6

    # Three Main Keys
    HOME = 3
    BACK = 4
    MENU = 82

    # Take Photos Keys
    CAMERA = 27
    FOCUS = 80

    # Control Keys
    POWER = 26
    LOCK = 223
    WAKE = 224

    BRIGHTNESS_DOWN = 220
    BRIGHTNESS_UP = 221

    MUTE = 91
    NOTIFICATION = 83
    VOLUME_MUTE = 164
    VOLUME_UP = 24
    VOLUME_DOWN = 25

    SWITCH = 187                # switching applications

    # Open an Application
    BROWSER = 64
    SETTING = 176
    CONTACTS = 207
    CALENDAR = 208
    MUSIC = 209
    CALCULATOR = 210
    VOICE_ASSISTANT = 231
    SEARCH = 84

    DPAD_UP = 19
    DPAD_DOWN = 20
    DPAD_LEFT = 21
    DPAD_RIGHT = 22
    DPAD_CENTER = 23

    MOVE_HOME = 122
    MOVE_END = 123

    PAGE_UP = 92
    PAGE_DOWN = 93

    CLEAR = 28
    DEL = 67
    FORWARD_DEL = 112
    INSERT = 124
    TAB = 61
    ENTER = 66

    NUM_LOCK = 143
    CAPS_LOCK = 115
    BREAK = 121
    SCROLL_LOCK = 116
    ZOOM_IN = 168
    ZOOM_OUT = 169

    # Symbol Keys
    PLUS = 81    # +
    MINUS = 69    # -
    STAR = 17    # *
    SLASH = 76    # /
    EQUALS = 70    # =
    AT = 77    # @
    POUND = 18    # #
    APOSTROPHE = 75    # '
    BACKSLASH = 73    # \
    COMMA = 55    # ,
    PERIOD = 56    # .
    LEFT_BRACKET = 71    # [
    RIGHT_BRACKET = 72  # ]
    SEMICOLON = 74    # ;
    GRAVE = 68    # `
    SPACE = 62

    NUM = 78

    MEDIA_PLAY_PAUSE = 85
    MEDIA_STOP = 86
    MEDIA_NEXT = 87
    MEDIA_PREVIOUS = 88
    MEDIA_REWIND = 89
    MEDIA_FAST_FORWARD = 90
