# -*- coding: utf-8 -*-
from graphene.pyutils.version import get_version

from .directives import get_all_directives
from .fields import DjangoObjectField, DjangoFilterListField, DjangoFilterPaginateListField, \
    DjangoListObjectField
from .middleware import ExtraGraphQLDirectiveMiddleware
from .mutation import DjangoSerializerMutation
from .paginations import LimitOffsetGraphqlPagination, PageGraphqlPagination, CursorGraphqlPagination
from .types import DjangoObjectType, DjangoInputObjectType, DjangoListObjectType, DjangoSerializerType

VERSION = (0, 3, 4, 'alpha', '2')

__version__ = get_version(VERSION)

__all__ = (
    '__version__',

    # FIELDS
    'DjangoObjectField',
    'DjangoFilterListField',
    'DjangoFilterPaginateListField',
    'DjangoListObjectField',

    # MUTATIONS
    'DjangoSerializerMutation',

    # PAGINATIONS
    'LimitOffsetGraphqlPagination',
    'PageGraphqlPagination',
    # 'CursorGraphqlPagination',  # Not implemented yet

    # TYPES
    'DjangoObjectType',
    'DjangoListObjectType',
    'DjangoInputObjectType',
    'DjangoSerializerType',

    # DIRECTIVES
    'get_all_directives',
    'ExtraGraphQLDirectiveMiddleware'
)
