# yaml_to_openstep_plist

A Python library to convert YAML data to OpenStep plist format.

## Installation

Install the library using pip:

```bash
pip install yaml_to_openstep_plist
```

## Usage

The library provides two main functions:

- `to_plist(yaml_data)`: Convert a Python object (parsed from YAML) to an OpenStep plist string.
- `to_yaml_file(yaml_file_path, plist_file_path)`: Convert a YAML file to an OpenStep plist file.

### Example

```python
import yaml_to_openstep_plist

# Convert YAML file to OpenStep plist file
yaml_to_openstep_plist.to_yaml_file("input.yaml", "output.plist")

# Convert YAML data to OpenStep plist string
yaml_data = {
    "surveyLocalizationEnableMapping": {
        "todayAtApple": False,
        "thankYou": False,
        "account": True,
        "theme": "dark",
        "age": 30,
        "score": 95.5,
        "data": None
    }
}
plist_string = yaml_to_openstep_plist.to_plist(yaml_data)
print(plist_string)
```

### Input YAML Example
```yaml
surveyLocalizationEnableMapping:
  todayAtApple: false
  thankYou: false
  account: true
  theme: dark
  age: 30
  score: 95.5
  data: null
```

### Output Plist Example
```
surveyLocalizationEnableMapping = {
  todayAtApple = false;
  thankYou = false;
  account = true;
  theme = "dark";
  age = 30;
  score = 95.5;
  data = {};
};
```

## Features
- Quotes strings on the right side of `=` (e.g., `theme = "dark";`).
- Leaves numbers unquoted (e.g., `age = 30;`).
- Uses `true`/`false` for booleans.
- Outputs `{}` for `null` values.
- Single space after `=` and 1-space indentation.
- Supports nested dictionaries and top-level key-value pair formatting.

## Requirements
- Python 3.6 or higher
- PyYAML (>=5.1)

## License
MIT