import datetime

from django import forms
from django.core.exceptions import ValidationError
from django.utils.translation import ugettext_lazy as _

# we need forms to accept user input from visitors


class RenewBookForm(forms.Form):
    """Form for a librarian to renew books."""
    renewal_date = forms.DateField(
        help_text="Enter a date between now and 4 weeks (default 3).")

    def clean_renewal_date(self):
        data = self.cleaned_data['renewal_date']

        # Date shouldnt be in the past
        if data < datetime.date.today():
            raise ValidationError(_('Invalid date - renewal in past'))

        # is date in the allowed range?
        if data > datetime.date.today() + datetime.timedelta(weeks=4):
            raise ValidationError(_('Invalid date - more than 4 weeks ahead'))

        return data
