# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402
# fmt: off
# isort: skip_file
# ruff: noqa: PLR0904
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from pkgs.serialization import OpaqueKey
from . import base as base_t
import uncountable.types.api.batch.execute_batch as execute_batch_t
import uncountable.types.api.entity.external_create_entities as external_create_entities_t
import uncountable.types.api.entity.external_create_entity as external_create_entity_t
import uncountable.types.api.inputs.external_create_inputs as external_create_inputs_t
import uncountable.types.api.recipes.external_create_recipes as external_create_recipes_t
import uncountable.types.api.recipes.external_get_curve as external_get_curve_t
import uncountable.types.api.entity.external_get_entities_data as external_get_entities_data_t
import uncountable.types.api.inputs.external_get_input_data as external_get_input_data_t
import uncountable.types.api.input_groups.external_get_input_group_names as external_get_input_group_names_t
import uncountable.types.api.inputs.external_get_input_names as external_get_input_names_t
import uncountable.types.api.inputs.external_get_inputs_data as external_get_inputs_data_t
import uncountable.types.api.outputs.external_get_output_data as external_get_output_data_t
import uncountable.types.api.outputs.external_get_output_names as external_get_output_names_t
import uncountable.types.api.project.external_get_projects as external_get_projects_t
import uncountable.types.api.project.external_get_projects_data as external_get_projects_data_t
import uncountable.types.api.recipes.external_get_recipe_calculations as external_get_recipe_calculations_t
import uncountable.types.api.recipes.external_get_recipe_links as external_get_recipe_links_t
import uncountable.types.api.recipe_metadata.external_get_recipe_metadata_data as external_get_recipe_metadata_data_t
import uncountable.types.api.recipes.external_get_recipe_names as external_get_recipe_names_t
import uncountable.types.api.recipes.external_get_recipe_output_metadata as external_get_recipe_output_metadata_t
import uncountable.types.api.recipes.external_get_recipes_data as external_get_recipes_data_t
import uncountable.types.api.entity.external_list_entities as external_list_entities_t
import uncountable.types.api.entity.external_resolve_entity_ids as external_resolve_entity_ids_t
import uncountable.types.api.outputs.external_resolve_output_conditions as external_resolve_output_conditions_t
import uncountable.types.api.inputs.external_set_input_attribute_values as external_set_input_attribute_values_t
import uncountable.types.api.recipes.external_set_recipe_inputs as external_set_recipe_inputs_t
import uncountable.types.api.recipes.external_set_recipe_outputs as external_set_recipe_outputs_t
import uncountable.types.api.entity.external_set_values as external_set_values_t
from abc import ABC, abstractmethod
from dataclasses import dataclass

DT = typing.TypeVar("DT")


@dataclass(kw_only=True)
class APIRequest:
    method: str
    endpoint: str
    args: typing.Any


class ClientMethods(ABC):

    @abstractmethod
    def do_request(self, *, api_request: APIRequest, return_type: type[DT]) -> DT:
        ...


    def execute_batch(
        self,
        *,
        requests: list[execute_batch_t.BatchRequest],
    ) -> execute_batch_t.Data:
        args = execute_batch_t.Arguments(
            requests=requests,
        )
        api_request = APIRequest(
            method=execute_batch_t.ENDPOINT_METHOD,
            endpoint=execute_batch_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=execute_batch_t.Data)


    def external_create_entities(
        self,
        *,
        definition_id: int,
        entity_type: typing.Union[typing.Literal["lab_request"], typing.Literal["approval"], typing.Literal["custom_entity"], typing.Literal["task"], typing.Literal["project"]],
        entities_to_create: list[external_create_entities_t.EntityToCreate],
    ) -> external_create_entities_t.Data:
        args = external_create_entities_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            entities_to_create=entities_to_create,
        )
        api_request = APIRequest(
            method=external_create_entities_t.ENDPOINT_METHOD,
            endpoint=external_create_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_create_entities_t.Data)


    def external_create_entity(
        self,
        *,
        definition_id: int,
        entity_type: typing.Union[typing.Literal["lab_request"], typing.Literal["approval"], typing.Literal["custom_entity"], typing.Literal["task"], typing.Literal["project"]],
        field_values: typing.Optional[typing.Optional[list[external_create_entity_t.ExternalEntityFieldInitialValue]]] = None,
    ) -> external_create_entity_t.Data:
        args = external_create_entity_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            field_values=field_values,
        )
        api_request = APIRequest(
            method=external_create_entity_t.ENDPOINT_METHOD,
            endpoint=external_create_entity_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_create_entity_t.Data)


    def external_create_inputs(
        self,
        *,
        inputs_to_create: list[external_create_inputs_t.InputToCreate],
    ) -> external_create_inputs_t.Data:
        args = external_create_inputs_t.Arguments(
            inputs_to_create=inputs_to_create,
        )
        api_request = APIRequest(
            method=external_create_inputs_t.ENDPOINT_METHOD,
            endpoint=external_create_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_create_inputs_t.Data)


    def external_create_recipes(
        self,
        *,
        material_family_id: int,
        recipe_definitions: list[external_create_recipes_t.ExternalCreateRecipeDefinition],
        project_id: typing.Optional[int] = None,
    ) -> external_create_recipes_t.Data:
        args = external_create_recipes_t.Arguments(
            material_family_id=material_family_id,
            project_id=project_id,
            recipe_definitions=recipe_definitions,
        )
        api_request = APIRequest(
            method=external_create_recipes_t.ENDPOINT_METHOD,
            endpoint=external_create_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_create_recipes_t.Data)


    def external_get_curve(
        self,
        *,
        recipe_output_id: int,
    ) -> external_get_curve_t.Data:
        args = external_get_curve_t.Arguments(
            recipe_output_id=recipe_output_id,
        )
        api_request = APIRequest(
            method=external_get_curve_t.ENDPOINT_METHOD,
            endpoint=external_get_curve_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_curve_t.Data)


    def external_get_entities_data(
        self,
        *,
        entity_ids: list[int],
        entity_type: str,
    ) -> external_get_entities_data_t.Data:
        args = external_get_entities_data_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=external_get_entities_data_t.ENDPOINT_METHOD,
            endpoint=external_get_entities_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_entities_data_t.Data)


    def external_get_input_data(
        self,
        *,
        material_family_id: int,
        input_ids: typing.Optional[list[int]],
        offset: typing.Optional[int],
        is_parameter: typing.Optional[bool],
        limit: typing.Optional[int],
    ) -> external_get_input_data_t.Data:
        args = external_get_input_data_t.Arguments(
            material_family_id=material_family_id,
            input_ids=input_ids,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_get_input_data_t.ENDPOINT_METHOD,
            endpoint=external_get_input_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_input_data_t.Data)


    def external_get_input_group_names(
        self,
        *,
        material_family_id: int,
    ) -> external_get_input_group_names_t.Data:
        args = external_get_input_group_names_t.Arguments(
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=external_get_input_group_names_t.ENDPOINT_METHOD,
            endpoint=external_get_input_group_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_input_group_names_t.Data)


    def external_get_input_names(
        self,
        *,
        material_family_id: int,
        offset: typing.Optional[int],
        is_parameter: typing.Optional[bool],
        limit: typing.Optional[int],
    ) -> external_get_input_names_t.Data:
        args = external_get_input_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_get_input_names_t.ENDPOINT_METHOD,
            endpoint=external_get_input_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_input_names_t.Data)


    def external_get_inputs_data(
        self,
        *,
        input_ids: list[int],
    ) -> external_get_inputs_data_t.Data:
        args = external_get_inputs_data_t.Arguments(
            input_ids=input_ids,
        )
        api_request = APIRequest(
            method=external_get_inputs_data_t.ENDPOINT_METHOD,
            endpoint=external_get_inputs_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_inputs_data_t.Data)


    def external_get_output_data(
        self,
        *,
        material_family_id: int,
        output_ids: typing.Optional[list[int]] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> external_get_output_data_t.Data:
        args = external_get_output_data_t.Arguments(
            material_family_id=material_family_id,
            output_ids=output_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_get_output_data_t.ENDPOINT_METHOD,
            endpoint=external_get_output_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_output_data_t.Data)


    def external_get_output_names(
        self,
        *,
        material_family_id: int,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> external_get_output_names_t.Data:
        args = external_get_output_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_get_output_names_t.ENDPOINT_METHOD,
            endpoint=external_get_output_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_output_names_t.Data)


    def external_get_projects(
        self,
        *,
        all_material_families: bool,
        material_family_id: typing.Optional[int],
    ) -> external_get_projects_t.Data:
        args = external_get_projects_t.Arguments(
            all_material_families=all_material_families,
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=external_get_projects_t.ENDPOINT_METHOD,
            endpoint=external_get_projects_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_projects_t.Data)


    def external_get_projects_data(
        self,
        *,
        project_ids: list[int],
        offset: typing.Optional[int],
        limit: typing.Optional[int],
    ) -> external_get_projects_data_t.Data:
        args = external_get_projects_data_t.Arguments(
            project_ids=project_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_get_projects_data_t.ENDPOINT_METHOD,
            endpoint=external_get_projects_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_projects_data_t.Data)


    def external_get_recipe_calculations(
        self,
        *,
        recipe_ids: list[int],
        calculation_ids: typing.Optional[list[int]] = None,
    ) -> external_get_recipe_calculations_t.Data:
        args = external_get_recipe_calculations_t.Arguments(
            recipe_ids=recipe_ids,
            calculation_ids=calculation_ids,
        )
        api_request = APIRequest(
            method=external_get_recipe_calculations_t.ENDPOINT_METHOD,
            endpoint=external_get_recipe_calculations_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_recipe_calculations_t.Data)


    def external_get_recipe_links(
        self,
        *,
        recipe_ids: list[int],
        depth: int = 1,
        link_types: typing.Optional[list[external_get_recipe_links_t.ExternalRecipeLinkType]],
    ) -> external_get_recipe_links_t.Data:
        args = external_get_recipe_links_t.Arguments(
            recipe_ids=recipe_ids,
            depth=depth,
            link_types=link_types,
        )
        api_request = APIRequest(
            method=external_get_recipe_links_t.ENDPOINT_METHOD,
            endpoint=external_get_recipe_links_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_recipe_links_t.Data)


    def external_get_recipe_metadata_data(
        self,
        *,
        material_family_id: int,
        recipe_metadata_ids: typing.Optional[list[int]],
        offset: typing.Optional[int],
        limit: typing.Optional[int],
    ) -> external_get_recipe_metadata_data_t.Data:
        args = external_get_recipe_metadata_data_t.Arguments(
            material_family_id=material_family_id,
            recipe_metadata_ids=recipe_metadata_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_get_recipe_metadata_data_t.ENDPOINT_METHOD,
            endpoint=external_get_recipe_metadata_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_recipe_metadata_data_t.Data)


    def external_get_recipe_names(
        self,
        *,
        project_id: int,
    ) -> external_get_recipe_names_t.Data:
        args = external_get_recipe_names_t.Arguments(
            project_id=project_id,
        )
        api_request = APIRequest(
            method=external_get_recipe_names_t.ENDPOINT_METHOD,
            endpoint=external_get_recipe_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_recipe_names_t.Data)


    def external_get_recipe_output_metadata(
        self,
        *,
        recipe_output_ids: list[int],
    ) -> external_get_recipe_output_metadata_t.Data:
        args = external_get_recipe_output_metadata_t.Arguments(
            recipe_output_ids=recipe_output_ids,
        )
        api_request = APIRequest(
            method=external_get_recipe_output_metadata_t.ENDPOINT_METHOD,
            endpoint=external_get_recipe_output_metadata_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_recipe_output_metadata_t.Data)


    def external_get_recipes_data(
        self,
        *,
        recipe_ids: typing.Optional[list[int]],
        project_id: typing.Optional[int],
        offset: typing.Optional[int],
        limit: typing.Optional[int],
    ) -> external_get_recipes_data_t.Data:
        args = external_get_recipes_data_t.Arguments(
            recipe_ids=recipe_ids,
            project_id=project_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_get_recipes_data_t.ENDPOINT_METHOD,
            endpoint=external_get_recipes_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_get_recipes_data_t.Data)


    def external_list_entities(
        self,
        *,
        entity_type: str,
        config_reference: str,
        offset: typing.Optional[int],
        limit: typing.Optional[int],
        attributes: typing.Optional[dict[OpaqueKey, base_t.JsonValue]] = None,
    ) -> external_list_entities_t.Data:
        args = external_list_entities_t.Arguments(
            entity_type=entity_type,
            config_reference=config_reference,
            attributes=attributes,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=external_list_entities_t.ENDPOINT_METHOD,
            endpoint=external_list_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_list_entities_t.Data)


    def external_resolve_entity_ids(
        self,
        *,
        entity_ids: list[typing.Union[str, int]],
        entity_type: str,
    ) -> external_resolve_entity_ids_t.Data:
        args = external_resolve_entity_ids_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=external_resolve_entity_ids_t.ENDPOINT_METHOD,
            endpoint=external_resolve_entity_ids_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_resolve_entity_ids_t.Data)


    def external_resolve_output_conditions(
        self,
        *,
        requested_conditions: list[external_resolve_output_conditions_t.ConditionRequest],
    ) -> external_resolve_output_conditions_t.Data:
        args = external_resolve_output_conditions_t.Arguments(
            requested_conditions=requested_conditions,
        )
        api_request = APIRequest(
            method=external_resolve_output_conditions_t.ENDPOINT_METHOD,
            endpoint=external_resolve_output_conditions_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_resolve_output_conditions_t.Data)


    def external_set_input_attribute_values(
        self,
        *,
        attribute_values: list[external_set_input_attribute_values_t.ExternalInputAttributeValue],
    ) -> external_set_input_attribute_values_t.Data:
        args = external_set_input_attribute_values_t.Arguments(
            attribute_values=attribute_values,
        )
        api_request = APIRequest(
            method=external_set_input_attribute_values_t.ENDPOINT_METHOD,
            endpoint=external_set_input_attribute_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_set_input_attribute_values_t.Data)


    def external_set_recipe_inputs(
        self,
        *,
        input_data: list[external_set_recipe_inputs_t.RecipeInputValue],
    ) -> external_set_recipe_inputs_t.Data:
        args = external_set_recipe_inputs_t.Arguments(
            input_data=input_data,
        )
        api_request = APIRequest(
            method=external_set_recipe_inputs_t.ENDPOINT_METHOD,
            endpoint=external_set_recipe_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_set_recipe_inputs_t.Data)


    def external_set_recipe_outputs(
        self,
        *,
        output_data: list[external_set_recipe_outputs_t.RecipeOutputValue],
    ) -> external_set_recipe_outputs_t.Data:
        args = external_set_recipe_outputs_t.Arguments(
            output_data=output_data,
        )
        api_request = APIRequest(
            method=external_set_recipe_outputs_t.ENDPOINT_METHOD,
            endpoint=external_set_recipe_outputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_set_recipe_outputs_t.Data)


    def external_set_values(
        self,
        *,
        entity: external_set_values_t.ExternalEntity,
        values: list[external_set_values_t.ExternalEntityFieldValues],
    ) -> external_set_values_t.Data:
        args = external_set_values_t.Arguments(
            entity=entity,
            values=values,
        )
        api_request = APIRequest(
            method=external_set_values_t.ENDPOINT_METHOD,
            endpoint=external_set_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=external_set_values_t.Data)
