/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import com.typesafe.config.Config;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.generated.Common;
import io.ray.runtime.util.SystemUtil;
import java.io.FileWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

public class LoggingUtil {
    private static boolean setup = false;

    public static synchronized void setupLogging(RayConfig rayConfig) {
        if (setup) {
            return;
        }
        setup = true;
        LoggerContext.getContext().reconfigure();
        Config config = rayConfig.getInternalConfig();
        if (rayConfig.workerMode == Common.WorkerType.DRIVER) {
            ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            builder.setStatusLevel(Level.INFO);
            builder.setConfigurationName("DefaultLogger");
            AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Console", "CONSOLE").addAttribute("target", ConsoleAppender.Target.SYSTEM_OUT);
            appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", config.getString("ray.logging.pattern")));
            RootLoggerComponentBuilder rootLogger = builder.newRootLogger(Level.INFO);
            rootLogger.add(builder.newAppenderRef("Console"));
            builder.add(appenderBuilder);
            builder.add(rootLogger);
            Configurator.reconfigure((Configuration)builder.build());
        } else {
            String maxBackupFiles;
            String jobIdHex = System.getenv("RAY_JOB_ID");
            String maxFileSize = System.getenv("RAY_ROTATION_MAX_BYTES");
            if (StringUtils.isEmpty(maxFileSize)) {
                maxFileSize = rayConfig.getInternalConfig().getString("ray.logging.max-file-size");
            }
            if (StringUtils.isEmpty(maxBackupFiles = System.getenv("RAY_ROTATION_BACKUP_COUNT"))) {
                maxBackupFiles = rayConfig.getInternalConfig().getString("ray.logging.max-backup-files");
            }
            ConfigurationBuilder<BuiltConfiguration> globalConfigBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
            Level level = Level.toLevel(config.getString("ray.logging.level"));
            globalConfigBuilder.setStatusLevel(Level.INFO);
            globalConfigBuilder.setConfigurationName("DefaultLogger");
            RootLoggerComponentBuilder rootLoggerBuilder = globalConfigBuilder.newAsyncRootLogger(level);
            rootLoggerBuilder.addAttribute("RingBufferSize", "1048576");
            String javaWorkerLogName = "JavaWorkerLogToRollingFile";
            String logFileName = rayConfig.getInternalConfig().getString("ray.logging.file-prefix") + "-" + jobIdHex + "-" + SystemUtil.pid();
            LoggingUtil.setupLogger(globalConfigBuilder, rayConfig.logDir, new RayConfig.LoggerConf("JavaWorkerLogToRollingFile", logFileName, config.getString("ray.logging.pattern")), maxFileSize, maxBackupFiles, null);
            rootLoggerBuilder.add(globalConfigBuilder.newAppenderRef("JavaWorkerLogToRollingFile"));
            globalConfigBuilder.add(rootLoggerBuilder);
            LoggingUtil.writeJobId(rayConfig.logDir + "/" + logFileName + ".log", jobIdHex);
            for (RayConfig.LoggerConf conf : rayConfig.loggers) {
                String logPattern = StringUtils.isEmpty(conf.pattern) ? config.getString("ray.logging.pattern") : conf.pattern;
                LoggingUtil.setupUserLogger(globalConfigBuilder, rayConfig.logDir, new RayConfig.LoggerConf(conf.loggerName, conf.fileName, logPattern), maxFileSize, maxBackupFiles, jobIdHex);
            }
            Configurator.reconfigure((Configuration)globalConfigBuilder.build());
        }
    }

    private static void writeJobId(String logFilePath, String jobIdHex) {
        try (FileWriter writer = new FileWriter(logFilePath);){
            writer.write(":job_id:" + jobIdHex + "\n");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write job id, " + jobIdHex + ", to log file, " + logFilePath, e);
        }
    }

    private static void setupUserLogger(ConfigurationBuilder<BuiltConfiguration> globalConfigBuilder, String logDir, RayConfig.LoggerConf userLoggerConf, String maxFileSize, String maxBackupFiles, String jobIdHex) {
        LoggerComponentBuilder userLoggerBuilder = globalConfigBuilder.newAsyncLogger(userLoggerConf.loggerName);
        LoggingUtil.setupLogger(globalConfigBuilder, logDir, userLoggerConf, maxFileSize, maxBackupFiles, jobIdHex);
        ((LoggerComponentBuilder)userLoggerBuilder.add(globalConfigBuilder.newAppenderRef(userLoggerConf.loggerName))).addAttribute("additivity", false);
        globalConfigBuilder.add(userLoggerBuilder);
    }

    private static void setupLogger(ConfigurationBuilder<BuiltConfiguration> globalConfigBuilder, String logDir, RayConfig.LoggerConf userLoggerConf, String maxFileSize, String maxBackupFiles, String jobIdHex) {
        LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)globalConfigBuilder.newLayout("PatternLayout").addAttribute("pattern", userLoggerConf.pattern);
        Object userLoggerTriggeringPolicy = globalConfigBuilder.newComponent("Policies").addComponent((ComponentBuilder<?>)globalConfigBuilder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", maxFileSize));
        Object userLoggerRolloverStrategy = globalConfigBuilder.newComponent("DefaultRolloverStrategy").addAttribute("max", maxBackupFiles);
        String logFileName = userLoggerConf.fileName.replace("%p", String.valueOf(SystemUtil.pid()));
        if (jobIdHex != null) {
            logFileName = logFileName.replace("%j", jobIdHex);
        }
        String logPath = logDir + "/" + logFileName + ".log";
        String rotatedLogPath = logDir + "/" + logFileName + ".%i.log";
        AppenderComponentBuilder userLoggerAppenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)globalConfigBuilder.newAppender(userLoggerConf.loggerName, "RollingFile").addAttribute("filePattern", rotatedLogPath)).add(layoutBuilder).addComponent((ComponentBuilder<?>)userLoggerTriggeringPolicy)).addComponent((ComponentBuilder<?>)userLoggerRolloverStrategy)).addAttribute("fileName", logPath);
        globalConfigBuilder.add(userLoggerAppenderBuilder);
    }
}

