"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * A principal to allow access to a key if it's being used through another AWS service.
 *
 * @stability stable
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    /**
     * @stability stable
     */
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     *
     * @stability stable
     */
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
_a = JSII_RTTI_SYMBOL_1;
ViaServicePrincipal[_a] = { fqn: "@aws-cdk/aws-kms.ViaServicePrincipal", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,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