import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseWorkspaceExtendedAuditingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#log_monitoring_enabled SynapseWorkspaceExtendedAuditingPolicy#log_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly logMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#retention_in_days SynapseWorkspaceExtendedAuditingPolicy#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#storage_account_access_key SynapseWorkspaceExtendedAuditingPolicy#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#storage_account_access_key_is_secondary SynapseWorkspaceExtendedAuditingPolicy#storage_account_access_key_is_secondary}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKeyIsSecondary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#storage_endpoint SynapseWorkspaceExtendedAuditingPolicy#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#synapse_workspace_id SynapseWorkspaceExtendedAuditingPolicy#synapse_workspace_id}.
     *
     * @stability stable
     */
    readonly synapseWorkspaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#timeouts SynapseWorkspaceExtendedAuditingPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseWorkspaceExtendedAuditingPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceExtendedAuditingPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#create SynapseWorkspaceExtendedAuditingPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#delete SynapseWorkspaceExtendedAuditingPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#read SynapseWorkspaceExtendedAuditingPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html#update SynapseWorkspaceExtendedAuditingPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseWorkspaceExtendedAuditingPolicyTimeoutsToTerraform(struct?: SynapseWorkspaceExtendedAuditingPolicyTimeoutsOutputReference | SynapseWorkspaceExtendedAuditingPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceExtendedAuditingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceExtendedAuditingPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceExtendedAuditingPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html azurerm_synapse_workspace_extended_auditing_policy}.
 *
 * @stability stable
 */
export declare class SynapseWorkspaceExtendedAuditingPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_extended_auditing_policy.html azurerm_synapse_workspace_extended_auditing_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceExtendedAuditingPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _logMonitoringEnabled?;
    /**
     * @stability stable
     */
    get logMonitoringEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set logMonitoringEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLogMonitoringEnabled(): void;
    /**
     * @stability stable
     */
    get logMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionInDays(): void;
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountAccessKeyIsSecondary?;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyIsSecondary(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set storageAccountAccessKeyIsSecondary(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKeyIsSecondary(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyIsSecondaryInput(): boolean | cdktf.IResolvable | undefined;
    private _storageEndpoint?;
    /**
     * @stability stable
     */
    get storageEndpoint(): string;
    /**
     * @stability stable
     */
    set storageEndpoint(value: string);
    /**
     * @stability stable
     */
    resetStorageEndpoint(): void;
    /**
     * @stability stable
     */
    get storageEndpointInput(): string | undefined;
    private _synapseWorkspaceId?;
    /**
     * @stability stable
     */
    get synapseWorkspaceId(): string;
    /**
     * @stability stable
     */
    set synapseWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get synapseWorkspaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseWorkspaceExtendedAuditingPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseWorkspaceExtendedAuditingPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseWorkspaceExtendedAuditingPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
