import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnServerConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#location VpnServerConfiguration#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#resource_group_name VpnServerConfiguration#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#tags VpnServerConfiguration#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#vpn_authentication_types VpnServerConfiguration#vpn_authentication_types}.
     *
     * @stability stable
     */
    readonly vpnAuthenticationTypes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#vpn_protocols VpnServerConfiguration#vpn_protocols}.
     *
     * @stability stable
     */
    readonly vpnProtocols?: string[];
    /**
     * azure_active_directory_authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#azure_active_directory_authentication VpnServerConfiguration#azure_active_directory_authentication}
     *
     * @stability stable
     */
    readonly azureActiveDirectoryAuthentication?: VpnServerConfigurationAzureActiveDirectoryAuthentication[];
    /**
     * client_revoked_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#client_revoked_certificate VpnServerConfiguration#client_revoked_certificate}
     *
     * @stability stable
     */
    readonly clientRevokedCertificate?: VpnServerConfigurationClientRevokedCertificate[];
    /**
     * client_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#client_root_certificate VpnServerConfiguration#client_root_certificate}
     *
     * @stability stable
     */
    readonly clientRootCertificate?: VpnServerConfigurationClientRootCertificate[];
    /**
     * ipsec_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#ipsec_policy VpnServerConfiguration#ipsec_policy}
     *
     * @stability stable
     */
    readonly ipsecPolicy?: VpnServerConfigurationIpsecPolicy;
    /**
     * radius block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#radius VpnServerConfiguration#radius}
     *
     * @stability stable
     */
    readonly radius?: VpnServerConfigurationRadius;
    /**
     * radius_server block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#radius_server VpnServerConfiguration#radius_server}
     *
     * @stability stable
     */
    readonly radiusServer?: VpnServerConfigurationRadiusServerA;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#timeouts VpnServerConfiguration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnServerConfigurationTimeouts;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationAzureActiveDirectoryAuthentication {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#audience VpnServerConfiguration#audience}.
     *
     * @stability stable
     */
    readonly audience: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#issuer VpnServerConfiguration#issuer}.
     *
     * @stability stable
     */
    readonly issuer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#tenant VpnServerConfiguration#tenant}.
     *
     * @stability stable
     */
    readonly tenant: string;
}
export declare function vpnServerConfigurationAzureActiveDirectoryAuthenticationToTerraform(struct?: VpnServerConfigurationAzureActiveDirectoryAuthentication): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationClientRevokedCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#thumbprint VpnServerConfiguration#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationClientRevokedCertificateToTerraform(struct?: VpnServerConfigurationClientRevokedCertificate): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationClientRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#public_cert_data VpnServerConfiguration#public_cert_data}.
     *
     * @stability stable
     */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationClientRootCertificateToTerraform(struct?: VpnServerConfigurationClientRootCertificate): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationIpsecPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#dh_group VpnServerConfiguration#dh_group}.
     *
     * @stability stable
     */
    readonly dhGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#ike_encryption VpnServerConfiguration#ike_encryption}.
     *
     * @stability stable
     */
    readonly ikeEncryption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#ike_integrity VpnServerConfiguration#ike_integrity}.
     *
     * @stability stable
     */
    readonly ikeIntegrity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#ipsec_encryption VpnServerConfiguration#ipsec_encryption}.
     *
     * @stability stable
     */
    readonly ipsecEncryption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#ipsec_integrity VpnServerConfiguration#ipsec_integrity}.
     *
     * @stability stable
     */
    readonly ipsecIntegrity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#pfs_group VpnServerConfiguration#pfs_group}.
     *
     * @stability stable
     */
    readonly pfsGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#sa_data_size_kilobytes VpnServerConfiguration#sa_data_size_kilobytes}.
     *
     * @stability stable
     */
    readonly saDataSizeKilobytes: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#sa_lifetime_seconds VpnServerConfiguration#sa_lifetime_seconds}.
     *
     * @stability stable
     */
    readonly saLifetimeSeconds: number;
}
export declare function vpnServerConfigurationIpsecPolicyToTerraform(struct?: VpnServerConfigurationIpsecPolicyOutputReference | VpnServerConfigurationIpsecPolicy): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationIpsecPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationIpsecPolicy | undefined);
    private _dhGroup?;
    /**
     * @stability stable
     */
    get dhGroup(): string;
    /**
     * @stability stable
     */
    set dhGroup(value: string);
    /**
     * @stability stable
     */
    get dhGroupInput(): string | undefined;
    private _ikeEncryption?;
    /**
     * @stability stable
     */
    get ikeEncryption(): string;
    /**
     * @stability stable
     */
    set ikeEncryption(value: string);
    /**
     * @stability stable
     */
    get ikeEncryptionInput(): string | undefined;
    private _ikeIntegrity?;
    /**
     * @stability stable
     */
    get ikeIntegrity(): string;
    /**
     * @stability stable
     */
    set ikeIntegrity(value: string);
    /**
     * @stability stable
     */
    get ikeIntegrityInput(): string | undefined;
    private _ipsecEncryption?;
    /**
     * @stability stable
     */
    get ipsecEncryption(): string;
    /**
     * @stability stable
     */
    set ipsecEncryption(value: string);
    /**
     * @stability stable
     */
    get ipsecEncryptionInput(): string | undefined;
    private _ipsecIntegrity?;
    /**
     * @stability stable
     */
    get ipsecIntegrity(): string;
    /**
     * @stability stable
     */
    set ipsecIntegrity(value: string);
    /**
     * @stability stable
     */
    get ipsecIntegrityInput(): string | undefined;
    private _pfsGroup?;
    /**
     * @stability stable
     */
    get pfsGroup(): string;
    /**
     * @stability stable
     */
    set pfsGroup(value: string);
    /**
     * @stability stable
     */
    get pfsGroupInput(): string | undefined;
    private _saDataSizeKilobytes?;
    /**
     * @stability stable
     */
    get saDataSizeKilobytes(): number;
    /**
     * @stability stable
     */
    set saDataSizeKilobytes(value: number);
    /**
     * @stability stable
     */
    get saDataSizeKilobytesInput(): number | undefined;
    private _saLifetimeSeconds?;
    /**
     * @stability stable
     */
    get saLifetimeSeconds(): number;
    /**
     * @stability stable
     */
    set saLifetimeSeconds(value: number);
    /**
     * @stability stable
     */
    get saLifetimeSecondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusClientRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#thumbprint VpnServerConfiguration#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationRadiusClientRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusClientRootCertificate): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServer {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#address VpnServerConfiguration#address}.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#score VpnServerConfiguration#score}.
     *
     * @stability stable
     */
    readonly score: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#secret VpnServerConfiguration#secret}.
     *
     * @stability stable
     */
    readonly secret: string;
}
export declare function vpnServerConfigurationRadiusServerToTerraform(struct?: VpnServerConfigurationRadiusServer): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#public_cert_data VpnServerConfiguration#public_cert_data}.
     *
     * @stability stable
     */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationRadiusServerRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerRootCertificate): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadius {
    /**
     * client_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#client_root_certificate VpnServerConfiguration#client_root_certificate}
     *
     * @stability stable
     */
    readonly clientRootCertificate?: VpnServerConfigurationRadiusClientRootCertificate[];
    /**
     * server block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#server VpnServerConfiguration#server}
     *
     * @stability stable
     */
    readonly server?: VpnServerConfigurationRadiusServer[];
    /**
     * server_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#server_root_certificate VpnServerConfiguration#server_root_certificate}
     *
     * @stability stable
     */
    readonly serverRootCertificate: VpnServerConfigurationRadiusServerRootCertificate[];
}
export declare function vpnServerConfigurationRadiusToTerraform(struct?: VpnServerConfigurationRadiusOutputReference | VpnServerConfigurationRadius): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationRadiusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationRadius | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationRadius | undefined);
    private _clientRootCertificate?;
    /**
     * @stability stable
     */
    get clientRootCertificate(): VpnServerConfigurationRadiusClientRootCertificate[];
    /**
     * @stability stable
     */
    set clientRootCertificate(value: VpnServerConfigurationRadiusClientRootCertificate[]);
    /**
     * @stability stable
     */
    resetClientRootCertificate(): void;
    /**
     * @stability stable
     */
    get clientRootCertificateInput(): VpnServerConfigurationRadiusClientRootCertificate[] | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): VpnServerConfigurationRadiusServer[];
    /**
     * @stability stable
     */
    set server(value: VpnServerConfigurationRadiusServer[]);
    /**
     * @stability stable
     */
    resetServer(): void;
    /**
     * @stability stable
     */
    get serverInput(): VpnServerConfigurationRadiusServer[] | undefined;
    private _serverRootCertificate?;
    /**
     * @stability stable
     */
    get serverRootCertificate(): VpnServerConfigurationRadiusServerRootCertificate[];
    /**
     * @stability stable
     */
    set serverRootCertificate(value: VpnServerConfigurationRadiusServerRootCertificate[]);
    /**
     * @stability stable
     */
    get serverRootCertificateInput(): VpnServerConfigurationRadiusServerRootCertificate[] | undefined;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerClientRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#thumbprint VpnServerConfiguration#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationRadiusServerClientRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerClientRootCertificate): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerServerRootCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#name VpnServerConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#public_cert_data VpnServerConfiguration#public_cert_data}.
     *
     * @stability stable
     */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationRadiusServerServerRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerServerRootCertificate): any;
/**
 * @stability stable
 */
export interface VpnServerConfigurationRadiusServerA {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#address VpnServerConfiguration#address}.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#secret VpnServerConfiguration#secret}.
     *
     * @stability stable
     */
    readonly secret: string;
    /**
     * client_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#client_root_certificate VpnServerConfiguration#client_root_certificate}
     *
     * @stability stable
     */
    readonly clientRootCertificate?: VpnServerConfigurationRadiusServerClientRootCertificate[];
    /**
     * server_root_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#server_root_certificate VpnServerConfiguration#server_root_certificate}
     *
     * @stability stable
     */
    readonly serverRootCertificate: VpnServerConfigurationRadiusServerServerRootCertificate[];
}
export declare function vpnServerConfigurationRadiusServerAToTerraform(struct?: VpnServerConfigurationRadiusServerAOutputReference | VpnServerConfigurationRadiusServerA): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationRadiusServerAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationRadiusServerA | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationRadiusServerA | undefined);
    private _address?;
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    set address(value: string);
    /**
     * @stability stable
     */
    get addressInput(): string | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): string;
    /**
     * @stability stable
     */
    set secret(value: string);
    /**
     * @stability stable
     */
    get secretInput(): string | undefined;
    private _clientRootCertificate?;
    /**
     * @stability stable
     */
    get clientRootCertificate(): VpnServerConfigurationRadiusServerClientRootCertificate[];
    /**
     * @stability stable
     */
    set clientRootCertificate(value: VpnServerConfigurationRadiusServerClientRootCertificate[]);
    /**
     * @stability stable
     */
    resetClientRootCertificate(): void;
    /**
     * @stability stable
     */
    get clientRootCertificateInput(): VpnServerConfigurationRadiusServerClientRootCertificate[] | undefined;
    private _serverRootCertificate?;
    /**
     * @stability stable
     */
    get serverRootCertificate(): VpnServerConfigurationRadiusServerServerRootCertificate[];
    /**
     * @stability stable
     */
    set serverRootCertificate(value: VpnServerConfigurationRadiusServerServerRootCertificate[]);
    /**
     * @stability stable
     */
    get serverRootCertificateInput(): VpnServerConfigurationRadiusServerServerRootCertificate[] | undefined;
}
/**
 * @stability stable
 */
export interface VpnServerConfigurationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#create VpnServerConfiguration#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#delete VpnServerConfiguration#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#read VpnServerConfiguration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html#update VpnServerConfiguration#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vpnServerConfigurationTimeoutsToTerraform(struct?: VpnServerConfigurationTimeoutsOutputReference | VpnServerConfigurationTimeouts): any;
/**
 * @stability stable
 */
export declare class VpnServerConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnServerConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnServerConfigurationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html azurerm_vpn_server_configuration}.
 *
 * @stability stable
 */
export declare class VpnServerConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration.html azurerm_vpn_server_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnServerConfigurationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vpnAuthenticationTypes?;
    /**
     * @stability stable
     */
    get vpnAuthenticationTypes(): string[];
    /**
     * @stability stable
     */
    set vpnAuthenticationTypes(value: string[]);
    /**
     * @stability stable
     */
    get vpnAuthenticationTypesInput(): string[] | undefined;
    private _vpnProtocols?;
    /**
     * @stability stable
     */
    get vpnProtocols(): string[];
    /**
     * @stability stable
     */
    set vpnProtocols(value: string[]);
    /**
     * @stability stable
     */
    resetVpnProtocols(): void;
    /**
     * @stability stable
     */
    get vpnProtocolsInput(): string[] | undefined;
    private _azureActiveDirectoryAuthentication?;
    /**
     * @stability stable
     */
    get azureActiveDirectoryAuthentication(): VpnServerConfigurationAzureActiveDirectoryAuthentication[];
    /**
     * @stability stable
     */
    set azureActiveDirectoryAuthentication(value: VpnServerConfigurationAzureActiveDirectoryAuthentication[]);
    /**
     * @stability stable
     */
    resetAzureActiveDirectoryAuthentication(): void;
    /**
     * @stability stable
     */
    get azureActiveDirectoryAuthenticationInput(): VpnServerConfigurationAzureActiveDirectoryAuthentication[] | undefined;
    private _clientRevokedCertificate?;
    /**
     * @stability stable
     */
    get clientRevokedCertificate(): VpnServerConfigurationClientRevokedCertificate[];
    /**
     * @stability stable
     */
    set clientRevokedCertificate(value: VpnServerConfigurationClientRevokedCertificate[]);
    /**
     * @stability stable
     */
    resetClientRevokedCertificate(): void;
    /**
     * @stability stable
     */
    get clientRevokedCertificateInput(): VpnServerConfigurationClientRevokedCertificate[] | undefined;
    private _clientRootCertificate?;
    /**
     * @stability stable
     */
    get clientRootCertificate(): VpnServerConfigurationClientRootCertificate[];
    /**
     * @stability stable
     */
    set clientRootCertificate(value: VpnServerConfigurationClientRootCertificate[]);
    /**
     * @stability stable
     */
    resetClientRootCertificate(): void;
    /**
     * @stability stable
     */
    get clientRootCertificateInput(): VpnServerConfigurationClientRootCertificate[] | undefined;
    private _ipsecPolicy;
    /**
     * @stability stable
     */
    get ipsecPolicy(): VpnServerConfigurationIpsecPolicyOutputReference;
    /**
     * @stability stable
     */
    putIpsecPolicy(value: VpnServerConfigurationIpsecPolicy): void;
    /**
     * @stability stable
     */
    resetIpsecPolicy(): void;
    /**
     * @stability stable
     */
    get ipsecPolicyInput(): VpnServerConfigurationIpsecPolicy | undefined;
    private _radius;
    /**
     * @stability stable
     */
    get radius(): VpnServerConfigurationRadiusOutputReference;
    /**
     * @stability stable
     */
    putRadius(value: VpnServerConfigurationRadius): void;
    /**
     * @stability stable
     */
    resetRadius(): void;
    /**
     * @stability stable
     */
    get radiusInput(): VpnServerConfigurationRadius | undefined;
    private _radiusServer;
    /**
     * @stability stable
     */
    get radiusServer(): VpnServerConfigurationRadiusServerAOutputReference;
    /**
     * @stability stable
     */
    putRadiusServer(value: VpnServerConfigurationRadiusServerA): void;
    /**
     * @stability stable
     */
    resetRadiusServer(): void;
    /**
     * @stability stable
     */
    get radiusServerInput(): VpnServerConfigurationRadiusServerA | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VpnServerConfigurationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnServerConfigurationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnServerConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
