import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#access_key_metadata_writes_enabled CosmosdbAccount#access_key_metadata_writes_enabled}
    */
    readonly accessKeyMetadataWritesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#analytical_storage_enabled CosmosdbAccount#analytical_storage_enabled}
    */
    readonly analyticalStorageEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#create_mode CosmosdbAccount#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#default_identity_type CosmosdbAccount#default_identity_type}
    */
    readonly defaultIdentityType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#enable_automatic_failover CosmosdbAccount#enable_automatic_failover}
    */
    readonly enableAutomaticFailover?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#enable_free_tier CosmosdbAccount#enable_free_tier}
    */
    readonly enableFreeTier?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#enable_multiple_write_locations CosmosdbAccount#enable_multiple_write_locations}
    */
    readonly enableMultipleWriteLocations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#id CosmosdbAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#ip_range_filter CosmosdbAccount#ip_range_filter}
    */
    readonly ipRangeFilter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#is_virtual_network_filter_enabled CosmosdbAccount#is_virtual_network_filter_enabled}
    */
    readonly isVirtualNetworkFilterEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#key_vault_key_id CosmosdbAccount#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#kind CosmosdbAccount#kind}
    */
    readonly kind?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#local_authentication_disabled CosmosdbAccount#local_authentication_disabled}
    */
    readonly localAuthenticationDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#location CosmosdbAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#mongo_server_version CosmosdbAccount#mongo_server_version}
    */
    readonly mongoServerVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#name CosmosdbAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#network_acl_bypass_for_azure_services CosmosdbAccount#network_acl_bypass_for_azure_services}
    */
    readonly networkAclBypassForAzureServices?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#network_acl_bypass_ids CosmosdbAccount#network_acl_bypass_ids}
    */
    readonly networkAclBypassIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#offer_type CosmosdbAccount#offer_type}
    */
    readonly offerType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#public_network_access_enabled CosmosdbAccount#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#resource_group_name CosmosdbAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#tags CosmosdbAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * analytical_storage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#analytical_storage CosmosdbAccount#analytical_storage}
    */
    readonly analyticalStorage?: CosmosdbAccountAnalyticalStorage;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#backup CosmosdbAccount#backup}
    */
    readonly backup?: CosmosdbAccountBackup;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#capabilities CosmosdbAccount#capabilities}
    */
    readonly capabilities?: CosmosdbAccountCapabilities[] | cdktf.IResolvable;
    /**
    * capacity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#capacity CosmosdbAccount#capacity}
    */
    readonly capacity?: CosmosdbAccountCapacity;
    /**
    * consistency_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#consistency_policy CosmosdbAccount#consistency_policy}
    */
    readonly consistencyPolicy: CosmosdbAccountConsistencyPolicy;
    /**
    * cors_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#cors_rule CosmosdbAccount#cors_rule}
    */
    readonly corsRule?: CosmosdbAccountCorsRule;
    /**
    * geo_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#geo_location CosmosdbAccount#geo_location}
    */
    readonly geoLocation: CosmosdbAccountGeoLocation[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#identity CosmosdbAccount#identity}
    */
    readonly identity?: CosmosdbAccountIdentity;
    /**
    * restore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#restore CosmosdbAccount#restore}
    */
    readonly restore?: CosmosdbAccountRestore;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#timeouts CosmosdbAccount#timeouts}
    */
    readonly timeouts?: CosmosdbAccountTimeouts;
    /**
    * virtual_network_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#virtual_network_rule CosmosdbAccount#virtual_network_rule}
    */
    readonly virtualNetworkRule?: CosmosdbAccountVirtualNetworkRule[] | cdktf.IResolvable;
}
export interface CosmosdbAccountAnalyticalStorage {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#schema_type CosmosdbAccount#schema_type}
    */
    readonly schemaType: string;
}
export declare function cosmosdbAccountAnalyticalStorageToTerraform(struct?: CosmosdbAccountAnalyticalStorageOutputReference | CosmosdbAccountAnalyticalStorage): any;
export declare class CosmosdbAccountAnalyticalStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountAnalyticalStorage | undefined;
    set internalValue(value: CosmosdbAccountAnalyticalStorage | undefined);
    private _schemaType?;
    get schemaType(): string;
    set schemaType(value: string);
    get schemaTypeInput(): string | undefined;
}
export interface CosmosdbAccountBackup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#interval_in_minutes CosmosdbAccount#interval_in_minutes}
    */
    readonly intervalInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#retention_in_hours CosmosdbAccount#retention_in_hours}
    */
    readonly retentionInHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#storage_redundancy CosmosdbAccount#storage_redundancy}
    */
    readonly storageRedundancy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#type CosmosdbAccount#type}
    */
    readonly type: string;
}
export declare function cosmosdbAccountBackupToTerraform(struct?: CosmosdbAccountBackupOutputReference | CosmosdbAccountBackup): any;
export declare class CosmosdbAccountBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountBackup | undefined;
    set internalValue(value: CosmosdbAccountBackup | undefined);
    private _intervalInMinutes?;
    get intervalInMinutes(): number;
    set intervalInMinutes(value: number);
    resetIntervalInMinutes(): void;
    get intervalInMinutesInput(): number | undefined;
    private _retentionInHours?;
    get retentionInHours(): number;
    set retentionInHours(value: number);
    resetRetentionInHours(): void;
    get retentionInHoursInput(): number | undefined;
    private _storageRedundancy?;
    get storageRedundancy(): string;
    set storageRedundancy(value: string);
    resetStorageRedundancy(): void;
    get storageRedundancyInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface CosmosdbAccountCapabilities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#name CosmosdbAccount#name}
    */
    readonly name: string;
}
export declare function cosmosdbAccountCapabilitiesToTerraform(struct?: CosmosdbAccountCapabilities | cdktf.IResolvable): any;
export declare class CosmosdbAccountCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbAccountCapabilities | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbAccountCapabilities | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class CosmosdbAccountCapabilitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbAccountCapabilities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbAccountCapabilitiesOutputReference;
}
export interface CosmosdbAccountCapacity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#total_throughput_limit CosmosdbAccount#total_throughput_limit}
    */
    readonly totalThroughputLimit: number;
}
export declare function cosmosdbAccountCapacityToTerraform(struct?: CosmosdbAccountCapacityOutputReference | CosmosdbAccountCapacity): any;
export declare class CosmosdbAccountCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountCapacity | undefined;
    set internalValue(value: CosmosdbAccountCapacity | undefined);
    private _totalThroughputLimit?;
    get totalThroughputLimit(): number;
    set totalThroughputLimit(value: number);
    get totalThroughputLimitInput(): number | undefined;
}
export interface CosmosdbAccountConsistencyPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#consistency_level CosmosdbAccount#consistency_level}
    */
    readonly consistencyLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#max_interval_in_seconds CosmosdbAccount#max_interval_in_seconds}
    */
    readonly maxIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#max_staleness_prefix CosmosdbAccount#max_staleness_prefix}
    */
    readonly maxStalenessPrefix?: number;
}
export declare function cosmosdbAccountConsistencyPolicyToTerraform(struct?: CosmosdbAccountConsistencyPolicyOutputReference | CosmosdbAccountConsistencyPolicy): any;
export declare class CosmosdbAccountConsistencyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountConsistencyPolicy | undefined;
    set internalValue(value: CosmosdbAccountConsistencyPolicy | undefined);
    private _consistencyLevel?;
    get consistencyLevel(): string;
    set consistencyLevel(value: string);
    get consistencyLevelInput(): string | undefined;
    private _maxIntervalInSeconds?;
    get maxIntervalInSeconds(): number;
    set maxIntervalInSeconds(value: number);
    resetMaxIntervalInSeconds(): void;
    get maxIntervalInSecondsInput(): number | undefined;
    private _maxStalenessPrefix?;
    get maxStalenessPrefix(): number;
    set maxStalenessPrefix(value: number);
    resetMaxStalenessPrefix(): void;
    get maxStalenessPrefixInput(): number | undefined;
}
export interface CosmosdbAccountCorsRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#allowed_headers CosmosdbAccount#allowed_headers}
    */
    readonly allowedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#allowed_methods CosmosdbAccount#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#allowed_origins CosmosdbAccount#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#exposed_headers CosmosdbAccount#exposed_headers}
    */
    readonly exposedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#max_age_in_seconds CosmosdbAccount#max_age_in_seconds}
    */
    readonly maxAgeInSeconds: number;
}
export declare function cosmosdbAccountCorsRuleToTerraform(struct?: CosmosdbAccountCorsRuleOutputReference | CosmosdbAccountCorsRule): any;
export declare class CosmosdbAccountCorsRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountCorsRule | undefined;
    set internalValue(value: CosmosdbAccountCorsRule | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _exposedHeaders?;
    get exposedHeaders(): string[];
    set exposedHeaders(value: string[]);
    get exposedHeadersInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    get maxAgeInSeconds(): number;
    set maxAgeInSeconds(value: number);
    get maxAgeInSecondsInput(): number | undefined;
}
export interface CosmosdbAccountGeoLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#failover_priority CosmosdbAccount#failover_priority}
    */
    readonly failoverPriority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#location CosmosdbAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#zone_redundant CosmosdbAccount#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
}
export declare function cosmosdbAccountGeoLocationToTerraform(struct?: CosmosdbAccountGeoLocation | cdktf.IResolvable): any;
export declare class CosmosdbAccountGeoLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbAccountGeoLocation | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbAccountGeoLocation | cdktf.IResolvable | undefined);
    private _failoverPriority?;
    get failoverPriority(): number;
    set failoverPriority(value: number);
    get failoverPriorityInput(): number | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class CosmosdbAccountGeoLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbAccountGeoLocation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbAccountGeoLocationOutputReference;
}
export interface CosmosdbAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#type CosmosdbAccount#type}
    */
    readonly type: string;
}
export declare function cosmosdbAccountIdentityToTerraform(struct?: CosmosdbAccountIdentityOutputReference | CosmosdbAccountIdentity): any;
export declare class CosmosdbAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountIdentity | undefined;
    set internalValue(value: CosmosdbAccountIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface CosmosdbAccountRestoreDatabase {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#collection_names CosmosdbAccount#collection_names}
    */
    readonly collectionNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#name CosmosdbAccount#name}
    */
    readonly name: string;
}
export declare function cosmosdbAccountRestoreDatabaseToTerraform(struct?: CosmosdbAccountRestoreDatabase | cdktf.IResolvable): any;
export declare class CosmosdbAccountRestoreDatabaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbAccountRestoreDatabase | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbAccountRestoreDatabase | cdktf.IResolvable | undefined);
    private _collectionNames?;
    get collectionNames(): string[];
    set collectionNames(value: string[]);
    resetCollectionNames(): void;
    get collectionNamesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class CosmosdbAccountRestoreDatabaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbAccountRestoreDatabase[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbAccountRestoreDatabaseOutputReference;
}
export interface CosmosdbAccountRestore {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#restore_timestamp_in_utc CosmosdbAccount#restore_timestamp_in_utc}
    */
    readonly restoreTimestampInUtc: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#source_cosmosdb_account_id CosmosdbAccount#source_cosmosdb_account_id}
    */
    readonly sourceCosmosdbAccountId: string;
    /**
    * database block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#database CosmosdbAccount#database}
    */
    readonly database?: CosmosdbAccountRestoreDatabase[] | cdktf.IResolvable;
}
export declare function cosmosdbAccountRestoreToTerraform(struct?: CosmosdbAccountRestoreOutputReference | CosmosdbAccountRestore): any;
export declare class CosmosdbAccountRestoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountRestore | undefined;
    set internalValue(value: CosmosdbAccountRestore | undefined);
    private _restoreTimestampInUtc?;
    get restoreTimestampInUtc(): string;
    set restoreTimestampInUtc(value: string);
    get restoreTimestampInUtcInput(): string | undefined;
    private _sourceCosmosdbAccountId?;
    get sourceCosmosdbAccountId(): string;
    set sourceCosmosdbAccountId(value: string);
    get sourceCosmosdbAccountIdInput(): string | undefined;
    private _database;
    get database(): CosmosdbAccountRestoreDatabaseList;
    putDatabase(value: CosmosdbAccountRestoreDatabase[] | cdktf.IResolvable): void;
    resetDatabase(): void;
    get databaseInput(): cdktf.IResolvable | CosmosdbAccountRestoreDatabase[] | undefined;
}
export interface CosmosdbAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#create CosmosdbAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#delete CosmosdbAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#read CosmosdbAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#update CosmosdbAccount#update}
    */
    readonly update?: string;
}
export declare function cosmosdbAccountTimeoutsToTerraform(struct?: CosmosdbAccountTimeoutsOutputReference | CosmosdbAccountTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CosmosdbAccountVirtualNetworkRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#id CosmosdbAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account#ignore_missing_vnet_service_endpoint CosmosdbAccount#ignore_missing_vnet_service_endpoint}
    */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
}
export declare function cosmosdbAccountVirtualNetworkRuleToTerraform(struct?: CosmosdbAccountVirtualNetworkRule | cdktf.IResolvable): any;
export declare class CosmosdbAccountVirtualNetworkRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbAccountVirtualNetworkRule | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbAccountVirtualNetworkRule | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _ignoreMissingVnetServiceEndpoint?;
    get ignoreMissingVnetServiceEndpoint(): boolean | cdktf.IResolvable;
    set ignoreMissingVnetServiceEndpoint(value: boolean | cdktf.IResolvable);
    resetIgnoreMissingVnetServiceEndpoint(): void;
    get ignoreMissingVnetServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class CosmosdbAccountVirtualNetworkRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbAccountVirtualNetworkRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbAccountVirtualNetworkRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account azurerm_cosmosdb_account}
*/
export declare class CosmosdbAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cosmosdb_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_account azurerm_cosmosdb_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbAccountConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbAccountConfig);
    private _accessKeyMetadataWritesEnabled?;
    get accessKeyMetadataWritesEnabled(): boolean | cdktf.IResolvable;
    set accessKeyMetadataWritesEnabled(value: boolean | cdktf.IResolvable);
    resetAccessKeyMetadataWritesEnabled(): void;
    get accessKeyMetadataWritesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _analyticalStorageEnabled?;
    get analyticalStorageEnabled(): boolean | cdktf.IResolvable;
    set analyticalStorageEnabled(value: boolean | cdktf.IResolvable);
    resetAnalyticalStorageEnabled(): void;
    get analyticalStorageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get connectionStrings(): string[];
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _defaultIdentityType?;
    get defaultIdentityType(): string;
    set defaultIdentityType(value: string);
    resetDefaultIdentityType(): void;
    get defaultIdentityTypeInput(): string | undefined;
    private _enableAutomaticFailover?;
    get enableAutomaticFailover(): boolean | cdktf.IResolvable;
    set enableAutomaticFailover(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticFailover(): void;
    get enableAutomaticFailoverInput(): boolean | cdktf.IResolvable | undefined;
    private _enableFreeTier?;
    get enableFreeTier(): boolean | cdktf.IResolvable;
    set enableFreeTier(value: boolean | cdktf.IResolvable);
    resetEnableFreeTier(): void;
    get enableFreeTierInput(): boolean | cdktf.IResolvable | undefined;
    private _enableMultipleWriteLocations?;
    get enableMultipleWriteLocations(): boolean | cdktf.IResolvable;
    set enableMultipleWriteLocations(value: boolean | cdktf.IResolvable);
    resetEnableMultipleWriteLocations(): void;
    get enableMultipleWriteLocationsInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipRangeFilter?;
    get ipRangeFilter(): string;
    set ipRangeFilter(value: string);
    resetIpRangeFilter(): void;
    get ipRangeFilterInput(): string | undefined;
    private _isVirtualNetworkFilterEnabled?;
    get isVirtualNetworkFilterEnabled(): boolean | cdktf.IResolvable;
    set isVirtualNetworkFilterEnabled(value: boolean | cdktf.IResolvable);
    resetIsVirtualNetworkFilterEnabled(): void;
    get isVirtualNetworkFilterEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _localAuthenticationDisabled?;
    get localAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set localAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationDisabled(): void;
    get localAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mongoServerVersion?;
    get mongoServerVersion(): string;
    set mongoServerVersion(value: string);
    resetMongoServerVersion(): void;
    get mongoServerVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAclBypassForAzureServices?;
    get networkAclBypassForAzureServices(): boolean | cdktf.IResolvable;
    set networkAclBypassForAzureServices(value: boolean | cdktf.IResolvable);
    resetNetworkAclBypassForAzureServices(): void;
    get networkAclBypassForAzureServicesInput(): boolean | cdktf.IResolvable | undefined;
    private _networkAclBypassIds?;
    get networkAclBypassIds(): string[];
    set networkAclBypassIds(value: string[]);
    resetNetworkAclBypassIds(): void;
    get networkAclBypassIdsInput(): string[] | undefined;
    private _offerType?;
    get offerType(): string;
    set offerType(value: string);
    get offerTypeInput(): string | undefined;
    get primaryKey(): string;
    get primaryReadonlyKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get readEndpoints(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryKey(): string;
    get secondaryReadonlyKey(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get writeEndpoints(): string[];
    private _analyticalStorage;
    get analyticalStorage(): CosmosdbAccountAnalyticalStorageOutputReference;
    putAnalyticalStorage(value: CosmosdbAccountAnalyticalStorage): void;
    resetAnalyticalStorage(): void;
    get analyticalStorageInput(): CosmosdbAccountAnalyticalStorage | undefined;
    private _backup;
    get backup(): CosmosdbAccountBackupOutputReference;
    putBackup(value: CosmosdbAccountBackup): void;
    resetBackup(): void;
    get backupInput(): CosmosdbAccountBackup | undefined;
    private _capabilities;
    get capabilities(): CosmosdbAccountCapabilitiesList;
    putCapabilities(value: CosmosdbAccountCapabilities[] | cdktf.IResolvable): void;
    resetCapabilities(): void;
    get capabilitiesInput(): cdktf.IResolvable | CosmosdbAccountCapabilities[] | undefined;
    private _capacity;
    get capacity(): CosmosdbAccountCapacityOutputReference;
    putCapacity(value: CosmosdbAccountCapacity): void;
    resetCapacity(): void;
    get capacityInput(): CosmosdbAccountCapacity | undefined;
    private _consistencyPolicy;
    get consistencyPolicy(): CosmosdbAccountConsistencyPolicyOutputReference;
    putConsistencyPolicy(value: CosmosdbAccountConsistencyPolicy): void;
    get consistencyPolicyInput(): CosmosdbAccountConsistencyPolicy | undefined;
    private _corsRule;
    get corsRule(): CosmosdbAccountCorsRuleOutputReference;
    putCorsRule(value: CosmosdbAccountCorsRule): void;
    resetCorsRule(): void;
    get corsRuleInput(): CosmosdbAccountCorsRule | undefined;
    private _geoLocation;
    get geoLocation(): CosmosdbAccountGeoLocationList;
    putGeoLocation(value: CosmosdbAccountGeoLocation[] | cdktf.IResolvable): void;
    get geoLocationInput(): cdktf.IResolvable | CosmosdbAccountGeoLocation[] | undefined;
    private _identity;
    get identity(): CosmosdbAccountIdentityOutputReference;
    putIdentity(value: CosmosdbAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): CosmosdbAccountIdentity | undefined;
    private _restore;
    get restore(): CosmosdbAccountRestoreOutputReference;
    putRestore(value: CosmosdbAccountRestore): void;
    resetRestore(): void;
    get restoreInput(): CosmosdbAccountRestore | undefined;
    private _timeouts;
    get timeouts(): CosmosdbAccountTimeoutsOutputReference;
    putTimeouts(value: CosmosdbAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CosmosdbAccountTimeouts | undefined;
    private _virtualNetworkRule;
    get virtualNetworkRule(): CosmosdbAccountVirtualNetworkRuleList;
    putVirtualNetworkRule(value: CosmosdbAccountVirtualNetworkRule[] | cdktf.IResolvable): void;
    resetVirtualNetworkRule(): void;
    get virtualNetworkRuleInput(): cdktf.IResolvable | CosmosdbAccountVirtualNetworkRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
