import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#id DataAzurermSqlServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#name DataAzurermSqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#resource_group_name DataAzurermSqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#timeouts DataAzurermSqlServer#timeouts}
    */
    readonly timeouts?: DataAzurermSqlServerTimeouts;
}
export interface DataAzurermSqlServerIdentity {
}
export declare function dataAzurermSqlServerIdentityToTerraform(struct?: DataAzurermSqlServerIdentity): any;
export declare class DataAzurermSqlServerIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSqlServerIdentity | undefined;
    set internalValue(value: DataAzurermSqlServerIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermSqlServerIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSqlServerIdentityOutputReference;
}
export interface DataAzurermSqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server#read DataAzurermSqlServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSqlServerTimeoutsToTerraform(struct?: DataAzurermSqlServerTimeoutsOutputReference | DataAzurermSqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSqlServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSqlServerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server azurerm_sql_server}
*/
export declare class DataAzurermSqlServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_sql_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/sql_server azurerm_sql_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSqlServerConfig);
    get administratorLogin(): string;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermSqlServerIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermSqlServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
