import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#id DataAzurermVirtualMachineScaleSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#name DataAzurermVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#resource_group_name DataAzurermVirtualMachineScaleSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#timeouts DataAzurermVirtualMachineScaleSet#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualMachineScaleSetTimeouts;
}
export interface DataAzurermVirtualMachineScaleSetIdentity {
}
export declare function dataAzurermVirtualMachineScaleSetIdentityToTerraform(struct?: DataAzurermVirtualMachineScaleSetIdentity): any;
export declare class DataAzurermVirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualMachineScaleSetIdentity | undefined;
    set internalValue(value: DataAzurermVirtualMachineScaleSetIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermVirtualMachineScaleSetIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualMachineScaleSetIdentityOutputReference;
}
export interface DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag {
}
export declare function dataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagToTerraform(struct?: DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag): any;
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | undefined;
    set internalValue(value: DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | undefined);
    get tag(): string;
    get type(): string;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagOutputReference;
}
export interface DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress {
}
export declare function dataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressToTerraform(struct?: DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress): any;
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | undefined;
    set internalValue(value: DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | undefined);
    get domainNameLabel(): string;
    get idleTimeoutInMinutes(): number;
    private _ipTag;
    get ipTag(): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagList;
    get name(): string;
    get publicIpPrefixId(): string;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressOutputReference;
}
export interface DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfiguration {
}
export declare function dataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationToTerraform(struct?: DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfiguration): any;
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfiguration | undefined;
    set internalValue(value: DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfiguration | undefined);
    get applicationGatewayBackendAddressPoolIds(): string[];
    get applicationSecurityGroupIds(): string[];
    get loadBalancerBackendAddressPoolIds(): string[];
    get loadBalancerInboundNatRulesIds(): string[];
    get name(): string;
    get primary(): cdktf.IResolvable;
    private _publicIpAddress;
    get publicIpAddress(): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressList;
    get subnetId(): string;
    get version(): string;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference;
}
export interface DataAzurermVirtualMachineScaleSetNetworkInterface {
}
export declare function dataAzurermVirtualMachineScaleSetNetworkInterfaceToTerraform(struct?: DataAzurermVirtualMachineScaleSetNetworkInterface): any;
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualMachineScaleSetNetworkInterface | undefined;
    set internalValue(value: DataAzurermVirtualMachineScaleSetNetworkInterface | undefined);
    get dnsServers(): string[];
    get enableAcceleratedNetworking(): cdktf.IResolvable;
    get enableIpForwarding(): cdktf.IResolvable;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationList;
    get name(): string;
    get networkSecurityGroupId(): string;
    get primary(): cdktf.IResolvable;
}
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualMachineScaleSetNetworkInterfaceOutputReference;
}
export interface DataAzurermVirtualMachineScaleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#read DataAzurermVirtualMachineScaleSet#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualMachineScaleSetTimeoutsToTerraform(struct?: DataAzurermVirtualMachineScaleSetTimeoutsOutputReference | DataAzurermVirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set azurerm_virtual_machine_scale_set}
*/
export declare class DataAzurermVirtualMachineScaleSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_machine_scale_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set azurerm_virtual_machine_scale_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualMachineScaleSetConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualMachineScaleSetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermVirtualMachineScaleSetIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkInterface;
    get networkInterface(): DataAzurermVirtualMachineScaleSetNetworkInterfaceList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermVirtualMachineScaleSetTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualMachineScaleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualMachineScaleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
