import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorSmartDetectorAlertRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#description MonitorSmartDetectorAlertRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#detector_type MonitorSmartDetectorAlertRule#detector_type}
    */
    readonly detectorType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#enabled MonitorSmartDetectorAlertRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#frequency MonitorSmartDetectorAlertRule#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#id MonitorSmartDetectorAlertRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#name MonitorSmartDetectorAlertRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#resource_group_name MonitorSmartDetectorAlertRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#scope_resource_ids MonitorSmartDetectorAlertRule#scope_resource_ids}
    */
    readonly scopeResourceIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#severity MonitorSmartDetectorAlertRule#severity}
    */
    readonly severity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#tags MonitorSmartDetectorAlertRule#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#throttling_duration MonitorSmartDetectorAlertRule#throttling_duration}
    */
    readonly throttlingDuration?: string;
    /**
    * action_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#action_group MonitorSmartDetectorAlertRule#action_group}
    */
    readonly actionGroup: MonitorSmartDetectorAlertRuleActionGroup;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#timeouts MonitorSmartDetectorAlertRule#timeouts}
    */
    readonly timeouts?: MonitorSmartDetectorAlertRuleTimeouts;
}
export interface MonitorSmartDetectorAlertRuleActionGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#email_subject MonitorSmartDetectorAlertRule#email_subject}
    */
    readonly emailSubject?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#ids MonitorSmartDetectorAlertRule#ids}
    */
    readonly ids: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#webhook_payload MonitorSmartDetectorAlertRule#webhook_payload}
    */
    readonly webhookPayload?: string;
}
export declare function monitorSmartDetectorAlertRuleActionGroupToTerraform(struct?: MonitorSmartDetectorAlertRuleActionGroupOutputReference | MonitorSmartDetectorAlertRuleActionGroup): any;
export declare class MonitorSmartDetectorAlertRuleActionGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorSmartDetectorAlertRuleActionGroup | undefined;
    set internalValue(value: MonitorSmartDetectorAlertRuleActionGroup | undefined);
    private _emailSubject?;
    get emailSubject(): string;
    set emailSubject(value: string);
    resetEmailSubject(): void;
    get emailSubjectInput(): string | undefined;
    private _ids?;
    get ids(): string[];
    set ids(value: string[]);
    get idsInput(): string[] | undefined;
    private _webhookPayload?;
    get webhookPayload(): string;
    set webhookPayload(value: string);
    resetWebhookPayload(): void;
    get webhookPayloadInput(): string | undefined;
}
export interface MonitorSmartDetectorAlertRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#create MonitorSmartDetectorAlertRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#delete MonitorSmartDetectorAlertRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#read MonitorSmartDetectorAlertRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule#update MonitorSmartDetectorAlertRule#update}
    */
    readonly update?: string;
}
export declare function monitorSmartDetectorAlertRuleTimeoutsToTerraform(struct?: MonitorSmartDetectorAlertRuleTimeoutsOutputReference | MonitorSmartDetectorAlertRuleTimeouts | cdktf.IResolvable): any;
export declare class MonitorSmartDetectorAlertRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorSmartDetectorAlertRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorSmartDetectorAlertRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule azurerm_monitor_smart_detector_alert_rule}
*/
export declare class MonitorSmartDetectorAlertRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_smart_detector_alert_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_smart_detector_alert_rule azurerm_monitor_smart_detector_alert_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorSmartDetectorAlertRuleConfig
    */
    constructor(scope: Construct, id: string, config: MonitorSmartDetectorAlertRuleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _detectorType?;
    get detectorType(): string;
    set detectorType(value: string);
    get detectorTypeInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopeResourceIds?;
    get scopeResourceIds(): string[];
    set scopeResourceIds(value: string[]);
    get scopeResourceIdsInput(): string[] | undefined;
    private _severity?;
    get severity(): string;
    set severity(value: string);
    get severityInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _throttlingDuration?;
    get throttlingDuration(): string;
    set throttlingDuration(value: string);
    resetThrottlingDuration(): void;
    get throttlingDurationInput(): string | undefined;
    private _actionGroup;
    get actionGroup(): MonitorSmartDetectorAlertRuleActionGroupOutputReference;
    putActionGroup(value: MonitorSmartDetectorAlertRuleActionGroup): void;
    get actionGroupInput(): MonitorSmartDetectorAlertRuleActionGroup | undefined;
    private _timeouts;
    get timeouts(): MonitorSmartDetectorAlertRuleTimeoutsOutputReference;
    putTimeouts(value: MonitorSmartDetectorAlertRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorSmartDetectorAlertRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
