"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Determines how symlinks are followed.
 */
var SymlinkFollowMode;
(function (SymlinkFollowMode) {
    /**
     * Never follow symlinks.
     */
    SymlinkFollowMode["NEVER"] = "never";
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    SymlinkFollowMode["ALWAYS"] = "always";
    /**
     * Only follows symlinks that are external to the source directory.
     */
    SymlinkFollowMode["EXTERNAL"] = "external";
    /**
     * Forbids source from having any symlinks pointing outside of the source
     * tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     */
    SymlinkFollowMode["BLOCK_EXTERNAL"] = "internal-only";
})(SymlinkFollowMode = exports.SymlinkFollowMode || (exports.SymlinkFollowMode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3B0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm9wdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7R0FFRztBQUNILElBQVksaUJBMkJYO0FBM0JELFdBQVksaUJBQWlCO0lBQzNCOztPQUVHO0lBQ0gsb0NBQWUsQ0FBQTtJQUVmOztPQUVHO0lBQ0gsc0NBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCwwQ0FBcUIsQ0FBQTtJQUVyQjs7Ozs7Ozs7O09BU0c7SUFDSCxxREFBZ0MsQ0FBQTtBQUNsQyxDQUFDLEVBM0JXLGlCQUFpQixHQUFqQix5QkFBaUIsS0FBakIseUJBQWlCLFFBMkI1QiIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogRGV0ZXJtaW5lcyBob3cgc3ltbGlua3MgYXJlIGZvbGxvd2VkLlxuICovXG5leHBvcnQgZW51bSBTeW1saW5rRm9sbG93TW9kZSB7XG4gIC8qKlxuICAgKiBOZXZlciBmb2xsb3cgc3ltbGlua3MuXG4gICAqL1xuICBORVZFUiA9ICduZXZlcicsXG5cbiAgLyoqXG4gICAqIE1hdGVyaWFsaXplIGFsbCBzeW1saW5rcywgd2hldGhlciB0aGV5IGFyZSBpbnRlcm5hbCBvciBleHRlcm5hbCB0byB0aGUgc291cmNlIGRpcmVjdG9yeS5cbiAgICovXG4gIEFMV0FZUyA9ICdhbHdheXMnLFxuXG4gIC8qKlxuICAgKiBPbmx5IGZvbGxvd3Mgc3ltbGlua3MgdGhhdCBhcmUgZXh0ZXJuYWwgdG8gdGhlIHNvdXJjZSBkaXJlY3RvcnkuXG4gICAqL1xuICBFWFRFUk5BTCA9ICdleHRlcm5hbCcsXG5cbiAgLyoqXG4gICAqIEZvcmJpZHMgc291cmNlIGZyb20gaGF2aW5nIGFueSBzeW1saW5rcyBwb2ludGluZyBvdXRzaWRlIG9mIHRoZSBzb3VyY2VcbiAgICogdHJlZS5cbiAgICpcbiAgICogVGhpcyBpcyB0aGUgc2FmZXN0IG1vZGUgb2Ygb3BlcmF0aW9uIGFzIGl0IGVuc3VyZXMgdGhhdCBjb3B5IG9wZXJhdGlvbnNcbiAgICogd29uJ3QgbWF0ZXJpYWxpemUgZmlsZXMgZnJvbSB0aGUgdXNlcidzIGZpbGUgc3lzdGVtLiBJbnRlcm5hbCBzeW1saW5rcyBhcmVcbiAgICogbm90IGZvbGxvd2VkLlxuICAgKlxuICAgKiBJZiB0aGUgY29weSBvcGVyYXRpb24gcnVucyBpbnRvIGFuIGV4dGVybmFsIHN5bWxpbmssIGl0IHdpbGwgZmFpbC5cbiAgICovXG4gIEJMT0NLX0VYVEVSTkFMID0gJ2ludGVybmFsLW9ubHknLFxufVxuXG4vKipcbiAqIE9idGFpbnMgYXBwbGllZCB3aGVuIGNvcHlpbmcgZGlyZWN0b3JpZXMgaW50byB0aGUgc3RhZ2luZyBsb2NhdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDb3B5T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBBIHN0cmF0ZWd5IGZvciBob3cgdG8gaGFuZGxlIHN5bWxpbmtzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBTeW1saW5rRm9sbG93TW9kZS5ORVZFUlxuICAgKi9cbiAgcmVhZG9ubHkgZm9sbG93PzogU3ltbGlua0ZvbGxvd01vZGU7XG5cbiAgLyoqXG4gICAqIEdsb2IgcGF0dGVybnMgdG8gZXhjbHVkZSBmcm9tIHRoZSBjb3B5LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vdGhpbmcgaXMgZXhjbHVkZWRcbiAgICovXG4gIHJlYWRvbmx5IGV4Y2x1ZGU/OiBzdHJpbmdbXTtcbn1cblxuLyoqXG4gKiBPcHRpb25zIHJlbGF0ZWQgdG8gY2FsY3VsYXRpbmcgc291cmNlIGhhc2guXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRmluZ2VycHJpbnRPcHRpb25zIGV4dGVuZHMgQ29weU9wdGlvbnMge1xuICAvKipcbiAgICogRXh0cmEgaW5mb3JtYXRpb24gdG8gZW5jb2RlIGludG8gdGhlIGZpbmdlcnByaW50IChlLmcuIGJ1aWxkIGluc3RydWN0aW9uc1xuICAgKiBhbmQgb3RoZXIgaW5wdXRzKVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGhhc2ggaXMgb25seSBiYXNlZCBvbiBzb3VyY2UgY29udGVudFxuICAgKi9cbiAgcmVhZG9ubHkgZXh0cmFIYXNoPzogc3RyaW5nO1xufVxuIl19