"use strict";
const fs = require("fs");
const os = require("os");
const path = require("path");
const runtime_info_1 = require("../lib/private/runtime-info");
module.exports = {
    'version reporting includes @aws-solutions-konstruk libraries'(test) {
        const pkgdir = fs.mkdtempSync(path.join(os.tmpdir(), 'runtime-info-konstruk-fixture'));
        const mockVersion = '1.2.3';
        fs.writeFileSync(path.join(pkgdir, 'index.js'), 'module.exports = \'this is foo\';');
        fs.writeFileSync(path.join(pkgdir, 'package.json'), JSON.stringify({
            name: '@aws-solutions-konstruk/foo',
            version: mockVersion,
        }));
        // eslint-disable-next-line @typescript-eslint/no-require-imports, import/no-extraneous-dependencies
        require(pkgdir);
        const runtimeInfo = runtime_info_1.collectRuntimeInformation();
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const version = require('../package.json').version;
        test.deepEqual(runtimeInfo.libraries, {
            '@aws-cdk/core': version,
            '@aws-cdk/cx-api': version,
            '@aws-cdk/cloud-assembly-schema': version,
            '@aws-solutions-konstruk/foo': mockVersion,
            'jsii-runtime': `node.js/${process.version}`,
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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