"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rotating = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/time/r/rotating time_rotating}
*/
class Rotating extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/time/r/rotating time_rotating} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatingConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'time_rotating',
            terraformGeneratorMetadata: {
                providerName: 'time',
                providerVersion: '0.8.0',
                providerVersionConstraint: '~> 0.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._rfc3339 = config.rfc3339;
        this._rotationDays = config.rotationDays;
        this._rotationHours = config.rotationHours;
        this._rotationMinutes = config.rotationMinutes;
        this._rotationMonths = config.rotationMonths;
        this._rotationRfc3339 = config.rotationRfc3339;
        this._rotationYears = config.rotationYears;
        this._triggers = config.triggers;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // day - computed: true, optional: false, required: false
    get day() {
        return this.getNumberAttribute('day');
    }
    // hour - computed: true, optional: false, required: false
    get hour() {
        return this.getNumberAttribute('hour');
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // minute - computed: true, optional: false, required: false
    get minute() {
        return this.getNumberAttribute('minute');
    }
    // month - computed: true, optional: false, required: false
    get month() {
        return this.getNumberAttribute('month');
    }
    get rfc3339() {
        return this.getStringAttribute('rfc3339');
    }
    set rfc3339(value) {
        this._rfc3339 = value;
    }
    resetRfc3339() {
        this._rfc3339 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rfc3339Input() {
        return this._rfc3339;
    }
    get rotationDays() {
        return this.getNumberAttribute('rotation_days');
    }
    set rotationDays(value) {
        this._rotationDays = value;
    }
    resetRotationDays() {
        this._rotationDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationDaysInput() {
        return this._rotationDays;
    }
    get rotationHours() {
        return this.getNumberAttribute('rotation_hours');
    }
    set rotationHours(value) {
        this._rotationHours = value;
    }
    resetRotationHours() {
        this._rotationHours = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationHoursInput() {
        return this._rotationHours;
    }
    get rotationMinutes() {
        return this.getNumberAttribute('rotation_minutes');
    }
    set rotationMinutes(value) {
        this._rotationMinutes = value;
    }
    resetRotationMinutes() {
        this._rotationMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationMinutesInput() {
        return this._rotationMinutes;
    }
    get rotationMonths() {
        return this.getNumberAttribute('rotation_months');
    }
    set rotationMonths(value) {
        this._rotationMonths = value;
    }
    resetRotationMonths() {
        this._rotationMonths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationMonthsInput() {
        return this._rotationMonths;
    }
    get rotationRfc3339() {
        return this.getStringAttribute('rotation_rfc3339');
    }
    set rotationRfc3339(value) {
        this._rotationRfc3339 = value;
    }
    resetRotationRfc3339() {
        this._rotationRfc3339 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationRfc3339Input() {
        return this._rotationRfc3339;
    }
    get rotationYears() {
        return this.getNumberAttribute('rotation_years');
    }
    set rotationYears(value) {
        this._rotationYears = value;
    }
    resetRotationYears() {
        this._rotationYears = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rotationYearsInput() {
        return this._rotationYears;
    }
    // second - computed: true, optional: false, required: false
    get second() {
        return this.getNumberAttribute('second');
    }
    get triggers() {
        return this.getStringMapAttribute('triggers');
    }
    set triggers(value) {
        this._triggers = value;
    }
    resetTriggers() {
        this._triggers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggersInput() {
        return this._triggers;
    }
    // unix - computed: true, optional: false, required: false
    get unix() {
        return this.getNumberAttribute('unix');
    }
    // year - computed: true, optional: false, required: false
    get year() {
        return this.getNumberAttribute('year');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            rfc3339: cdktf.stringToTerraform(this._rfc3339),
            rotation_days: cdktf.numberToTerraform(this._rotationDays),
            rotation_hours: cdktf.numberToTerraform(this._rotationHours),
            rotation_minutes: cdktf.numberToTerraform(this._rotationMinutes),
            rotation_months: cdktf.numberToTerraform(this._rotationMonths),
            rotation_rfc3339: cdktf.stringToTerraform(this._rotationRfc3339),
            rotation_years: cdktf.numberToTerraform(this._rotationYears),
            triggers: cdktf.hashMapper(cdktf.stringToTerraform)(this._triggers),
        };
    }
}
exports.Rotating = Rotating;
_a = JSII_RTTI_SYMBOL_1;
Rotating[_a] = { fqn: "@cdktf/provider-time.Rotating", version: "2.0.55" };
// =================
// STATIC PROPERTIES
// =================
Rotating.tfResourceType = "time_rotating";
//# sourceMappingURL=data:application/json;base64,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