# Generated by Django 2.2.4 on 2019-11-05 17:04

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Aggregation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(max_length=100, unique=True)),
                ('pipeline', models.TextField(default='[]', max_length=20480, verbose_name='Pipeline')),
                ('database_name', models.CharField(max_length=256)),
                ('collection_name', models.CharField(max_length=256)),
                ('output_collection_name', models.CharField(help_text='The resulting collection.\n        Do not include $out in your pipeline.', max_length=256)),
                ('creation_date', models.DateField(auto_now_add=True)),
                ('execute_now', models.BooleanField(blank=True, default=False)),
                ('scheduled_job_in_process', models.BooleanField(blank=True, default=False)),
                ('scheduled_job_completed_for_today', models.BooleanField(blank=True, default=False)),
                ('scheduled_job_not_ran', models.BooleanField(blank=True, default=True)),
                ('execute_everyday', models.BooleanField(blank=True, default=False)),
                ('execute_sunday', models.BooleanField(blank=True, default=False)),
                ('execute_monday', models.BooleanField(blank=True, default=False)),
                ('execute_tuesday', models.BooleanField(blank=True, default=False)),
                ('execute_wednesday', models.BooleanField(blank=True, default=False)),
                ('execute_thursday', models.BooleanField(blank=True, default=False)),
                ('execute_friday', models.BooleanField(blank=True, default=False)),
                ('execute_saturday', models.BooleanField(blank=True, default=False)),
                ('execute_time_1', models.TimeField(help_text='Use 24 hour time. (e.g. 20:30:00 for 8:30 pm)', verbose_name='Execute Time')),
                ('description', models.TextField(blank=True, default='', max_length=1024)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Saved Aggregations',
                'ordering': ('-creation_date',),
                'get_latest_by': 'creation_date',
            },
        ),
    ]
