# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-06-17 17:55
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(max_length=500, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=500)),
                ('slug', models.SlugField(blank=True, max_length=500, unique=True)),
                ('cover_image', models.ImageField(blank=True, null=True, upload_to='blog_post_images')),
                ('content', models.TextField()),
                ('status', models.CharField(choices=[('D', 'Draft'), ('P', 'Published')], default='D', max_length=1)),
                ('published_date', models.DateTimeField(auto_now_add=True, null=True)),
                ('allow_comments', models.BooleanField(default=True)),
                ('seo_title', models.CharField(blank=True, help_text='Optional. This title is inserted in HTML Title tag. If not filled, blog title will be used.', max_length=500)),
                ('seo_description', models.TextField(blank=True, help_text='Optional. This description is inserted in HTML meta description tag.If not filled, the first paragraph from the content will be inserted here.', null=True)),
                ('seo_keywords', models.TextField(blank=True, help_text='Optional. This is not auto generated. The filled content will beinserted in meta keywords tag', null=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('categories', models.ManyToManyField(blank=True, to='django_cowhite_cms.Category')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
