import os
from setuptools import find_packages, setup

with open(os.path.join(os.path.dirname(__file__), 'README.md')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-cowhite-cms',
    version='0.3.3',
    packages=find_packages(),
    include_package_data=True,
    license='MIT License',
    description='A simple Django cms. As of now only pages are supported. Blog is available in another package django-cowhite-blog',
    long_description=README,
    url='https://github.com/cowhite/django-cowhite-cms',
    author='Cowhite Software Pvt Ltd',
    author_email='hello@cowhite.com',
    python_requires=">=2.7,<=3.6",
    install_requires=["django >= 1.11, < 1.12"],
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Framework :: Django :: 1.11',  # replace "X.Y" as appropriate
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',  # example license
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        # Replace these appropriately if you are stuck on Python 2.
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
