(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: FigAnchor *)
(* :Context: SciDraw` *)
(* :Summary: Declares the figure anchor object class *)
(* :Author: Mark A. Caprio, Department of Physics, University of Notre Dame *)
(* :Copyright: Copyright FIGYEAR, Mark A. Caprio *)
(* :Package Version: FIGVERSION *)
(* :Mathematica Version: MATHVERSION *)
(* :Discussion: FIGDISCUSSION *)
(* :History: See main package file. *)


BeginPackage["SciDraw`",SciDraw`Private`$ExternalContexts];


Unprotect[Evaluate[$Context<>"*"]];


Begin["`Private`"];





Constructor[Class:FigAnchor,Self_Object][p:FigCoordinatePointPattern,Offset:FigOffsetPattern:Center,theta:(_?NumericQ):0]:=Module[
{},
Self@SetPoint[FigResolvePoint[p]];
Self@SetOffset[FigResolveOffset[Offset]];
Self@SetAngle[theta];
];


Constructor[Class:FigAnchor,Self_Object][
Object[n:ObjectNamePattern[FigAnchor]]|(n:ObjectNamePattern[FigAnchor])
]:=Module[
{},
SetObjectData[Self,Object[n]];
];


Constructor[Class:FigAnchor,Self_Object][
Object[n:ObjectNamePattern[FigAnchor]]|(n:ObjectNamePattern[FigAnchor]),
Offset:FigOffsetPattern:Center
]:=Module[
{},
SetObjectData[Self,Object[n]];
Self@SetOffset[FigResolveOffset[Offset]];
];


Constructor[Class:FigAnchor,Self_Object][
Object[n:ObjectNamePattern[FigAnchor]]|(n:ObjectNamePattern[FigAnchor]),
Offset:FigOffsetPattern,theta:(_?NumericQ)
]:=Module[
{},
SetObjectData[Self,Object[n]];
Self@SetOffset[FigResolveOffset[Offset]];
Self@SetAngle[theta];
];


(* 
Matching fails when optional arguments omitted (under Mathematica 8):
Constructor[Class:FigAnchor,Self_Object][
Object[n:ObjectNamePattern[FigAnchor]]|(n:ObjectNamePattern[FigAnchor]),
Offset:{_?NumericQ,_?NumericQ}:Automatic,theta:(_?NumericQ):Automatic
]:=Module[
{},
Self@SetPoint[Object[n]@GetPoint[]];
Self@SetOffset[ReplaceSequential[Offset,{Automatic:>Object[n]@GetOffset[]}]];
Self@SetAngle[ReplaceSequential[theta,{Automatic:>Object[n]@GetAngle[]}]];
];
*)


General::figmakeanchor="Unable to resolve anchor specification `1`.\n(Diagnostic information: `2`)";


Constructor[Class:FigAnchor,Self_Object][p:(n:ObjectNamePattern[FigObject]),Name_,Arg_:None]:=Module[
{TemporaryAnchor},

TemporaryAnchor=Object[n]@MakeAnchor[Name,Arg];
(* verify success of MakeAnchor call *)
If[
Head[TemporaryAnchor]=!=Object,
FigError[Self,"figmakeanchor",p,TemporaryAnchor]
];

(* copy temporary anchor to self *)
SetObjectData[Self,TemporaryAnchor];
];


(* advanced anchor wrapper -- UNDER CONSTRUCTION *)
(*
Constructor[Class:FigAnchor,Self_Object][p:(n:ObjectNamePattern[FigObject]),Name_,Opts___?OptionsPattern]:=Module[
{OptionsList=Flatten[{Opts}],TemporaryAnchor},

TemporaryAnchor=Object[n]@MakeAnchor[Name,OptionsList];
(* verify success of MakeAnchor call *)
If[
Head[TemporaryAnchor]=!=Object,
FigError[Self,"figmakeanchor",p,TemporaryAnchor]
];

(* copy temporary anchor to self *)
SetObjectData[Self,TemporaryAnchor];
];
*)


OnCreationFailure[FigAnchor,Self_Object][___]:=FigError[FigAnchor,"nocreate"];


ShowAnchor[p:FigPointPattern]:=Module[
{Anchor},
Anchor=FigAnchor[p];
Print["Anchor: canvas point ",Anchor@GetPoint[],", text offset ",Anchor@GetOffset[],", tilt angle ",Row[{Anchor@GetAngle[]/Degree,Degree}]];
];


DeclareFigFallThroughError[ShowAnchor];


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"$*"]];
EndPackage[];
