# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.20.6
    Contact: vrchatapi.lpv0t@aries.fyi
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vrchatapi.api_client import ApiClient
from vrchatapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CalendarApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_group_calendar_event(self, group_id, create_calendar_event_request, **kwargs):  # noqa: E501
        """Create a calendar event  # noqa: E501

        Creates an event for a group on the calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_group_calendar_event(group_id, create_calendar_event_request, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param create_calendar_event_request: (required)
        :type create_calendar_event_request: CreateCalendarEventRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarEvent
        """
        kwargs['_return_http_data_only'] = True
        return self.create_group_calendar_event_with_http_info(group_id, create_calendar_event_request, **kwargs)  # noqa: E501

    def create_group_calendar_event_with_http_info(self, group_id, create_calendar_event_request, **kwargs):  # noqa: E501
        """Create a calendar event  # noqa: E501

        Creates an event for a group on the calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_group_calendar_event_with_http_info(group_id, create_calendar_event_request, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param create_calendar_event_request: (required)
        :type create_calendar_event_request: CreateCalendarEventRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarEvent, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id',
            'create_calendar_event_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_group_calendar_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `create_group_calendar_event`")  # noqa: E501
        # verify the required parameter 'create_calendar_event_request' is set
        if self.api_client.client_side_validation and local_var_params.get('create_calendar_event_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_calendar_event_request` when calling `create_group_calendar_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_calendar_event_request' in local_var_params:
            body_params = local_var_params['create_calendar_event_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "CalendarEvent",
            400: "Error",
            401: "Error",
            403: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}/event', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_group_calendar_event(self, group_id, calendar_id, **kwargs):  # noqa: E501
        """Delete a calendar event  # noqa: E501

        Delete a group calendar event  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_group_calendar_event(group_id, calendar_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Success
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_group_calendar_event_with_http_info(group_id, calendar_id, **kwargs)  # noqa: E501

    def delete_group_calendar_event_with_http_info(self, group_id, calendar_id, **kwargs):  # noqa: E501
        """Delete a calendar event  # noqa: E501

        Delete a group calendar event  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_group_calendar_event_with_http_info(group_id, calendar_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Success, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id',
            'calendar_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_group_calendar_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `delete_group_calendar_event`")  # noqa: E501
        # verify the required parameter 'calendar_id' is set
        if self.api_client.client_side_validation and local_var_params.get('calendar_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `calendar_id` when calling `delete_group_calendar_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501
        if 'calendar_id' in local_var_params:
            path_params['calendarId'] = local_var_params['calendar_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "Success",
            401: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}/{calendarId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def discover_calendar_events(self, **kwargs):  # noqa: E501
        """Discover calendar events  # noqa: E501

        Get a list of calendar events Initially, call without a `nextCursor` parameter For every successive call, use the `nextCursor` property returned in the previous call & the `number` of entries desired for this call The `nextCursor` internally keeps track of the `offset` of the results, the initial request parameters, and accounts for discrepancies that might arise from time elapsed between calls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.discover_calendar_events(async_req=True)
        >>> result = thread.get()

        :param scope: Scope for calendar event discovery.
        :type scope: CalendarEventDiscoveryScope
        :param categories: Filter for calendar event discovery.
        :type categories: str
        :param tags: Filter for calendar event discovery.
        :type tags: str
        :param featured_results: Filter for calendar event discovery.
        :type featured_results: CalendarEventDiscoveryInclusion
        :param non_featured_results: Filter for calendar event discovery.
        :type non_featured_results: CalendarEventDiscoveryInclusion
        :param personalized_results: Filter for calendar event discovery.
        :type personalized_results: CalendarEventDiscoveryInclusion
        :param minimum_interest_count: Filter for calendar event discovery.
        :type minimum_interest_count: int
        :param minimum_remaining_minutes: Filter for calendar event discovery.
        :type minimum_remaining_minutes: int
        :param upcoming_offset_minutes: Filter for calendar event discovery.
        :type upcoming_offset_minutes: int
        :param n: The number of objects to return.
        :type n: int
        :param next_cursor: Cursor returned from previous calendar discovery queries (see nextCursor property of the schema CalendarEventDiscovery).
        :type next_cursor: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarEventDiscovery
        """
        kwargs['_return_http_data_only'] = True
        return self.discover_calendar_events_with_http_info(**kwargs)  # noqa: E501

    def discover_calendar_events_with_http_info(self, **kwargs):  # noqa: E501
        """Discover calendar events  # noqa: E501

        Get a list of calendar events Initially, call without a `nextCursor` parameter For every successive call, use the `nextCursor` property returned in the previous call & the `number` of entries desired for this call The `nextCursor` internally keeps track of the `offset` of the results, the initial request parameters, and accounts for discrepancies that might arise from time elapsed between calls  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.discover_calendar_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param scope: Scope for calendar event discovery.
        :type scope: CalendarEventDiscoveryScope
        :param categories: Filter for calendar event discovery.
        :type categories: str
        :param tags: Filter for calendar event discovery.
        :type tags: str
        :param featured_results: Filter for calendar event discovery.
        :type featured_results: CalendarEventDiscoveryInclusion
        :param non_featured_results: Filter for calendar event discovery.
        :type non_featured_results: CalendarEventDiscoveryInclusion
        :param personalized_results: Filter for calendar event discovery.
        :type personalized_results: CalendarEventDiscoveryInclusion
        :param minimum_interest_count: Filter for calendar event discovery.
        :type minimum_interest_count: int
        :param minimum_remaining_minutes: Filter for calendar event discovery.
        :type minimum_remaining_minutes: int
        :param upcoming_offset_minutes: Filter for calendar event discovery.
        :type upcoming_offset_minutes: int
        :param n: The number of objects to return.
        :type n: int
        :param next_cursor: Cursor returned from previous calendar discovery queries (see nextCursor property of the schema CalendarEventDiscovery).
        :type next_cursor: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarEventDiscovery, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'categories',
            'tags',
            'featured_results',
            'non_featured_results',
            'personalized_results',
            'minimum_interest_count',
            'minimum_remaining_minutes',
            'upcoming_offset_minutes',
            'n',
            'next_cursor'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method discover_calendar_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `discover_calendar_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `discover_calendar_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('scope') is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if local_var_params.get('categories') is not None:  # noqa: E501
            query_params.append(('categories', local_var_params['categories']))  # noqa: E501
        if local_var_params.get('tags') is not None:  # noqa: E501
            query_params.append(('tags', local_var_params['tags']))  # noqa: E501
        if local_var_params.get('featured_results') is not None:  # noqa: E501
            query_params.append(('featuredResults', local_var_params['featured_results']))  # noqa: E501
        if local_var_params.get('non_featured_results') is not None:  # noqa: E501
            query_params.append(('nonFeaturedResults', local_var_params['non_featured_results']))  # noqa: E501
        if local_var_params.get('personalized_results') is not None:  # noqa: E501
            query_params.append(('personalizedResults', local_var_params['personalized_results']))  # noqa: E501
        if local_var_params.get('minimum_interest_count') is not None:  # noqa: E501
            query_params.append(('minimumInterestCount', local_var_params['minimum_interest_count']))  # noqa: E501
        if local_var_params.get('minimum_remaining_minutes') is not None:  # noqa: E501
            query_params.append(('minimumRemainingMinutes', local_var_params['minimum_remaining_minutes']))  # noqa: E501
        if local_var_params.get('upcoming_offset_minutes') is not None:  # noqa: E501
            query_params.append(('upcomingOffsetMinutes', local_var_params['upcoming_offset_minutes']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('next_cursor') is not None:  # noqa: E501
            query_params.append(('nextCursor', local_var_params['next_cursor']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "CalendarEventDiscovery",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/discover', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def follow_group_calendar_event(self, group_id, calendar_id, follow_calendar_event_request, **kwargs):  # noqa: E501
        """Follow a calendar event  # noqa: E501

        Follow or unfollow an event on a group's calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.follow_group_calendar_event(group_id, calendar_id, follow_calendar_event_request, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param follow_calendar_event_request: (required)
        :type follow_calendar_event_request: FollowCalendarEventRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarEvent
        """
        kwargs['_return_http_data_only'] = True
        return self.follow_group_calendar_event_with_http_info(group_id, calendar_id, follow_calendar_event_request, **kwargs)  # noqa: E501

    def follow_group_calendar_event_with_http_info(self, group_id, calendar_id, follow_calendar_event_request, **kwargs):  # noqa: E501
        """Follow a calendar event  # noqa: E501

        Follow or unfollow an event on a group's calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.follow_group_calendar_event_with_http_info(group_id, calendar_id, follow_calendar_event_request, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param follow_calendar_event_request: (required)
        :type follow_calendar_event_request: FollowCalendarEventRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarEvent, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id',
            'calendar_id',
            'follow_calendar_event_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method follow_group_calendar_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `follow_group_calendar_event`")  # noqa: E501
        # verify the required parameter 'calendar_id' is set
        if self.api_client.client_side_validation and local_var_params.get('calendar_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `calendar_id` when calling `follow_group_calendar_event`")  # noqa: E501
        # verify the required parameter 'follow_calendar_event_request' is set
        if self.api_client.client_side_validation and local_var_params.get('follow_calendar_event_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `follow_calendar_event_request` when calling `follow_group_calendar_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501
        if 'calendar_id' in local_var_params:
            path_params['calendarId'] = local_var_params['calendar_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'follow_calendar_event_request' in local_var_params:
            body_params = local_var_params['follow_calendar_event_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "CalendarEvent",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}/{calendarId}/follow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_calendar_events(self, **kwargs):  # noqa: E501
        """List calendar events  # noqa: E501

        Get a list of a user's calendar events for the month in ?date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_calendar_events(async_req=True)
        >>> result = thread.get()

        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedCalendarEventList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_calendar_events_with_http_info(**kwargs)  # noqa: E501

    def get_calendar_events_with_http_info(self, **kwargs):  # noqa: E501
        """List calendar events  # noqa: E501

        Get a list of a user's calendar events for the month in ?date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_calendar_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedCalendarEventList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'date',
            'n',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calendar_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_calendar_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_calendar_events`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_calendar_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('date') is not None:  # noqa: E501
            query_params.append(('date', local_var_params['date']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "PaginatedCalendarEventList",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_featured_calendar_events(self, **kwargs):  # noqa: E501
        """List featured calendar events  # noqa: E501

        Get a list of a featured calendar events for the month in ?date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_featured_calendar_events(async_req=True)
        >>> result = thread.get()

        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedCalendarEventList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_featured_calendar_events_with_http_info(**kwargs)  # noqa: E501

    def get_featured_calendar_events_with_http_info(self, **kwargs):  # noqa: E501
        """List featured calendar events  # noqa: E501

        Get a list of a featured calendar events for the month in ?date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_featured_calendar_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedCalendarEventList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'date',
            'n',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_featured_calendar_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_featured_calendar_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_featured_calendar_events`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_featured_calendar_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('date') is not None:  # noqa: E501
            query_params.append(('date', local_var_params['date']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "PaginatedCalendarEventList",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/featured', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_followed_calendar_events(self, **kwargs):  # noqa: E501
        """List followed calendar events  # noqa: E501

        Get a list of a followed calendar events for the month in ?date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_followed_calendar_events(async_req=True)
        >>> result = thread.get()

        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedCalendarEventList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_followed_calendar_events_with_http_info(**kwargs)  # noqa: E501

    def get_followed_calendar_events_with_http_info(self, **kwargs):  # noqa: E501
        """List followed calendar events  # noqa: E501

        Get a list of a followed calendar events for the month in ?date  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_followed_calendar_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedCalendarEventList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'date',
            'n',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_followed_calendar_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_followed_calendar_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_followed_calendar_events`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_followed_calendar_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('date') is not None:  # noqa: E501
            query_params.append(('date', local_var_params['date']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "PaginatedCalendarEventList",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/following', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_group_calendar_event(self, group_id, calendar_id, **kwargs):  # noqa: E501
        """Get a calendar event  # noqa: E501

        Get a group calendar event  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_calendar_event(group_id, calendar_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarEvent
        """
        kwargs['_return_http_data_only'] = True
        return self.get_group_calendar_event_with_http_info(group_id, calendar_id, **kwargs)  # noqa: E501

    def get_group_calendar_event_with_http_info(self, group_id, calendar_id, **kwargs):  # noqa: E501
        """Get a calendar event  # noqa: E501

        Get a group calendar event  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_calendar_event_with_http_info(group_id, calendar_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarEvent, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id',
            'calendar_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_calendar_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `get_group_calendar_event`")  # noqa: E501
        # verify the required parameter 'calendar_id' is set
        if self.api_client.client_side_validation and local_var_params.get('calendar_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `calendar_id` when calling `get_group_calendar_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501
        if 'calendar_id' in local_var_params:
            path_params['calendarId'] = local_var_params['calendar_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "CalendarEvent",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}/{calendarId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_group_calendar_event_ics(self, group_id, calendar_id, **kwargs):  # noqa: E501
        """Download calendar event as ICS  # noqa: E501

        Returns the specified calendar in iCalendar (ICS) format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_calendar_event_ics(group_id, calendar_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.get_group_calendar_event_ics_with_http_info(group_id, calendar_id, **kwargs)  # noqa: E501

    def get_group_calendar_event_ics_with_http_info(self, group_id, calendar_id, **kwargs):  # noqa: E501
        """Download calendar event as ICS  # noqa: E501

        Returns the specified calendar in iCalendar (ICS) format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_calendar_event_ics_with_http_info(group_id, calendar_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id',
            'calendar_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_calendar_event_ics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `get_group_calendar_event_ics`")  # noqa: E501
        # verify the required parameter 'calendar_id' is set
        if self.api_client.client_side_validation and local_var_params.get('calendar_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `calendar_id` when calling `get_group_calendar_event_ics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501
        if 'calendar_id' in local_var_params:
            path_params['calendarId'] = local_var_params['calendar_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/calendar', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "file",
            401: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}/{calendarId}.ics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_group_calendar_events(self, group_id, **kwargs):  # noqa: E501
        """List a group's calendar events  # noqa: E501

        Get a list of a group's calendar events  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_calendar_events(group_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedCalendarEventList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_group_calendar_events_with_http_info(group_id, **kwargs)  # noqa: E501

    def get_group_calendar_events_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """List a group's calendar events  # noqa: E501

        Get a list of a group's calendar events  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_calendar_events_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param date: The month to search in.
        :type date: datetime
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedCalendarEventList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id',
            'date',
            'n',
            'offset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_calendar_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `get_group_calendar_events`")  # noqa: E501

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_group_calendar_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_group_calendar_events`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_group_calendar_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501

        query_params = []
        if local_var_params.get('date') is not None:  # noqa: E501
            query_params.append(('date', local_var_params['date']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "PaginatedCalendarEventList",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_group_next_calendar_event(self, group_id, **kwargs):  # noqa: E501
        """Get next calendar event  # noqa: E501

        Get the closest future calendar event scheduled for a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_next_calendar_event(group_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarEvent
        """
        kwargs['_return_http_data_only'] = True
        return self.get_group_next_calendar_event_with_http_info(group_id, **kwargs)  # noqa: E501

    def get_group_next_calendar_event_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """Get next calendar event  # noqa: E501

        Get the closest future calendar event scheduled for a group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_group_next_calendar_event_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarEvent, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_next_calendar_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `get_group_next_calendar_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "CalendarEvent",
            401: "Error",
            404: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}/next', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def search_calendar_events(self, search_term, **kwargs):  # noqa: E501
        """Search for calendar events  # noqa: E501

        Get a list of calendar events by search terms  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_calendar_events(search_term, async_req=True)
        >>> result = thread.get()

        :param search_term: Search term for calendar events. (required)
        :type search_term: str
        :param utc_offset: The offset from UTC in hours of the client or authenticated user.
        :type utc_offset: int
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param is_internal_variant: Not quite sure what this actually does (exists on the website but doesn't seem to be used)
        :type is_internal_variant: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedCalendarEventList
        """
        kwargs['_return_http_data_only'] = True
        return self.search_calendar_events_with_http_info(search_term, **kwargs)  # noqa: E501

    def search_calendar_events_with_http_info(self, search_term, **kwargs):  # noqa: E501
        """Search for calendar events  # noqa: E501

        Get a list of calendar events by search terms  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_calendar_events_with_http_info(search_term, async_req=True)
        >>> result = thread.get()

        :param search_term: Search term for calendar events. (required)
        :type search_term: str
        :param utc_offset: The offset from UTC in hours of the client or authenticated user.
        :type utc_offset: int
        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param is_internal_variant: Not quite sure what this actually does (exists on the website but doesn't seem to be used)
        :type is_internal_variant: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedCalendarEventList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'search_term',
            'utc_offset',
            'n',
            'offset',
            'is_internal_variant'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_calendar_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'search_term' is set
        if self.api_client.client_side_validation and local_var_params.get('search_term') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `search_term` when calling `search_calendar_events`")  # noqa: E501

        if self.api_client.client_side_validation and 'utc_offset' in local_var_params and local_var_params['utc_offset'] > 12:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `utc_offset` when calling `search_calendar_events`, must be a value less than or equal to `12`")  # noqa: E501
        if self.api_client.client_side_validation and 'utc_offset' in local_var_params and local_var_params['utc_offset'] < -12:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `utc_offset` when calling `search_calendar_events`, must be a value greater than or equal to `-12`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `search_calendar_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `search_calendar_events`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `search_calendar_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('search_term') is not None:  # noqa: E501
            query_params.append(('searchTerm', local_var_params['search_term']))  # noqa: E501
        if local_var_params.get('utc_offset') is not None:  # noqa: E501
            query_params.append(('utcOffset', local_var_params['utc_offset']))  # noqa: E501
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('is_internal_variant') is not None:  # noqa: E501
            query_params.append(('isInternalVariant', local_var_params['is_internal_variant']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "PaginatedCalendarEventList",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_group_calendar_event(self, group_id, calendar_id, update_calendar_event_request, **kwargs):  # noqa: E501
        """Update a calendar event  # noqa: E501

        Updates an event for a group on the calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_group_calendar_event(group_id, calendar_id, update_calendar_event_request, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param update_calendar_event_request: (required)
        :type update_calendar_event_request: UpdateCalendarEventRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalendarEvent
        """
        kwargs['_return_http_data_only'] = True
        return self.update_group_calendar_event_with_http_info(group_id, calendar_id, update_calendar_event_request, **kwargs)  # noqa: E501

    def update_group_calendar_event_with_http_info(self, group_id, calendar_id, update_calendar_event_request, **kwargs):  # noqa: E501
        """Update a calendar event  # noqa: E501

        Updates an event for a group on the calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_group_calendar_event_with_http_info(group_id, calendar_id, update_calendar_event_request, async_req=True)
        >>> result = thread.get()

        :param group_id: Must be a valid group ID. (required)
        :type group_id: str
        :param calendar_id: Must be a valid calendar ID. (required)
        :type calendar_id: str
        :param update_calendar_event_request: (required)
        :type update_calendar_event_request: UpdateCalendarEventRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CalendarEvent, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id',
            'calendar_id',
            'update_calendar_event_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_group_calendar_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and local_var_params.get('group_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `update_group_calendar_event`")  # noqa: E501
        # verify the required parameter 'calendar_id' is set
        if self.api_client.client_side_validation and local_var_params.get('calendar_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `calendar_id` when calling `update_group_calendar_event`")  # noqa: E501
        # verify the required parameter 'update_calendar_event_request' is set
        if self.api_client.client_side_validation and local_var_params.get('update_calendar_event_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_calendar_event_request` when calling `update_group_calendar_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['groupId'] = local_var_params['group_id']  # noqa: E501
        if 'calendar_id' in local_var_params:
            path_params['calendarId'] = local_var_params['calendar_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_calendar_event_request' in local_var_params:
            body_params = local_var_params['update_calendar_event_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "CalendarEvent",
            401: "Error",
        }

        return self.api_client.call_api(
            '/calendar/{groupId}/{calendarId}/event', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
