# coding: utf-8

"""
    VRChat API Documentation


    The version of the OpenAPI document: 1.20.6
    Contact: vrchatapi.lpv0t@aries.fyi
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vrchatapi.api_client import ApiClient
from vrchatapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class InventoryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def consume_own_inventory_item(self, inventory_item_id, **kwargs):  # noqa: E501
        """Consume Own Inventory Item  # noqa: E501

        Returns the modified InventoryItem object as held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.consume_own_inventory_item(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventoryConsumptionResults
        """
        kwargs['_return_http_data_only'] = True
        return self.consume_own_inventory_item_with_http_info(inventory_item_id, **kwargs)  # noqa: E501

    def consume_own_inventory_item_with_http_info(self, inventory_item_id, **kwargs):  # noqa: E501
        """Consume Own Inventory Item  # noqa: E501

        Returns the modified InventoryItem object as held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.consume_own_inventory_item_with_http_info(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventoryConsumptionResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'inventory_item_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method consume_own_inventory_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inventory_item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_item_id` when calling `consume_own_inventory_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inventory_item_id' in local_var_params:
            path_params['inventoryItemId'] = local_var_params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventoryConsumptionResults",
            400: "Error",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/{inventoryItemId}/consume', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_own_inventory_item(self, inventory_item_id, **kwargs):  # noqa: E501
        """Delete Own Inventory Item  # noqa: E501

        Deletes an InventoryItem from the inventory of the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_own_inventory_item(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessFlag
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_own_inventory_item_with_http_info(inventory_item_id, **kwargs)  # noqa: E501

    def delete_own_inventory_item_with_http_info(self, inventory_item_id, **kwargs):  # noqa: E501
        """Delete Own Inventory Item  # noqa: E501

        Deletes an InventoryItem from the inventory of the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_own_inventory_item_with_http_info(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessFlag, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'inventory_item_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_own_inventory_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inventory_item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_item_id` when calling `delete_own_inventory_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inventory_item_id' in local_var_params:
            path_params['inventoryItemId'] = local_var_params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "SuccessFlag",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/{inventoryItemId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def equip_own_inventory_item(self, inventory_item_id, **kwargs):  # noqa: E501
        """Equip Own Inventory Item  # noqa: E501

        Returns the modified InventoryItem object as held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.equip_own_inventory_item(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param equip_inventory_item_request:
        :type equip_inventory_item_request: EquipInventoryItemRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventoryItem
        """
        kwargs['_return_http_data_only'] = True
        return self.equip_own_inventory_item_with_http_info(inventory_item_id, **kwargs)  # noqa: E501

    def equip_own_inventory_item_with_http_info(self, inventory_item_id, **kwargs):  # noqa: E501
        """Equip Own Inventory Item  # noqa: E501

        Returns the modified InventoryItem object as held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.equip_own_inventory_item_with_http_info(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param equip_inventory_item_request:
        :type equip_inventory_item_request: EquipInventoryItemRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventoryItem, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'inventory_item_id',
            'equip_inventory_item_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method equip_own_inventory_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inventory_item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_item_id` when calling `equip_own_inventory_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inventory_item_id' in local_var_params:
            path_params['inventoryItemId'] = local_var_params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'equip_inventory_item_request' in local_var_params:
            body_params = local_var_params['equip_inventory_item_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventoryItem",
            400: "Error",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/{inventoryItemId}/equip', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_inventory(self, **kwargs):  # noqa: E501
        """Get Inventory  # noqa: E501

        Returns an Inventory object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory(async_req=True)
        >>> result = thread.get()

        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param holder_id: The UserID of the owner of the inventory; defaults to the currently authenticated user.
        :type holder_id: str
        :param equip_slot: Filter for inventory retrieval.
        :type equip_slot: InventoryEquipSlot
        :param order: Sort order for inventory retrieval.
        :type order: str
        :param tags: Filter tags for inventory retrieval (comma-separated).
        :type tags: str
        :param types: Filter for inventory retrieval.
        :type types: InventoryItemType
        :param flags: Filter flags for inventory retrieval (comma-separated).
        :type flags: InventoryFlag
        :param not_types: Filter out types for inventory retrieval (comma-separated).
        :type not_types: InventoryItemType
        :param not_flags: Filter out flags for inventory retrieval (comma-separated).
        :type not_flags: InventoryFlag
        :param archived: Filter archived status for inventory retrieval.
        :type archived: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Inventory
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inventory_with_http_info(**kwargs)  # noqa: E501

    def get_inventory_with_http_info(self, **kwargs):  # noqa: E501
        """Get Inventory  # noqa: E501

        Returns an Inventory object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory_with_http_info(async_req=True)
        >>> result = thread.get()

        :param n: The number of objects to return.
        :type n: int
        :param offset: A zero-based offset from the default object sorting from where search results start.
        :type offset: int
        :param holder_id: The UserID of the owner of the inventory; defaults to the currently authenticated user.
        :type holder_id: str
        :param equip_slot: Filter for inventory retrieval.
        :type equip_slot: InventoryEquipSlot
        :param order: Sort order for inventory retrieval.
        :type order: str
        :param tags: Filter tags for inventory retrieval (comma-separated).
        :type tags: str
        :param types: Filter for inventory retrieval.
        :type types: InventoryItemType
        :param flags: Filter flags for inventory retrieval (comma-separated).
        :type flags: InventoryFlag
        :param not_types: Filter out types for inventory retrieval (comma-separated).
        :type not_types: InventoryItemType
        :param not_flags: Filter out flags for inventory retrieval (comma-separated).
        :type not_flags: InventoryFlag
        :param archived: Filter archived status for inventory retrieval.
        :type archived: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Inventory, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'n',
            'offset',
            'holder_id',
            'equip_slot',
            'order',
            'tags',
            'types',
            'flags',
            'not_types',
            'not_flags',
            'archived'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inventory" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_inventory`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'n' in local_var_params and local_var_params['n'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `n` when calling `get_inventory`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_inventory`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `get_inventory`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('n') is not None:  # noqa: E501
            query_params.append(('n', local_var_params['n']))  # noqa: E501
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('holder_id') is not None:  # noqa: E501
            query_params.append(('holderId', local_var_params['holder_id']))  # noqa: E501
        if local_var_params.get('equip_slot') is not None:  # noqa: E501
            query_params.append(('equipSlot', local_var_params['equip_slot']))  # noqa: E501
        if local_var_params.get('order') is not None:  # noqa: E501
            query_params.append(('order', local_var_params['order']))  # noqa: E501
        if local_var_params.get('tags') is not None:  # noqa: E501
            query_params.append(('tags', local_var_params['tags']))  # noqa: E501
        if local_var_params.get('types') is not None:  # noqa: E501
            query_params.append(('types', local_var_params['types']))  # noqa: E501
        if local_var_params.get('flags') is not None:  # noqa: E501
            query_params.append(('flags', local_var_params['flags']))  # noqa: E501
        if local_var_params.get('not_types') is not None:  # noqa: E501
            query_params.append(('notTypes', local_var_params['not_types']))  # noqa: E501
        if local_var_params.get('not_flags') is not None:  # noqa: E501
            query_params.append(('notFlags', local_var_params['not_flags']))  # noqa: E501
        if local_var_params.get('archived') is not None:  # noqa: E501
            query_params.append(('archived', local_var_params['archived']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "Inventory",
            401: "Error",
            403: "Error",
        }

        return self.api_client.call_api(
            '/inventory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_inventory_collections(self, **kwargs):  # noqa: E501
        """List Inventory Collections  # noqa: E501

        Returns a list of collection names.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory_collections(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inventory_collections_with_http_info(**kwargs)  # noqa: E501

    def get_inventory_collections_with_http_info(self, **kwargs):  # noqa: E501
        """List Inventory Collections  # noqa: E501

        Returns a list of collection names.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory_collections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inventory_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_inventory_drops(self, **kwargs):  # noqa: E501
        """List Inventory Drops  # noqa: E501

        Returns a list of InventoryDrop objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory_drops(async_req=True)
        >>> result = thread.get()

        :param active: Filter for users' listings and inventory bundles.
        :type active: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[InventoryDrop]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inventory_drops_with_http_info(**kwargs)  # noqa: E501

    def get_inventory_drops_with_http_info(self, **kwargs):  # noqa: E501
        """List Inventory Drops  # noqa: E501

        Returns a list of InventoryDrop objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory_drops_with_http_info(async_req=True)
        >>> result = thread.get()

        :param active: Filter for users' listings and inventory bundles.
        :type active: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[InventoryDrop], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'active'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inventory_drops" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('active') is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "list[InventoryDrop]",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/drops', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_inventory_template(self, inventory_template_id, **kwargs):  # noqa: E501
        """Get Inventory Template  # noqa: E501

        Returns an InventoryTemplate object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory_template(inventory_template_id, async_req=True)
        >>> result = thread.get()

        :param inventory_template_id: Must be a valid inventory template ID. (required)
        :type inventory_template_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventoryTemplate
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inventory_template_with_http_info(inventory_template_id, **kwargs)  # noqa: E501

    def get_inventory_template_with_http_info(self, inventory_template_id, **kwargs):  # noqa: E501
        """Get Inventory Template  # noqa: E501

        Returns an InventoryTemplate object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_inventory_template_with_http_info(inventory_template_id, async_req=True)
        >>> result = thread.get()

        :param inventory_template_id: Must be a valid inventory template ID. (required)
        :type inventory_template_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventoryTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'inventory_template_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inventory_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inventory_template_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_template_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_template_id` when calling `get_inventory_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inventory_template_id' in local_var_params:
            path_params['inventoryTemplateId'] = local_var_params['inventory_template_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventoryTemplate",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/template/{inventoryTemplateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_own_inventory_item(self, inventory_item_id, **kwargs):  # noqa: E501
        """Get Own Inventory Item  # noqa: E501

        Returns an InventoryItem object held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_inventory_item(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventoryItem
        """
        kwargs['_return_http_data_only'] = True
        return self.get_own_inventory_item_with_http_info(inventory_item_id, **kwargs)  # noqa: E501

    def get_own_inventory_item_with_http_info(self, inventory_item_id, **kwargs):  # noqa: E501
        """Get Own Inventory Item  # noqa: E501

        Returns an InventoryItem object held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_inventory_item_with_http_info(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventoryItem, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'inventory_item_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_own_inventory_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inventory_item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_item_id` when calling `get_own_inventory_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inventory_item_id' in local_var_params:
            path_params['inventoryItemId'] = local_var_params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventoryItem",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/{inventoryItemId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_user_inventory_item(self, user_id, inventory_item_id, **kwargs):  # noqa: E501
        """Get User Inventory Item  # noqa: E501

        Returns an InventoryItem object held by the given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_inventory_item(user_id, inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param user_id: Must be a valid user ID. (required)
        :type user_id: str
        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventoryItem
        """
        kwargs['_return_http_data_only'] = True
        return self.get_user_inventory_item_with_http_info(user_id, inventory_item_id, **kwargs)  # noqa: E501

    def get_user_inventory_item_with_http_info(self, user_id, inventory_item_id, **kwargs):  # noqa: E501
        """Get User Inventory Item  # noqa: E501

        Returns an InventoryItem object held by the given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_inventory_item_with_http_info(user_id, inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param user_id: Must be a valid user ID. (required)
        :type user_id: str
        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventoryItem, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user_id',
            'inventory_item_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_inventory_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `get_user_inventory_item`")  # noqa: E501
        # verify the required parameter 'inventory_item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_item_id` when calling `get_user_inventory_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'inventory_item_id' in local_var_params:
            path_params['inventoryItemId'] = local_var_params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventoryItem",
            401: "Error",
        }

        return self.api_client.call_api(
            '/user/{userId}/inventory/{inventoryItemId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def share_inventory_item_direct(self, item_id, duration, share_inventory_item_direct_request, **kwargs):  # noqa: E501
        """Share Inventory Item Direct  # noqa: E501

        Share content directly with other users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.share_inventory_item_direct(item_id, duration, share_inventory_item_direct_request, async_req=True)
        >>> result = thread.get()

        :param item_id: Id for inventory item sharing. (required)
        :type item_id: str
        :param duration: The duration before the sharing pedestal despawns. (required)
        :type duration: int
        :param share_inventory_item_direct_request: (required)
        :type share_inventory_item_direct_request: ShareInventoryItemDirectRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OkStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.share_inventory_item_direct_with_http_info(item_id, duration, share_inventory_item_direct_request, **kwargs)  # noqa: E501

    def share_inventory_item_direct_with_http_info(self, item_id, duration, share_inventory_item_direct_request, **kwargs):  # noqa: E501
        """Share Inventory Item Direct  # noqa: E501

        Share content directly with other users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.share_inventory_item_direct_with_http_info(item_id, duration, share_inventory_item_direct_request, async_req=True)
        >>> result = thread.get()

        :param item_id: Id for inventory item sharing. (required)
        :type item_id: str
        :param duration: The duration before the sharing pedestal despawns. (required)
        :type duration: int
        :param share_inventory_item_direct_request: (required)
        :type share_inventory_item_direct_request: ShareInventoryItemDirectRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OkStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'item_id',
            'duration',
            'share_inventory_item_direct_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method share_inventory_item_direct" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `item_id` when calling `share_inventory_item_direct`")  # noqa: E501
        # verify the required parameter 'duration' is set
        if self.api_client.client_side_validation and local_var_params.get('duration') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `duration` when calling `share_inventory_item_direct`")  # noqa: E501
        # verify the required parameter 'share_inventory_item_direct_request' is set
        if self.api_client.client_side_validation and local_var_params.get('share_inventory_item_direct_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `share_inventory_item_direct_request` when calling `share_inventory_item_direct`")  # noqa: E501

        if self.api_client.client_side_validation and 'duration' in local_var_params and local_var_params['duration'] > 86400:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `duration` when calling `share_inventory_item_direct`, must be a value less than or equal to `86400`")  # noqa: E501
        if self.api_client.client_side_validation and 'duration' in local_var_params and local_var_params['duration'] < 30:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `duration` when calling `share_inventory_item_direct`, must be a value greater than or equal to `30`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('item_id') is not None:  # noqa: E501
            query_params.append(('itemId', local_var_params['item_id']))  # noqa: E501
        if local_var_params.get('duration') is not None:  # noqa: E501
            query_params.append(('duration', local_var_params['duration']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'share_inventory_item_direct_request' in local_var_params:
            body_params = local_var_params['share_inventory_item_direct_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "OkStatus",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/cloning/direct', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def share_inventory_item_pedestal(self, item_id, duration, **kwargs):  # noqa: E501
        """Share Inventory Item by Pedestal  # noqa: E501

        Returns an InventorySpawn object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.share_inventory_item_pedestal(item_id, duration, async_req=True)
        >>> result = thread.get()

        :param item_id: Id for inventory item sharing. (required)
        :type item_id: str
        :param duration: The duration before the sharing pedestal despawns. (required)
        :type duration: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventorySpawn
        """
        kwargs['_return_http_data_only'] = True
        return self.share_inventory_item_pedestal_with_http_info(item_id, duration, **kwargs)  # noqa: E501

    def share_inventory_item_pedestal_with_http_info(self, item_id, duration, **kwargs):  # noqa: E501
        """Share Inventory Item by Pedestal  # noqa: E501

        Returns an InventorySpawn object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.share_inventory_item_pedestal_with_http_info(item_id, duration, async_req=True)
        >>> result = thread.get()

        :param item_id: Id for inventory item sharing. (required)
        :type item_id: str
        :param duration: The duration before the sharing pedestal despawns. (required)
        :type duration: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventorySpawn, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'item_id',
            'duration'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method share_inventory_item_pedestal" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `item_id` when calling `share_inventory_item_pedestal`")  # noqa: E501
        # verify the required parameter 'duration' is set
        if self.api_client.client_side_validation and local_var_params.get('duration') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `duration` when calling `share_inventory_item_pedestal`")  # noqa: E501

        if self.api_client.client_side_validation and 'duration' in local_var_params and local_var_params['duration'] > 86400:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `duration` when calling `share_inventory_item_pedestal`, must be a value less than or equal to `86400`")  # noqa: E501
        if self.api_client.client_side_validation and 'duration' in local_var_params and local_var_params['duration'] < 30:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `duration` when calling `share_inventory_item_pedestal`, must be a value greater than or equal to `30`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('item_id') is not None:  # noqa: E501
            query_params.append(('itemId', local_var_params['item_id']))  # noqa: E501
        if local_var_params.get('duration') is not None:  # noqa: E501
            query_params.append(('duration', local_var_params['duration']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventorySpawn",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/cloning/pedestal', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def spawn_inventory_item(self, id, **kwargs):  # noqa: E501
        """Spawn Inventory Item  # noqa: E501

        Returns an InventorySpawn object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.spawn_inventory_item(id, async_req=True)
        >>> result = thread.get()

        :param id: Id for inventory item spawning. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventorySpawn
        """
        kwargs['_return_http_data_only'] = True
        return self.spawn_inventory_item_with_http_info(id, **kwargs)  # noqa: E501

    def spawn_inventory_item_with_http_info(self, id, **kwargs):  # noqa: E501
        """Spawn Inventory Item  # noqa: E501

        Returns an InventorySpawn object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.spawn_inventory_item_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: Id for inventory item spawning. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventorySpawn, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method spawn_inventory_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and local_var_params.get('id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `spawn_inventory_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('id') is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventorySpawn",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/spawn', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def unequip_own_inventory_slot(self, inventory_item_id, **kwargs):  # noqa: E501
        """Unequip Own Inventory Slot  # noqa: E501

        Unequips the InventoryItem in the given slot of the inventory of the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unequip_own_inventory_slot(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Selector for inventory slot management. (required)
        :type inventory_item_id: InventoryEquipSlot
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.unequip_own_inventory_slot_with_http_info(inventory_item_id, **kwargs)  # noqa: E501

    def unequip_own_inventory_slot_with_http_info(self, inventory_item_id, **kwargs):  # noqa: E501
        """Unequip Own Inventory Slot  # noqa: E501

        Unequips the InventoryItem in the given slot of the inventory of the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unequip_own_inventory_slot_with_http_info(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Selector for inventory slot management. (required)
        :type inventory_item_id: InventoryEquipSlot
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'inventory_item_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unequip_own_inventory_slot" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inventory_item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_item_id` when calling `unequip_own_inventory_slot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inventory_item_id' in local_var_params:
            path_params['inventoryItemId'] = local_var_params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "str",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/{inventoryItemId}/equip', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_own_inventory_item(self, inventory_item_id, **kwargs):  # noqa: E501
        """Update Own Inventory Item  # noqa: E501

        Returns the modified InventoryItem object as held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_own_inventory_item(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param update_inventory_item_request:
        :type update_inventory_item_request: UpdateInventoryItemRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InventoryItem
        """
        kwargs['_return_http_data_only'] = True
        return self.update_own_inventory_item_with_http_info(inventory_item_id, **kwargs)  # noqa: E501

    def update_own_inventory_item_with_http_info(self, inventory_item_id, **kwargs):  # noqa: E501
        """Update Own Inventory Item  # noqa: E501

        Returns the modified InventoryItem object as held by the currently logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_own_inventory_item_with_http_info(inventory_item_id, async_req=True)
        >>> result = thread.get()

        :param inventory_item_id: Must be a valid inventory item ID. (required)
        :type inventory_item_id: str
        :param update_inventory_item_request:
        :type update_inventory_item_request: UpdateInventoryItemRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InventoryItem, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'inventory_item_id',
            'update_inventory_item_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_own_inventory_item" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'inventory_item_id' is set
        if self.api_client.client_side_validation and local_var_params.get('inventory_item_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_item_id` when calling `update_own_inventory_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'inventory_item_id' in local_var_params:
            path_params['inventoryItemId'] = local_var_params['inventory_item_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_inventory_item_request' in local_var_params:
            body_params = local_var_params['update_inventory_item_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['authCookie']  # noqa: E501

        response_types_map = {
            200: "InventoryItem",
            401: "Error",
        }

        return self.api_client.call_api(
            '/inventory/{inventoryItemId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
