"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticFileSystemAddOn = exports.BucketSyncAddOn = exports.InstanceFirewallAddOn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const commands_1 = require("./commands");
/**
 * An add-on that configures an on-instance firewall.
 */
class InstanceFirewallAddOn {
    /**
     * An add-on that configures an on-instance firewall.
     *
     * @param rules - The instance firewall rules
     * @param props - Optional configuration properties
     */
    constructor(rules, props) {
        this.rules = rules;
        this.props = props;
    }
    configure(starter) {
        starter.addScript(this.props?.priority ?? 0, aws_cdk_lib_1.Lazy.string({ produce: () => this.rules.buildCommands().join("\n") }));
    }
}
exports.InstanceFirewallAddOn = InstanceFirewallAddOn;
_a = JSII_RTTI_SYMBOL_1;
InstanceFirewallAddOn[_a] = { fqn: "shady-island.configuration.InstanceFirewallAddOn", version: "0.1.46" };
/**
 * An add-on that synchronizes files from S3 to directories on the instance.
 *
 * This add-on also grants read access to the bucket.
 */
class BucketSyncAddOn {
    /**
     * An add-on that synchronizes files from S3 to directories on the instance.
     *
     * This add-on also grants read access to the bucket.
     *
     * @param bucket - The S3 bucket from which files can be downloaded
     * @param destinations - An object where keys are S3 object key prefixes and values are filesystem directories
     * @param props - Optional configuration properties
     */
    constructor(bucket, destinations, props) {
        this.bucket = bucket;
        this.destinations = destinations;
        this.props = props;
    }
    configure(starter) {
        this.bucket.grantRead(starter);
        starter.addScript(this.props?.priority ?? 10, ...commands_1.ShellCommands.syncFromBucket(this.bucket, this.destinations));
    }
}
exports.BucketSyncAddOn = BucketSyncAddOn;
_b = JSII_RTTI_SYMBOL_1;
BucketSyncAddOn[_b] = { fqn: "shady-island.configuration.BucketSyncAddOn", version: "0.1.46" };
/**
 * An add-on that configures a mount point for an EFS filesystem.
 *
 * This add-on will produce a startup script to:
 * - Create the mount directory
 * - Mount the NFS filesystem to the mount point
 * - Optionally change the mode or ownership of the mount point
 *
 * This visitor also configures the Security Groups on both ends.
 */
class ElasticFileSystemAddOn {
    /**
     * An add-on that configures a mount point for an EFS filesystem.
     *
     * This add-on will produce a startup script to:
     * - Create the mount directory
     * - Mount the NFS filesystem to the mount point
     * - Optionally change the mode or ownership of the mount point
     *
     * This visitor also configures the Security Groups on both ends.
     *
     * @param filesystem - The elastic filesystem to mount
     * @param destination - The directory to use as the mount point
     * @param props - Optional configuration properties
     */
    constructor(filesystem, destination, props) {
        this.filesystem = filesystem;
        this.destination = destination;
        this.props = props;
    }
    configure(starter) {
        const description = "Allow NFS traffic from EC2 to EFS";
        // The CDK source code definitely sets the default port to 2049.
        const port = this.filesystem.connections.defaultPort;
        // To prevent circular references in case the stacks are different.
        for (const fsg of this.filesystem.connections.securityGroups) {
            for (const isg of starter.connections.securityGroups) {
                fsg.addIngressRule(isg, port, description, true);
                isg.addEgressRule(fsg, port, description);
            }
        }
        const postMount = [];
        const { chown, chgrp, chmod, priority = 10 } = this.props || {};
        if (chmod) {
            postMount.push(`chmod ${chmod} "${this.destination}"`);
        }
        if (chown || chgrp) {
            postMount.push(...commands_1.ShellCommands.changeOwnership(this.destination, chown, chgrp));
        }
        starter.addScript(priority, ...commands_1.ShellCommands.mountElasticFileSystem(this.filesystem, this.destination), ...postMount);
    }
}
exports.ElasticFileSystemAddOn = ElasticFileSystemAddOn;
_c = JSII_RTTI_SYMBOL_1;
ElasticFileSystemAddOn[_c] = { fqn: "shady-island.configuration.ElasticFileSystemAddOn", version: "0.1.46" };
//# sourceMappingURL=data:application/json;base64,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