"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _IptablesRules_inboundRules, _IptablesRules_outboundRules, _IptablesRules_hasIpv4, _IptablesRules_hasIpv6, _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceFirewall = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const address_1 = require("../networking/address");
const util_1 = require("../util");
class IptablesRules {
    constructor() {
        _IptablesRules_inboundRules.set(this, void 0);
        _IptablesRules_outboundRules.set(this, void 0);
        _IptablesRules_hasIpv4.set(this, void 0);
        _IptablesRules_hasIpv6.set(this, void 0);
        __classPrivateFieldSet(this, _IptablesRules_inboundRules, new Map(), "f");
        __classPrivateFieldSet(this, _IptablesRules_outboundRules, new Map(), "f");
        __classPrivateFieldSet(this, _IptablesRules_hasIpv4, false, "f");
        __classPrivateFieldSet(this, _IptablesRules_hasIpv6, false, "f");
    }
    inbound(port, address) {
        const portJson = port.toRuleJson();
        this.validateProtocol(portJson.ipProtocol);
        if (address.isIpv4()) {
            __classPrivateFieldSet(this, _IptablesRules_hasIpv4, true, "f");
        }
        if (address.isIpv6()) {
            __classPrivateFieldSet(this, _IptablesRules_hasIpv6, true, "f");
        }
        const ruleKey = `${address}|${portJson.ipProtocol}`;
        if (!__classPrivateFieldGet(this, _IptablesRules_inboundRules, "f").has(ruleKey)) {
            __classPrivateFieldGet(this, _IptablesRules_inboundRules, "f").set(ruleKey, {
                address,
                protocol: portJson.ipProtocol,
                ports: new Map(),
            });
        }
        const rule = __classPrivateFieldGet(this, _IptablesRules_inboundRules, "f").get(ruleKey);
        const portLabel = String(port);
        if (!rule.ports.has(portLabel)) {
            rule.ports.set(portLabel, portJson);
        }
        return this;
    }
    inboundFromAnyIpv4(port) {
        return this.inbound(port, address_1.Address.anyIpv4());
    }
    inboundFromAnyIpv6(port) {
        return this.inbound(port, address_1.Address.anyIpv6());
    }
    outbound(port, address) {
        const portJson = port.toRuleJson();
        this.validateProtocol(portJson.ipProtocol);
        if (address.isIpv4()) {
            __classPrivateFieldSet(this, _IptablesRules_hasIpv4, true, "f");
        }
        if (address.isIpv6()) {
            __classPrivateFieldSet(this, _IptablesRules_hasIpv6, true, "f");
        }
        const ruleKey = `${address}|${portJson.ipProtocol}`;
        if (!__classPrivateFieldGet(this, _IptablesRules_outboundRules, "f").has(ruleKey)) {
            __classPrivateFieldGet(this, _IptablesRules_outboundRules, "f").set(ruleKey, {
                address,
                protocol: portJson.ipProtocol,
                ports: new Map(),
            });
        }
        const rule = __classPrivateFieldGet(this, _IptablesRules_outboundRules, "f").get(ruleKey);
        const portLabel = String(port);
        if (!rule.ports.has(portLabel)) {
            rule.ports.set(portLabel, portJson);
        }
        return this;
    }
    outboundToAnyIpv4(port) {
        return this.outbound(port, address_1.Address.anyIpv4());
    }
    outboundToAnyIpv6(port) {
        return this.outbound(port, address_1.Address.anyIpv6());
    }
    validateProtocol(protocol) {
        if (![aws_ec2_1.Protocol.TCP, aws_ec2_1.Protocol.UDP, aws_ec2_1.Protocol.ICMP, aws_ec2_1.Protocol.ICMPV6].includes(protocol)) {
            throw new Error(`iptables does not support rules for the protocol: ${protocol}`);
        }
    }
    getIcmpCommand(chain, rule) {
        const { address, protocol } = rule;
        const commandParts = [
            address.isIpv6() ? "ip6tables" : "iptables",
            "-A",
            chain,
            "-p",
            protocol === aws_ec2_1.Protocol.ICMPV6 ? "ipv6-icmp" : "icmp",
        ];
        if (!address.isAny()) {
            commandParts.push(chain === "INPUT" ? "-s" : "-d", String(address));
        }
        commandParts.push("-j ACCEPT");
        return commandParts.join(" ");
    }
    getTcpUdpCommands(chain, rule) {
        const { ports, address, protocol } = rule;
        const portGroups = (0, util_1.collate)(Array.from(ports.values()), 15);
        const commands = [];
        for (const groupPorts of portGroups) {
            const commandParts = [
                address.isIpv6() ? "ip6tables" : "iptables",
                "-A",
                chain,
                "-p",
                String(protocol),
            ];
            if (!address.isAny()) {
                commandParts.push(chain === "INPUT" ? "-s" : "-d", String(address));
            }
            const joinedPorts = groupPorts
                .map((p) => {
                if (p.toPort !== -1 && p.toPort !== p.fromPort) {
                    return `${p.fromPort}:${p.toPort}`;
                }
                return String(p.fromPort);
            })
                .join(",");
            commandParts.push("--match", "multiport", "--dports", joinedPorts, "-j", "ACCEPT");
            commands.push(commandParts.join(" "));
        }
        return commands;
    }
    /**
     * Produces the `iptables` commands ready for a UserData script.
     *
     * @returns An array of iptables commands
     */
    buildCommands() {
        const commands = [];
        if (__classPrivateFieldGet(this, _IptablesRules_hasIpv4, "f")) {
            commands.push("iptables -A INPUT -i lo -j ACCEPT", "iptables -A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT");
        }
        if (__classPrivateFieldGet(this, _IptablesRules_hasIpv6, "f")) {
            commands.push("ip6tables -A INPUT -i lo -j ACCEPT", "ip6tables -A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT");
        }
        for (const rule of __classPrivateFieldGet(this, _IptablesRules_inboundRules, "f").values()) {
            const { protocol } = rule;
            if (protocol === aws_ec2_1.Protocol.TCP || protocol === aws_ec2_1.Protocol.UDP) {
                commands.push(...this.getTcpUdpCommands("INPUT", rule));
            }
            else if (protocol === aws_ec2_1.Protocol.ICMP || protocol === aws_ec2_1.Protocol.ICMPV6) {
                commands.push(this.getIcmpCommand("INPUT", rule));
            }
        }
        if (__classPrivateFieldGet(this, _IptablesRules_hasIpv4, "f")) {
            commands.push("iptables -A INPUT -j REJECT", "iptables -A OUTPUT -o lo -p all -j ACCEPT", "iptables -A OUTPUT -m state --state RELATED,ESTABLISHED -j ACCEPT");
        }
        if (__classPrivateFieldGet(this, _IptablesRules_hasIpv6, "f")) {
            commands.push("ip6tables -A INPUT -j REJECT", "ip6tables -A OUTPUT -o lo -p all -j ACCEPT", "ip6tables -A OUTPUT -m state --state RELATED,ESTABLISHED -j ACCEPT");
        }
        for (const rule of __classPrivateFieldGet(this, _IptablesRules_outboundRules, "f").values()) {
            const { protocol } = rule;
            if (protocol === aws_ec2_1.Protocol.TCP || protocol === aws_ec2_1.Protocol.UDP) {
                commands.push(...this.getTcpUdpCommands("OUTPUT", rule));
            }
            else if (protocol === aws_ec2_1.Protocol.ICMP || protocol === aws_ec2_1.Protocol.ICMPV6) {
                commands.push(this.getIcmpCommand("OUTPUT", rule));
            }
        }
        if (__classPrivateFieldGet(this, _IptablesRules_hasIpv4, "f")) {
            commands.push("iptables -A OUTPUT -j REJECT", "iptables-save > /etc/iptables/rules.v4");
        }
        if (__classPrivateFieldGet(this, _IptablesRules_hasIpv6, "f")) {
            commands.push("ip6tables -A OUTPUT -j REJECT", "ip6tables-save > /etc/iptables/rules.v6");
        }
        return commands;
    }
}
_IptablesRules_inboundRules = new WeakMap(), _IptablesRules_outboundRules = new WeakMap(), _IptablesRules_hasIpv4 = new WeakMap(), _IptablesRules_hasIpv6 = new WeakMap();
/**
 * Produces the appropriate commands to configure an on-instance firewall.
 */
class InstanceFirewall {
    /**
     * Define an instance firewall using iptables/ip6tables.
     *
     * @returns An iptables-based on-instance firewall
     */
    static iptables() {
        return new IptablesRules();
    }
}
exports.InstanceFirewall = InstanceFirewall;
_a = JSII_RTTI_SYMBOL_1;
InstanceFirewall[_a] = { fqn: "shady-island.configuration.InstanceFirewall", version: "0.1.46" };
//# sourceMappingURL=data:application/json;base64,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