"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseJsonArrayFromEnv = parseJsonArrayFromEnv;
exports.fetchSecret = fetchSecret;
exports.fetchAllSecrets = fetchAllSecrets;
exports.readRemote = readRemote;
const https = require("https");
// eslint-disable-next-line import/no-extraneous-dependencies
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
function parseJsonArrayFromEnv(variableName) {
    if (!Object.keys(process.env).includes(variableName)) {
        return [];
    }
    const hydrated = JSON.parse(process.env[variableName]);
    if (!Array.isArray(hydrated)) {
        throw new Error(`The ${variableName} environment variable must be a JSON array`);
    }
    return hydrated;
}
async function fetchSecret(arn, client) {
    console.log(`Requesting decoded secret from Secrets Manager: ${arn}`);
    const output = await client.send(new client_secrets_manager_1.GetSecretValueCommand({ SecretId: arn }));
    return output.SecretString ? JSON.parse(output.SecretString) : {};
}
async function fetchAllSecrets(arns, client) {
    if (arns.length === 0) {
        return [];
    }
    return Promise.all(arns.map((a) => fetchSecret(a, client)));
}
/**
 * Reads an HTTPS resource into a string.
 *
 * We need this function since newer RDS CA certificates aren't in Lambda.
 *
 * @see https://github.com/aws/aws-lambda-base-images/issues/123
 */
function readRemote(url, options) {
    return new Promise((resolve, reject) => {
        https
            .get(url, options || {}, (res) => {
            const data = [];
            res.on("data", (d) => data.push(d));
            res.on("end", () => resolve(Buffer.concat(data)));
        })
            .on("error", (e) => reject(e));
    });
}
//# sourceMappingURL=data:application/json;base64,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