"""
TODO: look into how to use empty number when value is nan.
because nan is not empty and so it's difficult to manage.
write some tests for the instructions appliers.
introduce a number of instructions appliers and a tool for mobile testing
of instructions and generated embeddings (API).
develop more instructions.
"""

from . import instructions_map
from .interaction import InteractionEncoding

ERR_NUMBER = 0.00011
EMPTY_NUMBER = 0.00012

class ParseAndExecute(object):

    INTERACTIONS_KEY = "interactions"
    LABELS_KEY = "labels"

    def __init__(self, instructions):
        # order the instructions on higher_order.
        self.instructions = self._group_and_sort_instructions(instructions)
        self.labels = self._retrieve_labels(instructions)

    def _group_and_sort_instructions(self, instructions):
        if len(instructions) == 0:
            return {}
        
        sorted_dictionary = {}
        instructions = instructions[0]
        for instruction_key in instructions.keys():
            if instruction_key != self.LABELS_KEY:
                sorted_dictionary[instruction_key] = sorted(instructions.get(instruction_key), key=lambda k: k['higher_order'])
        return sorted_dictionary

    def _retrieve_labels(self, instructions):
        if len(instructions) == 0:
            return {}

        instructions = instructions[0]
        return instructions.get(self.LABELS_KEY, {})

    def feed(self, values_dict):
        self.values = values_dict

    def _process_instruction(self, value, instruct):
        klass = instructions_map.get(instruct['instruct'])
        if not klass:
            return ERR_NUMBER
        # if instruction involves multiple fields.
        other_value = None

        instruct_params = instruct.get('params', {}).copy()
        # if params point to another field, get that field value too.
        if "field" in instruct_params:
            other_value = self.values.get(instruct_params['field'])
            del instruct_params['field']

        obj = klass(**instruct_params)

        try:
            if other_value:
                # in case it involves two fields.
                res = obj.apply(value, other_value)
            else:
                res = obj.apply(value)
        except Exception as e:
            return ERR_NUMBER

        if res == None:
            return ERR_NUMBER
        elif isinstance(res, list):
            return res
        elif isinstance(obj, InteractionEncoding):
            return res
        else:
            return float(res)
    
    def _process_labels(self, object_name, object_values):
        labels = []
        
        labels_provided = self.labels.get(object_name)

        if labels_provided == None or len(labels_provided) == 0:
            return labels

        labels_provided = list(set(labels_provided))
        labels_from_api = object_values.get(self.LABELS_KEY, []) 

        if len(labels_from_api) == 0:
            return labels
        
        for label in labels_provided:
            if label in labels_from_api:
                labels.append(label)

        return labels

    def parse(self, object_name):
        embedding = []
        labels = []

        if self.instructions.get(object_name) == None:
            return {
                "embedding": embedding,
                "labels": labels
            }

        if object_name == self.INTERACTIONS_KEY:
            return self._process_interactions()
        else:
            if self.labels.get(object_name) is not None:
                labels = self._process_labels(object_name, self.values)

            for instruct in self.instructions.get(object_name.lower()):
                chains = instruct.get('_chains', None)
                value = self.values.get(instruct['f_id'].lower())

                if not value and (value != 0 and instruct['instruct'] == 'Boolean'):
                    embedding.append(ERR_NUMBER)
                    continue

                if chains:
                    for chain in chains:
                        chain_list = sorted(chain, key=lambda k: k['order'])
                        for item in chain_list:
                            value = self._process_instruction(value, item)
                        res = value # last response in the chain is the return value.
                        embedding.append(res)
                else:
                    res = self._process_instruction(value, instruct)
                    embedding.append(res)

        return {
            "embedding": embedding,
            "labels": labels
        }

    def _process_interactions(self):
        embeddings_per_object = {}
        for object_key in self.values.keys():
            embeddings_per_object[object_key] = { }
            instruction = next((item for item in self.instructions[self.INTERACTIONS_KEY] if item["_with_object"] == object_key), None)

            if instruction is None:
                continue

            for action_object in self.values[object_key]:
                result = self._process_instruction(self.values[object_key][action_object], instruction)
                embeddings_per_object[object_key][action_object] = result

        return embeddings_per_object

