# Code generated by builder. DO NOT EDIT.
"""
Kelvin API Client.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import Any, Optional, Union, cast

from typing_extensions import Literal

from kelvin.api.base.api_service_model import AsyncApiServiceModel
from kelvin.api.base.data_model import KList
from kelvin.api.base.http_client.base_client import AsyncBaseClient

from ..model import requests, response, responses


class AssetInsights(AsyncApiServiceModel):
    @classmethod
    async def get_asset_insights(
        cls,
        page_size: Optional[int] = 10000,
        page: Optional[int] = None,
        data: Optional[Union[requests.AssetInsightsGet, Mapping[str, object]]] = None,
        fetch: bool = True,
        _dry_run: bool = False,
        _client: Optional[AsyncBaseClient] = None,
        **kwargs: object,
    ) -> Union[KList[responses.AssetInsightsItem], responses.AssetInsightsGetPaginated]:
        """
        Advanced Asset Insights collates Asset data and optional custom defined fields and returns a structured array of Asset related objects. Ideal for generating UI lists, it accommodates a range of search, filter, and optional data on Data Streams, Parameters, Control Changes, Recommendations, etc. related to the Asset.

        **Permission Required:** `kelvin.permission.asset_insights.read`.

        ``getAssetInsights``: ``POST`` ``/api/v4/asset-insights/get``

        Parameters
        ----------
        page_size : :obj:`int`
            Number of Asset objects to be returned.
        page : :obj:`int`
            Return the list of Asset objects on requested page using the
            `page_size` as a page calculation reference.
        data: requests.AssetInsightsGet, optional
        **kwargs:
            Extra parameters for requests.AssetInsightsGet
              - get_asset_insights: dict

        """

        result = await cls._make_request(
            client=_client,
            method="post",
            path="/api/v4/asset-insights/get",
            values={},
            params={"page_size": page_size, "page": page},
            files={},
            headers={},
            data=data,
            body_type=requests.AssetInsightsGet,
            array_body=False,
            result_types={
                "200": responses.AssetInsightsGetPaginated,
                "400": response.Error,
                "401": response.Error,
                "424": response.Error,
                "500": response.Error,
            },
            stream=False,
            dry_run=_dry_run,
            **kwargs,
        )

        return (
            cast(
                Union[KList[responses.AssetInsightsItem], responses.AssetInsightsGetPaginated],
                await cls.fetch(_client, "/api/v4/asset-insights/get", result, "POST", data),
            )
            if fetch and not _dry_run
            else result
        )
