# Mass table for atom types in CGENFF rtf ver 36  1

CGENFF_MASS_TABLE = {
    'HGA1': (1.008, 'alphatic proton, ch', 'H'),
    'HGA2': (1.008, 'alphatic proton, ch2', 'H'),
    'HGA3': (1.008, 'alphatic proton, ch3', 'H'),
    'HGA4': (1.008, 'alkene proton; rhc=', 'H'),
    'HGA5': (1.008, 'alkene proton; h2c=cr', 'H'),
    'HGA6': (1.008, 'aliphatic h on fluorinated c, monofluoro', 'H'),
    'HGA7': (1.008, 'aliphatic h on fluorinated c, difluoro', 'H'),
    'HGAAM0': (1.008, 'aliphatic h, neutral trimethylamine (#)', 'H'),
    'HGAAM1': (1.008, 'aliphatic h, neutral dimethylamine (#)', 'H'),
    'HGAAM2': (1.008, 'aliphatic h, neutral methylamine (#)', 'H'),
    'HGP1': (1.008, 'polar h', 'H'),
    'HGP2': (1.008, 'polar h, +ve charge', 'H'),
    'HGP3': (1.008, 'polar h, thiol', 'H'),
    'HGP4': (1.008, 'polar h, neutral conjugated -nh2 group (na bases)', 'H'),
    'HGP5': (1.008, 'polar h on quarternary ammonium salt (choline)', 'H'),
    'HGPAM1': (1.008,
    'polar h, neutral dimethylamine (#), terminal alkyne h',
    'H'),
    'HGPAM2': (1.008, 'polar h, neutral methylamine (#)', 'H'),
    'HGPAM3': (1.008, 'polar h, neutral ammonia (#)', 'H'),
    'HGR51': (1.008,
    'nonpolar h, neutral 5-mem planar ring c, lj based on benzene',
    'H'),
    'HGR52': (1.008,
    'aldehyde h, formamide h (rcoh); nonpolar h, neutral 5-mem planar ring c adjacent to heteroatom or + charge',
    'H'),
    'HGR53': (1.008, 'nonpolar h, +ve charge his he1(+1)', 'H'),
    'HGR61': (1.008, 'aromatic h', 'H'),
    'HGR62': (1.008,
    'nonpolar h, neutral 6-mem planar ring c adjacent to heteroatom',
    'H'),
    'HGR63': (1.008, 'nonpolar h, nad+ nicotineamide all ring ch hydrogens', 'H'),
    'HGR71': (1.008,
    'nonpolar h, neutral 7-mem arom ring, azul, azulene, kevo',
    'H'),
    'CG1T1': (12.011, 'internal alkyne r-c#c', 'C'),
    'CG1T2': (12.011, 'terminal alkyne h-c#c', 'C'),
    'CG1N1': (12.011, 'c for cyano group', 'C'),
    'CG2D1': (12.011, 'alkene; rhc= ; imine c', 'C'),
    'CG2D2': (12.011, 'alkene; h2c=', 'C'),
    'CG2D1O': (12.011,
    'double bond carbon adjacent to heteroatom. in conjugated systems, the atom to which it is double bonded must be cg2dc1.',
    'C'),
    'CG2D2O': (12.011,
    'double bond carbon adjacent to heteroatom. in conjugated systems, the atom to which it is double bonded must be cg2dc2.',
    'C'),
    'CG2DC1': (12.011, 'conjugated alkenes, r2c=cr2', 'C'),
    'CG2DC2': (12.011, 'conjugated alkenes, r2c=cr2', 'C'),
    'CG2DC3': (12.011, 'conjugated alkenes, h2c=', 'C'),
    'CG2N1': (12.011, 'conjugated c in guanidine/guanidinium', 'C'),
    'CG2N2': (12.011, 'conjugated c in amidinium cation', 'C'),
    'CG2O1': (12.011, 'carbonyl c: amides', 'C'),
    'CG2O2': (12.011, 'carbonyl c: esters, [neutral] carboxylic acids', 'C'),
    'CG2O3': (12.011, 'carbonyl c: [negative] carboxylates', 'C'),
    'CG2O4': (12.011, 'carbonyl c: aldehydes', 'C'),
    'CG2O5': (12.011, 'carbonyl c: ketones', 'C'),
    'CG2O6': (12.011, 'carbonyl c: urea, carbonate', 'C'),
    'CG2O7': (12.011, 'co2 carbon', 'C'),
    'CG2R51': (12.011, '5-mem ring, his cg, cd2(0), trp', 'C'),
    'CG2R52': (12.011, '5-mem ring, double bound to n, pyrz, pyrazole', 'C'),
    'CG2R53': (12.011,
    '5-mem ring, double bound to n and adjacent to another heteroatom, purine c8, his ce1 (0,+1), 2pdo, kevo',
    'C'),
    'CG2R57': (12.011, '5-mem ring, bipyrroles', 'C'),
    'CG25C1': (12.011,
    'same as cg2dc1 but in 5-membered ring with exocyclic double bond',
    'C'),
    'CG25C2': (12.011,
    'same as cg2dc2 but in 5-membered ring with exocyclic double bond',
    'C'),
    'CG251O': (12.011,
    'same as cg2d1o but in 5-membered ring with exocyclic double bond',
    'C'),
    'CG252O': (12.011,
    'same as cg2d2o but in 5-membered ring with exocyclic double bond',
    'C'),
    'CG2R61': (12.011, '6-mem aromatic c', 'C'),
    'CG2R62': (12.011,
    '6-mem aromatic c for protonated pyridine (nic) and rings containing carbonyls (see cg2r63) (na)',
    'C'),
    'CG2R63': (12.011,
    '6-mem aromatic amide carbon (na) (and other 6-mem aromatic carbonyls?)',
    'C'),
    'CG2R64': (12.011,
    '6-mem aromatic amidine and guanidine carbon (between 2 or 3 ns and double-bound to one of them), na, pyrm',
    'C'),
    'CG2R66': (12.011, '6-mem aromatic carbon bound to f', 'C'),
    'CG2R67': (12.011, '6-mem aromatic carbon of biphenyl', 'C'),
    'CG2RC0': (12.011, '6/5-mem ring bridging c, guanine c4,c5, trp', 'C'),
    'CG2R71': (12.011, '7-mem ring arom c, azul, azulene, kevo', 'C'),
    'CG2RC7': (12.011,
    'sp2 ring connection with single bond(!), azul, azulene, kevo',
    'C'),
    'CG301': (12.011, 'aliphatic c, no hydrogens, neopentane', 'C'),
    'CG302': (12.011, 'aliphatic c, no hydrogens, trifluoromethyl', 'C'),
    'CG311': (12.011, 'aliphatic c with 1 h, ch', 'C'),
    'CG312': (12.011, 'aliphatic c with 1 h, difluoromethyl', 'C'),
    'CG314': (12.011,
    'aliphatic c with 1 h, adjacent to positive n (prot nter) (+)',
    'C'),
    'CG321': (12.011, 'aliphatic c for ch2', 'C'),
    'CG322': (12.011, 'aliphatic c for ch2, monofluoromethyl', 'C'),
    'CG323': (12.011, 'aliphatic c for ch2, thiolate carbon', 'C'),
    'CG324': (12.011,
    'aliphatic c for ch2, adjacent to positive n (piperidine) (+)',
    'C'),
    'CG331': (12.011, 'aliphatic c for methyl group (-ch3)', 'C'),
    'CG334': (12.011,
    'aliphatic c for methyl group (-ch3), adjacent to positive n (prot nter) (+)',
    'C'),
    'CG3AM0': (12.011,
    'aliphatic c for ch3, neutral trimethylamine methyl carbon (#)',
    'C'),
    'CG3AM1': (12.011,
    'aliphatic c for ch3, neutral dimethylamine methyl carbon (#)',
    'C'),
    'CG3AM2': (12.011,
    'aliphatic c for ch3, neutral methylamine methyl carbon (#)',
    'C'),
    'CG3C31': (12.011, 'cyclopropyl carbon', 'C'),
    'CG3C41': (12.011, 'cyclobutyl carbon', 'C'),
    'CG3C50': (12.011,
    '5-mem ring aliphatic quarternary c (cholesterol, bile acids)',
    'C'),
    'CG3C51': (12.011, '5-mem ring aliphatic ch  (proline ca, furanoses)', 'C'),
    'CG3C52': (12.011,
    '5-mem ring aliphatic ch2 (proline cb/cg/cd, thf, deoxyribose)',
    'C'),
    'CG3C53': (12.011,
    '5-mem ring aliphatic ch  adjacent to positive n (proline.h+ ca) (+)',
    'C'),
    'CG3C54': (12.011,
    '5-mem ring aliphatic ch2 adjacent to positive n (proline.h+ cd) (+)',
    'C'),
    'CG3RC1': (12.011,
    'bridgehead in bicyclic systems containing at least one 5-membered or smaller ring',
    'C'),
    'NG1T1': (14.007, 'n for cyano group', 'N'),
    'NG2D1': (14.007,
    "n for neutral imine/schiff's base (c=n-r, acyclic amidine, gunaidine)",
    None),
    'NG2S0': (14.007, "n,n-disubstituted amide, proline n (co=nrr')", 'N'),
    'NG2S1': (14.007, 'peptide nitrogen (co=nhr)', 'N'),
    'NG2S2': (14.007, 'terminal amide nitrogen (co=nh2)', 'N'),
    'NG2S3': (14.007,
    'external amine ring nitrogen (planar/aniline), phosphoramidate',
    'N'),
    'NG2O1': (14.007, 'nitb, nitrobenzene', 'N'),
    'NG2P1': (14.007,
    "n for protonated imine/schiff's base (c=n(+)h-r, acyclic amidinium, guanidinium)",
    'N'),
    'NG2R43': (14.007, 'amide in 4-memebered ring (planar), azdo, lsk', 'N'),
    'NG2R50': (14.007, 'double bound neutral 5-mem planar ring, purine n7', 'N'),
    'NG2R51': (14.007,
    'single bound neutral 5-mem planar (all atom types sp2) ring, his, trp pyrrole (fused)',
    'N'),
    'NG2R52': (14.007,
    'protonated schiff base, amidinium, guanidinium in 5-membered ring, his, 2hpp, kevo',
    'N'),
    'NG2R53': (14.007,
    'amide in 5-memebered non-sp2 ring (slightly pyramidized), 2pdo, kevo',
    'N'),
    'NG2R57': (14.007, '5-mem ring, bipyrroles', 'N'),
    'NG2R60': (14.007, 'double bound neutral 6-mem planar ring, pyr1, pyzn', 'N'),
    'NG2R61': (14.007,
    'single bound neutral 6-mem planar ring imino nitrogen; glycosyl linkage',
    'N'),
    'NG2R62': (14.007,
    'double bound 6-mem planar ring with heteroatoms in o or m, pyrd, pyrm',
    'N'),
    'NG2R67': (14.007,
    '6-mem planar ring substituted with 6-mem planar ring (n-phenyl pyridinones etc.)',
    'N'),
    'NG2RC0': (14.007, '6/5-mem ring bridging n, indolizine, indz, kevo', 'N'),
    'NG301': (14.007, 'neutral trimethylamine nitrogen', 'N'),
    'NG311': (14.007, 'neutral dimethylamine nitrogen', 'N'),
    'NG321': (14.007, 'neutral methylamine nitrogen', 'N'),
    'NG331': (14.007, 'neutral ammonia nitrogen', 'N'),
    'NG3C51': (14.007, 'secondary sp3 amine in 5-membered ring', 'N'),
    'NG3N1': (14.007, 'n in hydrazine, hdzn', 'N'),
    'NG3P0': (14.007, 'quarternary n+, choline', 'N'),
    'NG3P1': (14.007, 'tertiary nh+ (pip)', 'N'),
    'NG3P2': (14.007, 'secondary nh2+ (proline)', 'N'),
    'NG3P3': (14.007, 'primary nh3+, phosphatidylethanolamine', 'N'),
    'OG2D1': (15.9994,
    'carbonyl o: amides, esters, [neutral] carboxylic acids, aldehydes, urea',
    'O'),
    'OG2D2': (15.9994,
    'carbonyl o: negative groups: carboxylates, carbonate',
    'O'),
    'OG2D3': (15.9994, 'carbonyl o: ketones', 'O'),
    'OG2D4': (15.9994, '6-mem aromatic carbonyl oxygen (nucleic bases)', 'O'),
    'OG2D5': (15.9994, 'co2 oxygen', 'O'),
    'OG2N1': (15.9994, 'nitb, nitrobenzene', 'O'),
    'OG2P1': (15.9994, '=o in phosphate or sulfate', 'O'),
    'OG2R50': (15.9994, 'fura, furan', 'O'),
    'OG3R60': (15.9994,
    'o in 6-mem cyclic enol ether (py01, py02) or ester',
    'O'),
    'OG301': (15.9994,
    'ether -o- !should we have a separate enol ether??? if yes, should we merge it with og3r60???',
    'O'),
    'OG302': (15.9994, 'ester -o-', 'O'),
    'OG303': (15.9994, 'phosphate/sulfate ester oxygen', 'O'),
    'OG304': (15.9994, 'linkage oxygen in pyrophosphate/pyrosulphate', 'O'),
    'OG311': (15.9994, 'hydroxyl oxygen', 'O'),
    'OG312': (15.9994, 'ionized alcohol oxygen', 'O'),
    'OG3C31': (15.9994, 'epoxide oxygen, 1eox, 1box, sc', 'O'),
    'OG3C51': (15.9994, '5-mem furanose ring oxygen (ether)', 'O'),
    'OG3C61': (15.9994,
    'diox, dioxane, ether in 6-membered ring !should we merge this with og3r60???',
    'O'),
    'SG2D1': (32.06, 'thiocarbonyl s', 'S'),
    'SG2R50': (32.06, 'thip, thiophene', 'S'),
    'SG311': (32.06, 'sulphur, sh, -s-', 'S'),
    'SG301': (32.06, 'sulfur c-s-s-c type', 'S'),
    'SG302': (32.06, 'thiolate sulfur (-1)', 'S'),
    'SG3O1': (32.06, 'sulfate -1 sulfur', 'S'),
    'SG3O2': (32.06, 'neutral sulfone/sulfonamide sulfur', 'S'),
    'SG3O3': (32.06, 'neutral sulfoxide sulfur', 'S'),
    'CLGA1': (35.453, 'clet, dcle, chloroethane, 1,1-dichloroethane', 'CL'),
    'CLGA3': (35.453, 'tcle, 1,1,1-trichloroethane', 'CL'),
    'CLGR1': (35.453, 'chlb, chlorobenzene', 'CL'),
    'BRGA1': (79.904, 'bret, bromoethane', 'BR'),
    'BRGA2': (79.904, 'dbre, 1,1-dibromoethane', 'BR'),
    'BRGA3': (79.904, 'tbre, 1,1,1-dibromoethane', 'BR'),
    'BRGR1': (79.904, 'brob, bromobenzene', 'BR'),
    'IGR1': (126.90447, 'iodb, iodobenzene', 'I'),
    'FGA1': (18.998, 'aliphatic fluorine, monofluoro', 'F'),
    'FGA2': (18.998, 'aliphatic fluorine, difluoro', 'F'),
    'FGA3': (18.998, 'aliphatic fluorine, trifluoro', 'F'),
    'FGP1': (18.998, 'anionic f, for alf4 alf4-', 'F'),
    'FGR1': (18.998, 'aromatic flourine', 'F'),
    'PG0': (30.9738, 'neutral phosphate', 'P'),
    'PG1': (30.9738, 'phosphate -1', 'P'),
    'PG2': (30.9738, 'phosphate -2', 'P'),
    'ALG1': (26.98154, 'aluminum, for alf4, alf4-', 'AL'),
    'LPH': (0.0, 'lone pair for halogens, change name to lpg for training', 'X'),
    'SG2P1': (32.06, 'mono-thio s-p bond', 'S'),
    'OG2S1': (15.9994, 'mono-thio s-p bond modulated oxygen', 'O'),
    'SG2P2': (32.06, 'di-thio s-p bond', 'S'),
    'SEGD1': (78.96, 'selenocarbonyl se', 'SE'),
    'BG201': (10.811, 'boronic acid b', 'B')
}