"""Lookup dictionaries for converting CHARMM atom names to elements. This is 
used to provide element information to the Atom class, when the element cannot 
be infered from the atom name. (e.g. CHARMM CRD file format). The dictionaries
are organized by residue type, and then by atom name. The information is derived 
from CHARMM36 and CGenFF force field files."""

prot_element_dict = {
    'N': 'N',
    'HN': 'H',
    'CA': 'C',
    'HA': 'H',
    'CB': 'C',
    'HB1': 'H',
    'HB2': 'H',
    'HB3': 'H',
    'C': 'C',
    'O': 'O',
    'CG': 'C',
    'HG1': 'H',
    'HG2': 'H',
    'CD': 'C',
    'HD1': 'H',
    'HD2': 'H',
    'NE': 'N',
    'HE': 'H',
    'CZ': 'C',
    'NH1': 'N',
    'HH11': 'H',
    'HH12': 'H',
    'NH2': 'N',
    'HH21': 'H',
    'HH22': 'H',
    'OD1': 'O',
    'ND2': 'N',
    'HD21': 'H',
    'HD22': 'H',
    'OD2': 'O',
    'SG': 'S',
    'OE1': 'O',
    'NE2': 'N',
    'HE21': 'H',
    'HE22': 'H',
    'OE2': 'O',
    'HA1': 'H',
    'HA2': 'H',
    'ND1': 'N',
    'CE1': 'C',
    'HE1': 'H',
    'CD2': 'C',
    'HE2': 'H',
    'HB': 'H',
    'CG2': 'C',
    'HG21': 'H',
    'HG22': 'H',
    'HG23': 'H',
    'CG1': 'C',
    'HG11': 'H',
    'HG12': 'H',
    'CD1': 'C',
    'HD3': 'H',
    'HG': 'H',
    'HD11': 'H',
    'HD12': 'H',
    'HD13': 'H',
    'HD23': 'H',
    'CE': 'C',
    'NZ': 'N',
    'HZ1': 'H',
    'HZ2': 'H',
    'HZ3': 'H',
    'SD': 'S',
    'HE3': 'H',
    'HZ': 'H',
    'CE2': 'C',
    'OG': 'O',
    'OG1': 'O',
    'NE1': 'N',
    'CE3': 'C',
    'CZ3': 'C',
    'CZ2': 'C',
    'CH2': 'C',
    'HH2': 'H',
    'OH': 'O',
    'HH': 'H',
    'HG13': 'H',
    'CL': 'C',
    'HL1': 'H',
    'HL2': 'H',
    'HL3': 'H',
    'CLP': 'C',
    'OL': 'O',
    'NL': 'N',
    'HL': 'H',
    'CRP': 'C',
    'OR': 'O',
    'NR': 'N',
    'HR': 'H',
    'CR': 'C',
    'HR1': 'H',
    'HR2': 'H',
    'HR3': 'H',
    'HT1': 'H',
    'HT2': 'H',
    'HT3': 'H',
    'HN1': 'H',
    'HN2': 'H',
    'CAY': 'C',
    'HY1': 'H',
    'HY2': 'H',
    'HY3': 'H',
    'CY': 'C',
    'OY': 'O',
    'OT1': 'O',
    'OT2': 'O',
    'HT2B': 'H',
    'CT': 'C',
    'NT': 'N',
    'HNT': 'H',
    'CAT': 'C',
    '1CB': 'C',
    '1SG': 'S',
    '2SG': 'S',
    '2CB': 'C'
}

nucleic_element_dict = {
    'P': 'P',
    'OP1': 'O',
    'OP2': 'O',
    "O5'": 'O',
    "C5'": 'C',
    "H5'": 'H',
    "H5''": 'H',
    "C4'": 'C',
    "H4'": 'H',
    "O4'": 'O',
    "C1'": 'C',
    "H1'": 'H',
    'N9': 'N',
    'C4': 'C',
    'N2': 'N',
    'H21': 'H',
    'H22': 'H',
    'N3': 'N',
    'C2': 'C',
    'N1': 'N',
    'H1': 'H',
    'C6': 'C',
    'O6': 'O',
    'C5': 'C',
    'N7': 'N',
    'C8': 'C',
    'H8': 'H',
    "C2'": 'C',
    "H2''": 'H',
    "O2'": 'O',
    "H2'": 'H',
    "C3'": 'C',
    "H3'": 'H',
    "O3'": 'O',
    'H2': 'H',
    'N6': 'N',
    'H61': 'H',
    'H62': 'H',
    'H6': 'H',
    'H5': 'H',
    'O2': 'O',
    'N4': 'N',
    'H41': 'H',
    'H42': 'H',
    'H3': 'H',
    'O4': 'O',
    'C5M': 'C',
    'H51': 'H',
    'H52': 'H',
    'H53': 'H',
    '+P': 'P',
    'H5T': 'H',
    "H53'": 'H',
    'O5T': 'O',
    'C5T': 'C',
    'H5T1': 'H',
    'H5T2': 'H',
    'H5T3': 'H',
    'H3T': 'H',
    'P3': 'P',
    'OP13': 'O',
    'OP23': 'O',
    'O3T': 'O',
    'C3T': 'C',
    'H3T1': 'H',
    'H3T2': 'H',
    'H3T3': 'H',
    'O3P3': 'O'
}
# ion and water
ion_element_dict = { 
    'OH2': 'O',
    'H1': 'H',
    'H2': 'H',
    'HT': 'H',
    'HX': 'H',
    'OT': 'O',
    'OX': 'O',
    'HPER': 'H',
    'OPER': 'O',
    'LIT': 'LI',
    'SOD': 'NA',
    'MG': 'MG',
    'POT': 'K',
    'CAL': 'CA',
    'RUB': 'RB',
    'CES': 'CS',
    'BAR': 'BA',
    'ZN': 'ZN',
    'CAD': 'CD',
    'CLA': 'CL'
}

cgenff_element_dict = {
    'HGA1': 'H',
    'HGA2': 'H',
    'HGA3': 'H',
    'HGA4': 'H',
    'HGA5': 'H',
    'HGA6': 'H',
    'HGA7': 'H',
    'HGAAM0': 'H',
    'HGAAM1': 'H',
    'HGAAM2': 'H',
    'HGP1': 'H',
    'HGP2': 'H',
    'HGP3': 'H',
    'HGP4': 'H',
    'HGP5': 'H',
    'HGPAM1': 'H',
    'HGPAM2': 'H',
    'HGPAM3': 'H',
    'HGR51': 'H',
    'HGR52': 'H',
    'HGR53': 'H',
    'HGR61': 'H',
    'HGR62': 'H',
    'HGR63': 'H',
    'HGR71': 'H',
    'CG1T1': 'C',
    'CG1T2': 'C',
    'CG1N1': 'C',
    'CG2D1': 'C',
    'CG2D2': 'C',
    'CG2D1O': 'C',
    'CG2D2O': 'C',
    'CG2DC1': 'C',
    'CG2DC2': 'C',
    'CG2DC3': 'C',
    'CG2N1': 'C',
    'CG2N2': 'C',
    'CG2O1': 'C',
    'CG2O2': 'C',
    'CG2O3': 'C',
    'CG2O4': 'C',
    'CG2O5': 'C',
    'CG2O6': 'C',
    'CG2O7': 'C',
    'CG2R51': 'C',
    'CG2R52': 'C',
    'CG2R53': 'C',
    'CG2R57': 'C',
    'CG25C1': 'C',
    'CG25C2': 'C',
    'CG251O': 'C',
    'CG252O': 'C',
    'CG2R61': 'C',
    'CG2R62': 'C',
    'CG2R63': 'C',
    'CG2R64': 'C',
    'CG2R66': 'C',
    'CG2R67': 'C',
    'CG2RC0': 'C',
    'CG2R71': 'C',
    'CG2RC7': 'C',
    'CG301': 'C',
    'CG302': 'C',
    'CG311': 'C',
    'CG312': 'C',
    'CG314': 'C',
    'CG321': 'C',
    'CG322': 'C',
    'CG323': 'C',
    'CG324': 'C',
    'CG331': 'C',
    'CG334': 'C',
    'CG3AM0': 'C',
    'CG3AM1': 'C',
    'CG3AM2': 'C',
    'CG3C31': 'C',
    'CG3C41': 'C',
    'CG3C50': 'C',
    'CG3C51': 'C',
    'CG3C52': 'C',
    'CG3C53': 'C',
    'CG3C54': 'C',
    'CG3RC1': 'C',
    'NG1T1': 'N',
    'NG2D1': 'N',
    'NG2S0': 'N',
    'NG2S1': 'N',
    'NG2S2': 'N',
    'NG2S3': 'N',
    'NG2O1': 'N',
    'NG2P1': 'N',
    'NG2R43': 'N',
    'NG2R50': 'N',
    'NG2R51': 'N',
    'NG2R52': 'N',
    'NG2R53': 'N',
    'NG2R57': 'N',
    'NG2R60': 'N',
    'NG2R61': 'N',
    'NG2R62': 'N',
    'NG2R67': 'N',
    'NG2RC0': 'N',
    'NG301': 'N',
    'NG311': 'N',
    'NG321': 'N',
    'NG331': 'N',
    'NG3C51': 'N',
    'NG3N1': 'N',
    'NG3P0': 'N',
    'NG3P1': 'N',
    'NG3P2': 'N',
    'NG3P3': 'N',
    'OG2D1': 'O',
    'OG2D2': 'O',
    'OG2D3': 'O',
    'OG2D4': 'O',
    'OG2D5': 'O',
    'OG2N1': 'O',
    'OG2P1': 'O',
    'OG2R50': 'O',
    'OG3R60': 'O',
    'OG301': 'O',
    'OG302': 'O',
    'OG303': 'O',
    'OG304': 'O',
    'OG311': 'O',
    'OG312': 'O',
    'OG3C31': 'O',
    'OG3C51': 'O',
    'OG3C61': 'O',
    'SG2D1': 'S',
    'SG2R50': 'S',
    'SG311': 'S',
    'SG301': 'S',
    'SG302': 'S',
    'SG3O1': 'S',
    'SG3O2': 'S',
    'SG3O3': 'S',
    'CLGA1': 'CL',
    'CLGA3': 'CL',
    'CLGR1': 'CL',
    'BRGA1': 'BR',
    'BRGA2': 'BR',
    'BRGA3': 'BR',
    'BRGR1': 'BR',
    'IGR1': 'I',
    'FGA1': 'F',
    'FGA2': 'F',
    'FGA3': 'F',
    'FGP1': 'F',
    'FGR1': 'F',
    'PG0': 'P',
    'PG1': 'P',
    'PG2': 'P',
    'ALG1': 'AL',
    'LPH': 'X',
    'SG2P1': 'S',
    'OG2S1': 'O',
    'SG2P2': 'S',
    'SEGD1': 'SE',
    'BG201': 'B'
}

lipid_element_dict = {
    'N': 'N',
    'C13': 'C',
    'H13A': 'H',
    'H13B': 'H',
    'H13C': 'H',
    'C14': 'C',
    'H14A': 'H',
    'H14B': 'H',
    'H14C': 'H',
    'C15': 'C',
    'H15A': 'H',
    'H15B': 'H',
    'H15C': 'H',
    'C12': 'C',
    'H12A': 'H',
    'H12B': 'H',
    'C11': 'C',
    'H11A': 'H',
    'H11B': 'H',
    'P': 'P',
    'O13': 'O',
    'O14': 'O',
    'O11': 'O',
    'O12': 'O',
    'C1': 'C',
    'HA': 'H',
    'HB': 'H',
    'C2': 'C',
    'HS': 'H',
    'HR': 'H',
    'C3': 'C',
    'HX': 'H',
    'HY': 'H',
    'O31': 'O',
    'C31': 'C',
    'O32': 'O',
    'C32': 'C',
    'H2X': 'H',
    'H2Y': 'H',
    'C33': 'C',
    'H3X': 'H',
    'H3Y': 'H',
    'C34': 'C',
    'H4X': 'H',
    'H4Y': 'H',
    'C35': 'C',
    'H5X': 'H',
    'H5Y': 'H',
    'C36': 'C',
    'H6X': 'H',
    'H6Y': 'H',
    'C37': 'C',
    'H7X': 'H',
    'H7Y': 'H',
    'C38': 'C',
    'H8X': 'H',
    'H8Y': 'H',
    'C39': 'C',
    'H9X': 'H',
    'H9Y': 'H',
    'C310': 'C',
    'H10X': 'H',
    'H10Y': 'H',
    'C311': 'C',
    'H11X': 'H',
    'H11Y': 'H',
    'C312': 'C',
    'H12X': 'H',
    'H12Y': 'H',
    'H12Z': 'H',
    'O21': 'O',
    'C21': 'C',
    'O22': 'O',
    'C22': 'C',
    'H2R': 'H',
    'H2S': 'H',
    'C23': 'C',
    'H3R': 'H',
    'H3S': 'H',
    'C24': 'C',
    'H4R': 'H',
    'H4S': 'H',
    'C25': 'C',
    'H5R': 'H',
    'H5S': 'H',
    'C26': 'C',
    'H6R': 'H',
    'H6S': 'H',
    'C27': 'C',
    'H7R': 'H',
    'H7S': 'H',
    'C28': 'C',
    'H8R': 'H',
    'H8S': 'H',
    'C29': 'C',
    'H9R': 'H',
    'H9S': 'H',
    'C210': 'C',
    'H10R': 'H',
    'H10S': 'H',
    'C211': 'C',
    'H11R': 'H',
    'H11S': 'H',
    'C212': 'C',
    'H12R': 'H',
    'H12S': 'H',
    'H12T': 'H',
    'HN1': 'H',
    'HN2': 'H',
    'HN3': 'H',
    'O13A': 'O',
    'O13B': 'O',
    'H12': 'H',
    'OC3': 'O',
    'HO3': 'H',
    'OC2': 'O',
    'HO2': 'H',
    'C213': 'C',
    'H13R': 'H',
    'H13S': 'H',
    'C214': 'C',
    'H14R': 'H',
    'H14S': 'H',
    'H14T': 'H',
    'C313': 'C',
    'H13X': 'H',
    'H13Y': 'H',
    'C314': 'C',
    'H14X': 'H',
    'H14Y': 'H',
    'H14Z': 'H',
    'C215': 'C',
    'H15R': 'H',
    'H15S': 'H',
    'C216': 'C',
    'H16R': 'H',
    'H16S': 'H',
    'H16T': 'H',
    'C315': 'C',
    'H15X': 'H',
    'H15Y': 'H',
    'C316': 'C',
    'H16X': 'H',
    'H16Y': 'H',
    'H16Z': 'H',
    'C217': 'C',
    'H17R': 'H',
    'H17S': 'H',
    'C218': 'C',
    'H18R': 'H',
    'H18S': 'H',
    'H18T': 'H',
    'C317': 'C',
    'H17X': 'H',
    'H17Y': 'H',
    'C318': 'C',
    'H18X': 'H',
    'H18Y': 'H',
    'H18Z': 'H',
    'H91': 'H',
    'H101': 'H',
    'C219': 'C',
    'H19R': 'H',
    'H19S': 'H',
    'C220': 'C',
    'H20R': 'H',
    'H20S': 'H',
    'H20T': 'H',
    'C221': 'C',
    'H21R': 'H',
    'H21S': 'H',
    'C222': 'C',
    'H22R': 'H',
    'H22S': 'H',
    'H22T': 'H',
    'C319': 'C',
    'H19X': 'H',
    'H19Y': 'H',
    'C320': 'C',
    'H20X': 'H',
    'H20Y': 'H',
    'H20Z': 'H'
}

carb_element_dict = {
    'C1': 'C',
    'H1': 'H',
    'O1': 'O',
    'HO1': 'H',
    'C5': 'C',
    'H5': 'H',
    'O5': 'O',
    'C2': 'C',
    'H2': 'H',
    'O2': 'O',
    'HO2': 'H',
    'C3': 'C',
    'H3': 'H',
    'O3': 'O',
    'HO3': 'H',
    'C4': 'C',
    'H4': 'H',
    'O4': 'O',
    'HO4': 'H',
    'C6': 'C',
    'H61': 'H',
    'H62': 'H',
    'O6': 'O',
    'HO6': 'H',
    'H51': 'H',
    'H52': 'H',
    'H63': 'H',
    'O61': 'O',
    'O62': 'O',
    'N': 'N',
    'HN': 'H',
    'C': 'C',
    'O': 'O',
    'CT': 'C',
    'HT1': 'H',
    'HT2': 'H',
    'HT3': 'H',
    'O11': 'O',
    'O12': 'O',
    'H6': 'H',
    'H31': 'H',
    'H32': 'H',
    'C7': 'C',
    'H7': 'H',
    'O7': 'O',
    'HO7': 'H',
    'C8': 'C',
    'H8': 'H',
    'O8': 'O',
    'HO8': 'H',
    'C9': 'C',
    'H91': 'H',
    'H92': 'H',
    'O9': 'O',
    'HO9': 'H',
    'CA2': 'C',
    'OA2': 'O',
    'CB2': 'C',
    'HB1': 'H',
    'HB2': 'H',
    'HB3': 'H',
    'H11': 'H',
    'H12': 'H',
    'H41': 'H',
    'H42': 'H',
    'HO5': 'H',
    'H21': 'H',
    'H22': 'H',
    '1C1': '1',
    '1O1': '1',
    '2C1': '2',
    '1C2': '1',
    '1O2': '1',
    '1C3': '1',
    '1O3': '1',
    '1C4': '1',
    '1O4': '1',
    '1C6': '1',
    '1O6': '1',
    'CM': 'C',
    'HM1': 'H',
    'HM2': 'H',
    'HM3': 'H',
    'H1B': 'H',
    'OM': 'O',
    '2C2': '2',
    '1H1': '1',
    '1C5': '1',
    '1H5': '1',
    '1O5': '1',
    '2O5': '2',
    '2C5': '2',
    '2H5': '2',
    '2C4': '2',
    '3C1': '3',
    '3O1': '3',
    '2C3': '2',
    '2O1': '2',
    '3C2': '3',
    '2C6': '2',
    '2O6': '2',
    '4C2': '4',
    '2CM': '2',
    '2HM1': '2',
    '2HM2': '2',
    '2HM3': '2',
    'C13': 'C',
    'P3': 'P',
    'OP32': 'O',
    'OP33': 'O',
    'OP34': 'O',
    'C14': 'C',
    'P4': 'P',
    'OP42': 'O',
    'OP43': 'O',
    'OP44': 'O',
    'C15': 'C',
    'P5': 'P',
    'OP52': 'O',
    'OP53': 'O',
    'OP54': 'O',
    'S1': 'S',
    'OS12': 'O',
    'OS13': 'O',
    'OS14': 'O',
    'S2': 'S',
    'OS22': 'O',
    'OS23': 'O',
    'OS24': 'O',
    'S3': 'S',
    'OS32': 'O',
    'OS33': 'O',
    'OS34': 'O',
    'S4': 'S',
    'OS42': 'O',
    'OS43': 'O',
    'OS44': 'O',
    'S6': 'S',
    'OS62': 'O',
    'OS63': 'O',
    'OS64': 'O',
    '1C8': 'C',
    '1O8': 'O',
    '1C9': 'C',
    '1O9': 'O'
}

ether_element_dict = {
    'H11': 'H',
    'H12': 'H',
    'H13': 'H',
    'C1': 'C',
    'H21': 'H',
    'H22': 'H',
    'H23': 'H',
    'C2': 'C',
    'H31': 'H',
    'H32': 'H',
    'H33': 'H',
    'C3': 'C',
    'H41': 'H',
    'H42': 'H',
    'H43': 'H',
    'C4': 'C',
    'C5': 'C',
    'H51': 'H',
    'H52': 'H',
    'H53': 'H',
    'C6': 'C',
    'H61': 'H',
    'H62': 'H',
    'H63': 'H',
    'C7': 'C',
    'H71': 'H',
    'H72': 'H',
    'H73': 'H',
    'C8': 'C',
    'H81': 'H',
    'H82': 'H',
    'H83': 'H',
    'H1A': 'H',
    'H1B': 'H',
    'H1C': 'H',
    'H2A': 'H',
    'H2B': 'H',
    'H3A': 'H',
    'H3B': 'H',
    'H4A': 'H',
    'H4B': 'H',
    'H5A': 'H',
    'H5B': 'H',
    'H6A': 'H',
    'H6B': 'H',
    'H7A': 'H',
    'H7B': 'H',
    'H8A': 'H',
    'H8B': 'H',
    'C9': 'C',
    'H9A': 'H',
    'H9B': 'H',
    'C10': 'C',
    'H10A': 'H',
    'H10B': 'H',
    'H10C': 'H',
    'C11': 'C',
    'H11A': 'H',
    'H11B': 'H',
    'C12': 'C',
    'H12A': 'H',
    'H12B': 'H',
    'C13': 'C',
    'H13A': 'H',
    'H13B': 'H',
    'C14': 'C',
    'H14A': 'H',
    'H14B': 'H',
    'C15': 'C',
    'H15A': 'H',
    'H15B': 'H',
    'H15C': 'H',
    'C16': 'C',
    'H16A': 'H',
    'H16B': 'H',
    'C17': 'C',
    'H17A': 'H',
    'H17B': 'H',
    'C18': 'C',
    'H18A': 'H',
    'H18B': 'H',
    'H18C': 'H',
    'CT': 'C',
    'HT': 'H',
    'O1': 'O',
    'H5C': 'H',
    'O2': 'O',
    'O3': 'O',
    'O5': 'O',
    'H2C': 'H',
    'CE': 'C',
    'HE1': 'H',
    'HE2': 'H',
    'HE3': 'H',
    'CA': 'C',
    'HA1': 'H',
    'HA2': 'H',
    'HA3': 'H'
}

element_dict = {
    'prot': prot_element_dict,
    'nucleic': nucleic_element_dict,
    'ion': ion_element_dict,
    'cgenff': cgenff_element_dict,
    'lipid': lipid_element_dict,
    'carb': carb_element_dict,
    'ether': ether_element_dict
}

all_element_dict = {}
for key, value in element_dict.items():
    all_element_dict.update(value)