"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2024 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Gender Identification gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class IdentifyRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Identify</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOICEPRINTS_FIELD_NUMBER: builtins.int
    @property
    def voiceprints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[phonexia.grpc.common.core_pb2.Voiceprint]:
        """List of voiceprints for the identification."""

    def __init__(
        self,
        *,
        voiceprints: collections.abc.Iterable[phonexia.grpc.common.core_pb2.Voiceprint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["voiceprints", b"voiceprints"]) -> None: ...

global___IdentifyRequest = IdentifyRequest

@typing.final
class Score(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCORE_LLR_FIELD_NUMBER: builtins.int
    score_llr: builtins.float
    """Log-likelihood ratio score. The LLR provides a quantitative measure of
    how much more likely the data is under one model (gender) compared
    to another.
    A positive LLR suggests that the respective model is more likely to be
    supported by the data than the other model, while the negative LLR suggests
    the opposite.
    """
    def __init__(
        self,
        *,
        score_llr: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["score_llr", b"score_llr"]) -> None: ...

global___Score = Score

@typing.final
class IdentifyResult(google.protobuf.message.Message):
    """A gender identification result. It contains scores for respective genders."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCORE_MALE_FIELD_NUMBER: builtins.int
    SCORE_FEMALE_FIELD_NUMBER: builtins.int
    @property
    def score_male(self) -> global___Score:
        """Score for male."""

    @property
    def score_female(self) -> global___Score:
        """Score for female."""

    def __init__(
        self,
        *,
        score_male: global___Score | None = ...,
        score_female: global___Score | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["score_female", b"score_female", "score_male", b"score_male"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["score_female", b"score_female", "score_male", b"score_male"]) -> None: ...

global___IdentifyResult = IdentifyResult

@typing.final
class IdentifyResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Identify</code>
    method. It contains the result as one or more <code>IdentifyResult</code>
    messages.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULTS_FIELD_NUMBER: builtins.int
    @property
    def results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IdentifyResult]:
        """Sequential list of results corresponding to sequential list of voiceprints
        in <code>IdentifyRequest</code>.
        """

    def __init__(
        self,
        *,
        results: collections.abc.Iterable[global___IdentifyResult] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["results", b"results"]) -> None: ...

global___IdentifyResponse = IdentifyResponse
