"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2024 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Speaker Identification gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CompareRequest(google.protobuf.message.Message):
    """The message sent by the client for the <code>Compare</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VOICEPRINTS_A_FIELD_NUMBER: builtins.int
    VOICEPRINTS_B_FIELD_NUMBER: builtins.int
    @property
    def voiceprints_a(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[phonexia.grpc.common.core_pb2.Voiceprint]:
        """First list of voiceprints to be compared."""

    @property
    def voiceprints_b(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[phonexia.grpc.common.core_pb2.Voiceprint]:
        """Second list of voiceprints to be compared."""

    def __init__(
        self,
        *,
        voiceprints_a: collections.abc.Iterable[phonexia.grpc.common.core_pb2.Voiceprint] | None = ...,
        voiceprints_b: collections.abc.Iterable[phonexia.grpc.common.core_pb2.Voiceprint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["voiceprints_a", b"voiceprints_a", "voiceprints_b", b"voiceprints_b"]) -> None: ...

global___CompareRequest = CompareRequest

@typing.final
class CompareResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Compare</code>
    method. It contains comparison matrix of log-likelihood ratio (LLR) scores.
    Comparison matrix containing similarity scores between
    <code>voiceprints_a</code> and <code>voiceprints_b</code>. The element at
    row <code>i</code> and column <code>j</code> corresponds to the comparison
    result between <code>voiceprints_a[i]</code> and
    <code>voiceprints_b[j]</code>.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCORES_FIELD_NUMBER: builtins.int
    @property
    def scores(self) -> phonexia.grpc.common.core_pb2.Matrix:
        """The similarity scores are expressed as log-likelihood ratio (LLR) values,
        which fall within the interval of <code>(-inf;+inf)</code>, with higher
        values indicating higher similarity.
        """

    def __init__(
        self,
        *,
        scores: phonexia.grpc.common.core_pb2.Matrix | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["scores", b"scores"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["scores", b"scores"]) -> None: ...

global___CompareResponse = CompareResponse

@typing.final
class ExtractRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Extract</code> method."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio to extract voiceprints from."""

    @property
    def config(self) -> global___ExtractConfig:
        """Voiceprint extraction configuration."""

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
        config: global___ExtractConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio", "config", b"config"]) -> None: ...

global___ExtractRequest = ExtractRequest

@typing.final
class ExtractConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Specifies the maximum speech length from which the voiceprint will be
        extracted. If there is less speech in the audio than the specified
        duration, the voiceprint will be extracted from the entire audio.
        """

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["speech_length", b"speech_length"]) -> None: ...

global___ExtractConfig = ExtractConfig

@typing.final
class ExtractResult(google.protobuf.message.Message):
    """A voiceprint extraction result."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    VOICEPRINT_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Speech length from which the voiceprint was extracted."""

    @property
    def voiceprint(self) -> phonexia.grpc.common.core_pb2.Voiceprint:
        """Extracted voiceprint."""

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
        voiceprint: phonexia.grpc.common.core_pb2.Voiceprint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["speech_length", b"speech_length", "voiceprint", b"voiceprint"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["speech_length", b"speech_length", "voiceprint", b"voiceprint"]) -> None: ...

global___ExtractResult = ExtractResult

@typing.final
class ExtractResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Extract</code>
    method. It contains the result as zero or more <code>ExtractResult</code>
    messages.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___ExtractResult:
        """Result containing the extracted voiceprint."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """When available, total length of the processed audio.
        Set only if this is the last response in the stream.
        """

    def __init__(
        self,
        *,
        result: global___ExtractResult | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "result", b"result"]) -> None: ...

global___ExtractResponse = ExtractResponse
