

from . import _lines_database


_DLINES_TOT = _lines_database._DLINES_TOT


# #############################################################################
# #############################################################################
#           _DLINES
# #############################################################################


_DLINES = {
    'ArXVII': [
        k0 for k0, v0 in _DLINES_TOT.items()
        if (
            (
                k0 in ['ArXVII_w_Bruhns', 'ArXVII_z_Amaro']
                or ('Adhoc200408' in k0)
            )
            and v0['symbol'] not in ['q', 'r', 'a', 'n3', 'n4']
        )
    ],
    'ArXVIII': [
    ],
    'FeXXV': [
    ],
}


# #############################################################################
# #############################################################################
#           _DCONSTRAINTS
# #############################################################################


_DCONSTRAINTS = {
    'ArXVII': {
        'double': True,
        'symmetry': False,
        'width': {
            'wxyzkj': [
                'ArXVII_w_Bruhns', 'ArXVII_z_Amaro',
                'ArXVII_x_Adhoc200408', 'ArXVII_y_Adhoc200408',
                'ArXVI_k_Adhoc200408', 'ArXVI_j_Adhoc200408',
                # 'ArXVI_q_Adhoc200408', 'ArXVI_r_Adhoc200408',
                # 'ArXVI_a_Adhoc200408',
            ],
            # 'n34': ['ArXV_n4_Adhoc200408'], # 'ArXIV_n3_Adhoc200408'],
        },
        'amp': {
            'ArXVI_k_Adhoc200408': {'key': 'kj'},
            'ArXVI_j_Adhoc200408': {'key': 'kj', 'coef': 1.3576},
        },
        'shift': {
            'wxyzkj': [
                'ArXVII_w_Bruhns', 'ArXVII_z_Amaro',
                # 'ArXVII_x_Adhoc200408', 'ArXVII_y_Adhoc200408',
                # 'ArXVI_k_Adhoc200408', 'ArXVI_j_Adhoc200408',
                # 'ArXVI_q_Adhoc200408', 'ArXVI_r_Adhoc200408',
                # 'ArXVI_a_Adhoc200408',
                # 'ArXV_n4_Adhoc200408', # 'ArXIV_n3_Adhoc200408',
            ],
            # 'wz': ['ArXVII_w_Bruhns', 'ArXVII_z_Amaro'],
            # 'qra': [
            # 'ArXVI_q_Adhoc200408', 'ArXVI_r_Adhoc200408',
            # 'ArXVI_a_Adhoc200408',
            # ],
            'xy': ['ArXVII_x_Adhoc200408', 'ArXVII_y_Adhoc200408'],
            'kjz': ['ArXVI_k_Adhoc200408', 'ArXVI_j_Adhoc200408'],
        },
    },
    'ArXVIII': {
        'double': True,
        'symmetry': False,
    },
    'FeXXV': {
        'double': True,
        'symmetry': False,
    },
}


# #############################################################################
# #############################################################################
#           _DCONSTANTS
# #############################################################################


_DCONSTANTS = {
    'ArXVII': {
        'dratio': 0.7,
        'dshift': 4.e-4,
    },
    'ArXVIII': {
    },
    'FeXXV': {
    },
}


# #############################################################################
# #############################################################################
#           _DOMAIN
# #############################################################################


_DOMAIN = {
    'ArXVII': {
        'phi': [-0.1, 0.1],
        'lamb': [
            [3.93e-10, 4.009e-10],
            (3.95e-10, 3.96e-10),
            (3.979e-10, 3.988e-10),
        ],
    },
    'ArXVIII': None,
    'FeXXV': None,
}


# #############################################################################
# #############################################################################
#           _FOCUS
# #############################################################################


_FOCUS = {
    'ArXVII': [
        [3.9490e-10, 2.e-13],
        [3.9680e-10, 4.e-13],
        [3.9930e-10, 3.e-13],
    ],  # ['w', 'x', 'y', 'k', 'z'],
    'ArXVIII': None,
    'FeXXV': None,
}


# #############################################################################
# #############################################################################
#           _BINNING
# #############################################################################


_PHI_BINS = 200
_LAMB_BINS = 445
_BINNING = {
    'ArXVII': {
        'phi': {'nbins': _PHI_BINS},
        'lamb': {'nbins': 445},
    },
    'ArXVIII': {
        'phi': {'nbins': _PHI_BINS},
        'lamb': {'nbins': _LAMB_BINS},
    },
    'FeXXV': {
        'phi': {'nbins': _PHI_BINS},
        'lamb': {'nbins': _LAMB_BINS},
    },
}


# #############################################################################
# #############################################################################
#           _DSCALES
# #############################################################################


_DSCALES = {
    'ArXVII': {
        # 'width': 1e-8,      # To be tuned
        # 'dshift': 5e-4,
    },
}


# #############################################################################
# #############################################################################
#           _DX0
# #############################################################################


_DX0 = {
    'ArXVII': {
        'dratio': 0.75,
        'dshift': 1.,
    },
}


# #############################################################################
# #############################################################################
#           _DBOUNDS
# #############################################################################


_DBOUNDS = {
    'ArXVII': None,  # {
    # 'min': {},
    # 'max': {'width': 1},
    # },
}
