#!/usr/bin/env python
# -*- coding: utf-8 -*-
'''
:py:mod:`__init__.py` - Initialization
--------------------------------------

'''

from __future__ import division, print_function, absolute_import, unicode_literals
from .k2 import *
from .sysrem import GetCBVs
from . import aux, pbs, pipelines, sysrem
from .pbs import Download, Run, Status, Publish

#: The string that identifies individual targets for this mission
IDSTRING = 'EPIC'
#: The character abbreviation of the name given to an observing "season" for this mission
SEASONCHAR = 'C'
#: The string representing the filter/band used in the mission 
MAGSTRING = r'K$_\mathrm{p}$'
#: The time units for the mission
TIMEUNITS = 'BJD - 2454833'
#: The published light curve CSV file header
CSVHEADER = \
'''EPIC %09d
==============


DESCRIPTION
-----------
De-trended light curve generated by the Everest pipeline.
Everest implements 3rd order pixel-level decorrelation to
remove instrumental systematics from light curves. Here we
provide a simple version of the de-trended timeseries, but
users are encouraged to interface with the Everest catalog
using the Python code available at

https://github.com/rodluger/everest 

This is particularly useful for users interested in transit
photometry. Like any regression method that attempts to min-
imize photometric scatter, Everest may partially overfit
transit features that are not properly masked. The Everest
code provides easy-to-use methods to mask known transits,
eliminating biases in the transit depth. For more informa-
tion, consult the documentation linked on the github page.


ATTRIBUTION
-----------
If you make use of this light curve, please cite

  1. Luger, R. et al. 2016, AJ, 152, 100
  2. Luger, R. et al. 2017, AJ (submitted)


COLUMN INFO
-----------
TIME (float): Time (BJD - 2454833)
CADN (int):   Cadence number
FCOR (float): CBV-corrected, PLD de-trended flux
FLUX (float): PLD de-trended flux
FRAW (float): Raw simple aperture photometry flux
MASK (int):   0 = Data point was included in the model 
                  calculation
              1 = Data point was NaN in the raw flux
              2 = Data point has a flagged QUALITY bit
              3 = Data point was identified as an outlier

'''