# Generated by Django 4.2.23 on 2025-08-23 14:45

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AllianceSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alliance_rate_percent', models.DecimalField(decimal_places=2, default=0.0, max_digits=5)),
                ('flat_tax_reduction', models.BigIntegerField(default=0)),
            ],
            options={
                'verbose_name': 'Alliance Settings',
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Corporation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('corporation_id', models.BigIntegerField(unique=True)),
                ('name', models.CharField(max_length=128)),
                ('ticker', models.CharField(blank=True, max_length=16)),
                ('logo_url', models.URLField(blank=True)),
            ],
            options={
                'permissions': [('basic_access', 'Can use ratting tax module'), ('view_all', 'Can view all corporations in RattingTax')],
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='TaxConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('corp_tax_rate_percent', models.DecimalField(decimal_places=2, default=10.0, max_digits=5)),
                ('corp', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='tax_cfg', to='rattingtax.corporation')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='CorpTokenLink',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('character_id', models.BigIntegerField()),
                ('character_name', models.CharField(max_length=128)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('corp', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='token_link', to='rattingtax.corporation')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='CorpMonthStat',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('year', models.PositiveIntegerField()),
                ('month', models.PositiveIntegerField()),
                ('corp_bounty_tax_amount', models.DecimalField(decimal_places=2, default=0, max_digits=20)),
                ('corp', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='month_stats', to='rattingtax.corporation')),
            ],
            options={
                'ordering': ['-year', '-month'],
                'default_permissions': (),
                'unique_together': {('corp', 'year', 'month')},
            },
        ),
    ]
