/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.github.fge.jackson.JsonNumEquivalence;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.google.common.base.Equivalence;
import io.ray.shaded.com.google.common.collect.Sets;
import java.util.HashSet;

public final class UniqueItemsValidator
extends AbstractKeywordValidator {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    private final boolean uniqueItems;

    public UniqueItemsValidator(JsonNode digest) {
        super("uniqueItems");
        this.uniqueItems = digest.get(this.keyword).booleanValue();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        if (!this.uniqueItems) {
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        JsonNode node = data.getInstance().getNode();
        for (JsonNode element : node) {
            if (set.add(EQUIVALENCE.wrap(element))) continue;
            report.error(this.newMsg(data, bundle, "err.common.uniqueItems.duplicateElements"));
            return;
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.uniqueItems;
    }
}

