# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AadConnectivityState1(Model):
    """Describes an Azure resource with kind.

    :param connectivity_state: The connectivity state of the external AAD
     solution . Possible values include: 'Discovered', 'NotLicensed',
     'Connected'
    :type connectivity_state: str or
     ~azure.mgmt.security.models.AadConnectivityState
    """

    _attribute_map = {
        'connectivity_state': {'key': 'connectivityState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AadConnectivityState1, self).__init__(**kwargs)
        self.connectivity_state = kwargs.get('connectivity_state', None)


class ExternalSecuritySolution(Model):
    """Represents a security solution external to Azure Security Center which
    sends information to an OMS workspace and whose data is displayed by Azure
    Security Center.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CefExternalSecuritySolution, AtaExternalSecuritySolution,
    AadExternalSecuritySolution

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'CEF': 'CefExternalSecuritySolution', 'ATA': 'AtaExternalSecuritySolution', 'AAD': 'AadExternalSecuritySolution'}
    }

    def __init__(self, **kwargs):
        super(ExternalSecuritySolution, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.kind = None


class AadExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an AAD identity protection solution which sends logs to an OMS
    workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param properties:
    :type properties: ~azure.mgmt.security.models.AadSolutionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AadSolutionProperties'},
    }

    def __init__(self, **kwargs):
        super(AadExternalSecuritySolution, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.kind = 'AAD'


class AadSolutionProperties(Model):
    """The external security solution properties for AAD solutions.

    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :param connectivity_state: The connectivity state of the external AAD
     solution . Possible values include: 'Discovered', 'NotLicensed',
     'Connected'
    :type connectivity_state: str or
     ~azure.mgmt.security.models.AadConnectivityState
    """

    _attribute_map = {
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
        'connectivity_state': {'key': 'connectivityState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AadSolutionProperties, self).__init__(**kwargs)
        self.device_vendor = kwargs.get('device_vendor', None)
        self.device_type = kwargs.get('device_type', None)
        self.workspace = kwargs.get('workspace', None)
        self.connectivity_state = kwargs.get('connectivity_state', None)


class CustomAlertRule(Model):
    """A custom alert rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ThresholdCustomAlertRule, ListCustomAlertRule

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
    }

    _subtype_map = {
        'rule_type': {'ThresholdCustomAlertRule': 'ThresholdCustomAlertRule', 'ListCustomAlertRule': 'ListCustomAlertRule'}
    }

    def __init__(self, **kwargs):
        super(CustomAlertRule, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.is_enabled = kwargs.get('is_enabled', None)
        self.rule_type = None


class ThresholdCustomAlertRule(CustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert
    type) is within the given range.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: TimeWindowCustomAlertRule

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
    }

    _subtype_map = {
        'rule_type': {'TimeWindowCustomAlertRule': 'TimeWindowCustomAlertRule'}
    }

    def __init__(self, **kwargs):
        super(ThresholdCustomAlertRule, self).__init__(**kwargs)
        self.min_threshold = kwargs.get('min_threshold', None)
        self.max_threshold = kwargs.get('max_threshold', None)
        self.rule_type = 'ThresholdCustomAlertRule'


class TimeWindowCustomAlertRule(ThresholdCustomAlertRule):
    """A custom alert rule that checks if the number of activities (depends on the
    custom alert type) in a time window is within the given range.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ActiveConnectionsNotInAllowedRange,
    AmqpC2DMessagesNotInAllowedRange, MqttC2DMessagesNotInAllowedRange,
    HttpC2DMessagesNotInAllowedRange, AmqpC2DRejectedMessagesNotInAllowedRange,
    MqttC2DRejectedMessagesNotInAllowedRange,
    HttpC2DRejectedMessagesNotInAllowedRange, AmqpD2CMessagesNotInAllowedRange,
    MqttD2CMessagesNotInAllowedRange, HttpD2CMessagesNotInAllowedRange,
    DirectMethodInvokesNotInAllowedRange, FailedLocalLoginsNotInAllowedRange,
    FileUploadsNotInAllowedRange, QueuePurgesNotInAllowedRange,
    TwinUpdatesNotInAllowedRange, UnauthorizedOperationsNotInAllowedRange

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    _subtype_map = {
        'rule_type': {'ActiveConnectionsNotInAllowedRange': 'ActiveConnectionsNotInAllowedRange', 'AmqpC2DMessagesNotInAllowedRange': 'AmqpC2DMessagesNotInAllowedRange', 'MqttC2DMessagesNotInAllowedRange': 'MqttC2DMessagesNotInAllowedRange', 'HttpC2DMessagesNotInAllowedRange': 'HttpC2DMessagesNotInAllowedRange', 'AmqpC2DRejectedMessagesNotInAllowedRange': 'AmqpC2DRejectedMessagesNotInAllowedRange', 'MqttC2DRejectedMessagesNotInAllowedRange': 'MqttC2DRejectedMessagesNotInAllowedRange', 'HttpC2DRejectedMessagesNotInAllowedRange': 'HttpC2DRejectedMessagesNotInAllowedRange', 'AmqpD2CMessagesNotInAllowedRange': 'AmqpD2CMessagesNotInAllowedRange', 'MqttD2CMessagesNotInAllowedRange': 'MqttD2CMessagesNotInAllowedRange', 'HttpD2CMessagesNotInAllowedRange': 'HttpD2CMessagesNotInAllowedRange', 'DirectMethodInvokesNotInAllowedRange': 'DirectMethodInvokesNotInAllowedRange', 'FailedLocalLoginsNotInAllowedRange': 'FailedLocalLoginsNotInAllowedRange', 'FileUploadsNotInAllowedRange': 'FileUploadsNotInAllowedRange', 'QueuePurgesNotInAllowedRange': 'QueuePurgesNotInAllowedRange', 'TwinUpdatesNotInAllowedRange': 'TwinUpdatesNotInAllowedRange', 'UnauthorizedOperationsNotInAllowedRange': 'UnauthorizedOperationsNotInAllowedRange'}
    }

    def __init__(self, **kwargs):
        super(TimeWindowCustomAlertRule, self).__init__(**kwargs)
        self.time_window_size = kwargs.get('time_window_size', None)
        self.rule_type = 'TimeWindowCustomAlertRule'


class ActiveConnectionsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of active connections is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(ActiveConnectionsNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'ActiveConnectionsNotInAllowedRange'


class Resource(Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AdaptiveNetworkHardening(Resource):
    """The resource whose properties describes the Adaptive Network Hardening
    settings for some Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param rules: The security rules which are recommended to be effective on
     the VM
    :type rules: list[~azure.mgmt.security.models.Rule]
    :param rules_calculation_time: The UTC time on which the rules were
     calculated
    :type rules_calculation_time: datetime
    :param effective_network_security_groups: The Network Security Groups
     effective on the network interfaces of the protected resource
    :type effective_network_security_groups:
     list[~azure.mgmt.security.models.EffectiveNetworkSecurityGroups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rules': {'key': 'properties.rules', 'type': '[Rule]'},
        'rules_calculation_time': {'key': 'properties.rulesCalculationTime', 'type': 'iso-8601'},
        'effective_network_security_groups': {'key': 'properties.effectiveNetworkSecurityGroups', 'type': '[EffectiveNetworkSecurityGroups]'},
    }

    def __init__(self, **kwargs):
        super(AdaptiveNetworkHardening, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)
        self.rules_calculation_time = kwargs.get('rules_calculation_time', None)
        self.effective_network_security_groups = kwargs.get('effective_network_security_groups', None)


class AdaptiveNetworkHardeningEnforceRequest(Model):
    """AdaptiveNetworkHardeningEnforceRequest.

    All required parameters must be populated in order to send to Azure.

    :param rules: Required. The rules to enforce
    :type rules: list[~azure.mgmt.security.models.Rule]
    :param network_security_groups: Required. The Azure resource IDs of the
     effective network security groups that will be updated with the created
     security rules from the Adaptive Network Hardening rules
    :type network_security_groups: list[str]
    """

    _validation = {
        'rules': {'required': True},
        'network_security_groups': {'required': True},
    }

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[Rule]'},
        'network_security_groups': {'key': 'networkSecurityGroups', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(AdaptiveNetworkHardeningEnforceRequest, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)
        self.network_security_groups = kwargs.get('network_security_groups', None)


class AdditionalData(Model):
    """Details of the sub-assessment.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SqlServerVulnerabilityProperties,
    ContainerRegistryVulnerabilityProperties, ServerVulnerabilityProperties

    All required parameters must be populated in order to send to Azure.

    :param assessed_resource_type: Required. Constant filled by server.
    :type assessed_resource_type: str
    """

    _validation = {
        'assessed_resource_type': {'required': True},
    }

    _attribute_map = {
        'assessed_resource_type': {'key': 'assessedResourceType', 'type': 'str'},
    }

    _subtype_map = {
        'assessed_resource_type': {'SqlServerVulnerability': 'SqlServerVulnerabilityProperties', 'ContainerRegistryVulnerability': 'ContainerRegistryVulnerabilityProperties', 'ServerVulnerabilityAssessment': 'ServerVulnerabilityProperties'}
    }

    def __init__(self, **kwargs):
        super(AdditionalData, self).__init__(**kwargs)
        self.assessed_resource_type = None


class AdvancedThreatProtectionSetting(Resource):
    """The Advanced Threat Protection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param is_enabled: Indicates whether Advanced Threat Protection is
     enabled.
    :type is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AdvancedThreatProtectionSetting, self).__init__(**kwargs)
        self.is_enabled = kwargs.get('is_enabled', None)


class Alert(Resource):
    """Security alert.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar state: State of the alert (Active, Dismissed etc.)
    :vartype state: str
    :ivar reported_time_utc: The time the incident was reported to
     Microsoft.Security in UTC
    :vartype reported_time_utc: datetime
    :ivar vendor_name: Name of the vendor that discovered the incident
    :vartype vendor_name: str
    :ivar alert_name: Name of the alert type
    :vartype alert_name: str
    :ivar alert_display_name: Display name of the alert type
    :vartype alert_display_name: str
    :ivar detected_time_utc: The time the incident was detected by the vendor
    :vartype detected_time_utc: datetime
    :ivar description: Description of the incident and what it means
    :vartype description: str
    :ivar remediation_steps: Recommended steps to reradiate the incident
    :vartype remediation_steps: str
    :ivar action_taken: The action that was taken as a response to the alert
     (Active, Blocked etc.)
    :vartype action_taken: str
    :ivar reported_severity: Estimated severity of this alert. Possible values
     include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar compromised_entity: The entity that the incident happened on
    :vartype compromised_entity: str
    :ivar associated_resource: Azure resource ID of the associated resource
    :vartype associated_resource: str
    :param extended_properties:
    :type extended_properties: dict[str, object]
    :ivar system_source: The type of the alerted resource (Azure, Non-Azure)
    :vartype system_source: str
    :ivar can_be_investigated: Whether this alert can be investigated with
     Azure Security Center
    :vartype can_be_investigated: bool
    :ivar is_incident: Whether this alert is for incident type or not
     (otherwise - single alert)
    :vartype is_incident: bool
    :param entities: objects that are related to this alerts
    :type entities: list[~azure.mgmt.security.models.AlertEntity]
    :ivar confidence_score: level of confidence we have on the alert
    :vartype confidence_score: float
    :param confidence_reasons: reasons the alert got the confidenceScore value
    :type confidence_reasons:
     list[~azure.mgmt.security.models.AlertConfidenceReason]
    :ivar subscription_id: Azure subscription ID of the resource that had the
     security alert or the subscription ID of the workspace that this resource
     reports to
    :vartype subscription_id: str
    :ivar instance_id: Instance ID of the alert.
    :vartype instance_id: str
    :ivar workspace_arm_id: Azure resource ID of the workspace that the alert
     was reported to.
    :vartype workspace_arm_id: str
    :ivar correlation_key: Alerts with the same CorrelationKey will be grouped
     together in Ibiza.
    :vartype correlation_key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'reported_time_utc': {'readonly': True},
        'vendor_name': {'readonly': True},
        'alert_name': {'readonly': True},
        'alert_display_name': {'readonly': True},
        'detected_time_utc': {'readonly': True},
        'description': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'action_taken': {'readonly': True},
        'reported_severity': {'readonly': True},
        'compromised_entity': {'readonly': True},
        'associated_resource': {'readonly': True},
        'system_source': {'readonly': True},
        'can_be_investigated': {'readonly': True},
        'is_incident': {'readonly': True},
        'confidence_score': {'readonly': True, 'maximum': 1, 'minimum': 0},
        'subscription_id': {'readonly': True},
        'instance_id': {'readonly': True},
        'workspace_arm_id': {'readonly': True},
        'correlation_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'reported_time_utc': {'key': 'properties.reportedTimeUtc', 'type': 'iso-8601'},
        'vendor_name': {'key': 'properties.vendorName', 'type': 'str'},
        'alert_name': {'key': 'properties.alertName', 'type': 'str'},
        'alert_display_name': {'key': 'properties.alertDisplayName', 'type': 'str'},
        'detected_time_utc': {'key': 'properties.detectedTimeUtc', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'remediation_steps': {'key': 'properties.remediationSteps', 'type': 'str'},
        'action_taken': {'key': 'properties.actionTaken', 'type': 'str'},
        'reported_severity': {'key': 'properties.reportedSeverity', 'type': 'str'},
        'compromised_entity': {'key': 'properties.compromisedEntity', 'type': 'str'},
        'associated_resource': {'key': 'properties.associatedResource', 'type': 'str'},
        'extended_properties': {'key': 'properties.extendedProperties', 'type': '{object}'},
        'system_source': {'key': 'properties.systemSource', 'type': 'str'},
        'can_be_investigated': {'key': 'properties.canBeInvestigated', 'type': 'bool'},
        'is_incident': {'key': 'properties.isIncident', 'type': 'bool'},
        'entities': {'key': 'properties.entities', 'type': '[AlertEntity]'},
        'confidence_score': {'key': 'properties.confidenceScore', 'type': 'float'},
        'confidence_reasons': {'key': 'properties.confidenceReasons', 'type': '[AlertConfidenceReason]'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'instance_id': {'key': 'properties.instanceId', 'type': 'str'},
        'workspace_arm_id': {'key': 'properties.workspaceArmId', 'type': 'str'},
        'correlation_key': {'key': 'properties.correlationKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Alert, self).__init__(**kwargs)
        self.state = None
        self.reported_time_utc = None
        self.vendor_name = None
        self.alert_name = None
        self.alert_display_name = None
        self.detected_time_utc = None
        self.description = None
        self.remediation_steps = None
        self.action_taken = None
        self.reported_severity = None
        self.compromised_entity = None
        self.associated_resource = None
        self.extended_properties = kwargs.get('extended_properties', None)
        self.system_source = None
        self.can_be_investigated = None
        self.is_incident = None
        self.entities = kwargs.get('entities', None)
        self.confidence_score = None
        self.confidence_reasons = kwargs.get('confidence_reasons', None)
        self.subscription_id = None
        self.instance_id = None
        self.workspace_arm_id = None
        self.correlation_key = None


class AlertConfidenceReason(Model):
    """Factors that increase our confidence that the alert is a true positive.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: Type of confidence factor
    :vartype type: str
    :ivar reason: description of the confidence reason
    :vartype reason: str
    """

    _validation = {
        'type': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AlertConfidenceReason, self).__init__(**kwargs)
        self.type = None
        self.reason = None


class AlertEntity(Model):
    """Changing set of properties depending on the entity type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar type: Type of entity
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AlertEntity, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = None


class AlertsSuppressionRule(Resource):
    """Describes the suppression rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param alert_type: Required. Type of the alert to automatically suppress.
     For all alert types, use '*'
    :type alert_type: str
    :ivar last_modified_utc: The last time this rule was modified
    :vartype last_modified_utc: datetime
    :param expiration_date_utc: Expiration date of the rule, if value is not
     provided or provided as null this field will default to the maximum
     allowed expiration date.
    :type expiration_date_utc: datetime
    :param reason: Required. The reason for dismissing the alert
    :type reason: str
    :param state: Required. Possible states of the rule. Possible values
     include: 'Enabled', 'Disabled', 'Expired'
    :type state: str or ~azure.mgmt.security.models.RuleState
    :param comment: Any comment regarding the rule
    :type comment: str
    :param suppression_alerts_scope: The suppression conditions
    :type suppression_alerts_scope:
     ~azure.mgmt.security.models.SuppressionAlertsScope
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'alert_type': {'required': True},
        'last_modified_utc': {'readonly': True},
        'reason': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'alert_type': {'key': 'properties.alertType', 'type': 'str'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'expiration_date_utc': {'key': 'properties.expirationDateUtc', 'type': 'iso-8601'},
        'reason': {'key': 'properties.reason', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'RuleState'},
        'comment': {'key': 'properties.comment', 'type': 'str'},
        'suppression_alerts_scope': {'key': 'properties.suppressionAlertsScope', 'type': 'SuppressionAlertsScope'},
    }

    def __init__(self, **kwargs):
        super(AlertsSuppressionRule, self).__init__(**kwargs)
        self.alert_type = kwargs.get('alert_type', None)
        self.last_modified_utc = None
        self.expiration_date_utc = kwargs.get('expiration_date_utc', None)
        self.reason = kwargs.get('reason', None)
        self.state = kwargs.get('state', None)
        self.comment = kwargs.get('comment', None)
        self.suppression_alerts_scope = kwargs.get('suppression_alerts_scope', None)


class AllowedConnectionsResource(Model):
    """The resource whose properties describes the allowed traffic between Azure
    resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :ivar calculated_date_time: The UTC time on which the allowed connections
     resource was calculated
    :vartype calculated_date_time: datetime
    :ivar connectable_resources: List of connectable resources
    :vartype connectable_resources:
     list[~azure.mgmt.security.models.ConnectableResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'calculated_date_time': {'readonly': True},
        'connectable_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'calculated_date_time': {'key': 'properties.calculatedDateTime', 'type': 'iso-8601'},
        'connectable_resources': {'key': 'properties.connectableResources', 'type': '[ConnectableResource]'},
    }

    def __init__(self, **kwargs):
        super(AllowedConnectionsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.calculated_date_time = None
        self.connectable_resources = None


class ListCustomAlertRule(CustomAlertRule):
    """A List custom alert rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AllowlistCustomAlertRule, DenylistCustomAlertRule

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :ivar value_type: The value type of the items in the list. Possible values
     include: 'IpCidr', 'String'
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'value_type': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
    }

    _subtype_map = {
        'rule_type': {'AllowlistCustomAlertRule': 'AllowlistCustomAlertRule', 'DenylistCustomAlertRule': 'DenylistCustomAlertRule'}
    }

    def __init__(self, **kwargs):
        super(ListCustomAlertRule, self).__init__(**kwargs)
        self.value_type = None
        self.rule_type = 'ListCustomAlertRule'


class AllowlistCustomAlertRule(ListCustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert
    type) is allowed.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ConnectionToIpNotAllowed, LocalUserNotAllowed,
    ProcessNotAllowed

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :ivar value_type: The value type of the items in the list. Possible values
     include: 'IpCidr', 'String'
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :param allowlist_values: Required. The values to allow. The format of the
     values depends on the rule type.
    :type allowlist_values: list[str]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'value_type': {'readonly': True},
        'allowlist_values': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'allowlist_values': {'key': 'allowlistValues', 'type': '[str]'},
    }

    _subtype_map = {
        'rule_type': {'ConnectionToIpNotAllowed': 'ConnectionToIpNotAllowed', 'LocalUserNotAllowed': 'LocalUserNotAllowed', 'ProcessNotAllowed': 'ProcessNotAllowed'}
    }

    def __init__(self, **kwargs):
        super(AllowlistCustomAlertRule, self).__init__(**kwargs)
        self.allowlist_values = kwargs.get('allowlist_values', None)
        self.rule_type = 'AllowlistCustomAlertRule'


class AmqpC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(AmqpC2DMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'AmqpC2DMessagesNotInAllowedRange'


class AmqpC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (AMQP protocol) is not in
    allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(AmqpC2DRejectedMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'AmqpC2DRejectedMessagesNotInAllowedRange'


class AmqpD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(AmqpD2CMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'AmqpD2CMessagesNotInAllowedRange'


class AppWhitelistingGroup(Model):
    """AppWhitelistingGroup.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param enforcement_mode: Possible values include: 'Audit', 'Enforce',
     'None'
    :type enforcement_mode: str or ~azure.mgmt.security.models.enum
    :param protection_mode:
    :type protection_mode: ~azure.mgmt.security.models.ProtectionMode
    :ivar configuration_status: Possible values include: 'Configured',
     'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
    :vartype configuration_status: str or ~azure.mgmt.security.models.enum
    :ivar recommendation_status: Possible values include: 'Recommended',
     'NotRecommended', 'NotAvailable', 'NoStatus'
    :vartype recommendation_status: str or ~azure.mgmt.security.models.enum
    :ivar issues:
    :vartype issues:
     list[~azure.mgmt.security.models.AppWhitelistingIssueSummary]
    :ivar source_system: Possible values include: 'Azure_AppLocker',
     'Azure_AuditD', 'NonAzure_AppLocker', 'NonAzure_AuditD', 'None'
    :vartype source_system: str or ~azure.mgmt.security.models.enum
    :param vm_recommendations:
    :type vm_recommendations:
     list[~azure.mgmt.security.models.VmRecommendation]
    :param path_recommendations:
    :type path_recommendations:
     list[~azure.mgmt.security.models.PathRecommendation]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'configuration_status': {'readonly': True},
        'recommendation_status': {'readonly': True},
        'issues': {'readonly': True},
        'source_system': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'enforcement_mode': {'key': 'properties.enforcementMode', 'type': 'str'},
        'protection_mode': {'key': 'properties.protectionMode', 'type': 'ProtectionMode'},
        'configuration_status': {'key': 'properties.configurationStatus', 'type': 'str'},
        'recommendation_status': {'key': 'properties.recommendationStatus', 'type': 'str'},
        'issues': {'key': 'properties.issues', 'type': '[AppWhitelistingIssueSummary]'},
        'source_system': {'key': 'properties.sourceSystem', 'type': 'str'},
        'vm_recommendations': {'key': 'properties.vmRecommendations', 'type': '[VmRecommendation]'},
        'path_recommendations': {'key': 'properties.pathRecommendations', 'type': '[PathRecommendation]'},
    }

    def __init__(self, **kwargs):
        super(AppWhitelistingGroup, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.enforcement_mode = kwargs.get('enforcement_mode', None)
        self.protection_mode = kwargs.get('protection_mode', None)
        self.configuration_status = None
        self.recommendation_status = None
        self.issues = None
        self.source_system = None
        self.vm_recommendations = kwargs.get('vm_recommendations', None)
        self.path_recommendations = kwargs.get('path_recommendations', None)


class AppWhitelistingGroups(Model):
    """Represents a list of VM/server groups and set of rules that are Recommended
    by Azure Security Center to be allowed.

    :param value:
    :type value: list[~azure.mgmt.security.models.AppWhitelistingGroup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppWhitelistingGroup]'},
    }

    def __init__(self, **kwargs):
        super(AppWhitelistingGroups, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class AppWhitelistingIssueSummary(Model):
    """Represents a summary of the alerts of the VM/server group.

    :param issue: Possible values include: 'ViolationsAudited',
     'ViolationsBlocked', 'MsiAndScriptViolationsAudited',
     'MsiAndScriptViolationsBlocked', 'ExecutableViolationsAudited',
     'RulesViolatedManually'
    :type issue: str or ~azure.mgmt.security.models.enum
    :param number_of_vms: The number of machines in the VM/server group that
     have this alert
    :type number_of_vms: float
    """

    _attribute_map = {
        'issue': {'key': 'issue', 'type': 'str'},
        'number_of_vms': {'key': 'numberOfVms', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(AppWhitelistingIssueSummary, self).__init__(**kwargs)
        self.issue = kwargs.get('issue', None)
        self.number_of_vms = kwargs.get('number_of_vms', None)


class AscLocation(Resource):
    """The ASC location of the subscription is in the "name" field.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param properties:
    :type properties: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(AscLocation, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AssessmentLinks(Model):
    """Links relevant to the assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar azure_portal_uri: Link to assessment in Azure Portal
    :vartype azure_portal_uri: str
    """

    _validation = {
        'azure_portal_uri': {'readonly': True},
    }

    _attribute_map = {
        'azure_portal_uri': {'key': 'azurePortalUri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AssessmentLinks, self).__init__(**kwargs)
        self.azure_portal_uri = None


class AssessmentStatus(Model):
    """The result of the assessment.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Programmatic code for the status of the assessment.
     Possible values include: 'Healthy', 'Unhealthy', 'NotApplicable'
    :type code: str or ~azure.mgmt.security.models.AssessmentStatusCode
    :param cause: Programmatic code for the cause of the assessment status
    :type cause: str
    :param description: Human readable description of the assessment status
    :type description: str
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'cause': {'key': 'cause', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AssessmentStatus, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.cause = kwargs.get('cause', None)
        self.description = kwargs.get('description', None)


class AtaExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an ATA security solution which sends logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param properties:
    :type properties: ~azure.mgmt.security.models.AtaSolutionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AtaSolutionProperties'},
    }

    def __init__(self, **kwargs):
        super(AtaExternalSecuritySolution, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.kind = 'ATA'


class ExternalSecuritySolutionProperties(Model):
    """The solution properties (correspond to the solution kind).

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
    }

    def __init__(self, **kwargs):
        super(ExternalSecuritySolutionProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.device_vendor = kwargs.get('device_vendor', None)
        self.device_type = kwargs.get('device_type', None)
        self.workspace = kwargs.get('workspace', None)


class AtaSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for ATA solutions.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :param last_event_received:
    :type last_event_received: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
        'last_event_received': {'key': 'lastEventReceived', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AtaSolutionProperties, self).__init__(**kwargs)
        self.last_event_received = kwargs.get('last_event_received', None)


class TrackedResource(Model):
    """Describes an Azure tracked resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Kind of the resource
    :type kind: str
    :param etag: Entity tag is used for comparing two or more entities from
     the same requested resource.
    :type etag: str
    :param tags: A list of key value pairs that describe the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.kind = kwargs.get('kind', None)
        self.etag = kwargs.get('etag', None)
        self.tags = kwargs.get('tags', None)


class Automation(TrackedResource):
    """The security automation resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Kind of the resource
    :type kind: str
    :param etag: Entity tag is used for comparing two or more entities from
     the same requested resource.
    :type etag: str
    :param tags: A list of key value pairs that describe the resource.
    :type tags: dict[str, str]
    :param description: The security automation description.
    :type description: str
    :param is_enabled: Indicates whether the security automation is enabled.
    :type is_enabled: bool
    :param scopes: A collection of scopes on which the security automations
     logic is applied. Supported scopes are the subscription itself or a
     resource group under that subscription. The automation will only apply on
     defined scopes.
    :type scopes: list[~azure.mgmt.security.models.AutomationScope]
    :param sources: A collection of the source event types which evaluate the
     security automation set of rules.
    :type sources: list[~azure.mgmt.security.models.AutomationSource]
    :param actions: A collection of the actions which are triggered if all the
     configured rules evaluations, within at least one rule set, are true.
    :type actions: list[~azure.mgmt.security.models.AutomationAction]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'scopes': {'key': 'properties.scopes', 'type': '[AutomationScope]'},
        'sources': {'key': 'properties.sources', 'type': '[AutomationSource]'},
        'actions': {'key': 'properties.actions', 'type': '[AutomationAction]'},
    }

    def __init__(self, **kwargs):
        super(Automation, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.scopes = kwargs.get('scopes', None)
        self.sources = kwargs.get('sources', None)
        self.actions = kwargs.get('actions', None)


class AutomationAction(Model):
    """The action that should be triggered.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AutomationActionLogicApp, AutomationActionEventHub,
    AutomationActionWorkspace

    All required parameters must be populated in order to send to Azure.

    :param action_type: Required. Constant filled by server.
    :type action_type: str
    """

    _validation = {
        'action_type': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    _subtype_map = {
        'action_type': {'LogicApp': 'AutomationActionLogicApp', 'EventHub': 'AutomationActionEventHub', 'Workspace': 'AutomationActionWorkspace'}
    }

    def __init__(self, **kwargs):
        super(AutomationAction, self).__init__(**kwargs)
        self.action_type = None


class AutomationActionEventHub(AutomationAction):
    """The target Event Hub to which event data will be exported. To learn more
    about Security Center continuous export capabilities, visit
    https://aka.ms/ASCExportLearnMore.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param action_type: Required. Constant filled by server.
    :type action_type: str
    :param event_hub_resource_id: The target Event Hub Azure Resource ID.
    :type event_hub_resource_id: str
    :ivar sas_policy_name: The target Event Hub SAS policy name.
    :vartype sas_policy_name: str
    :param connection_string: The target Event Hub connection string (it will
     not be included in any response).
    :type connection_string: str
    """

    _validation = {
        'action_type': {'required': True},
        'sas_policy_name': {'readonly': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'event_hub_resource_id': {'key': 'eventHubResourceId', 'type': 'str'},
        'sas_policy_name': {'key': 'sasPolicyName', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutomationActionEventHub, self).__init__(**kwargs)
        self.event_hub_resource_id = kwargs.get('event_hub_resource_id', None)
        self.sas_policy_name = None
        self.connection_string = kwargs.get('connection_string', None)
        self.action_type = 'EventHub'


class AutomationActionLogicApp(AutomationAction):
    """The logic app action that should be triggered. To learn more about Security
    Center's Workflow Automation capabilities, visit
    https://aka.ms/ASCWorkflowAutomationLearnMore.

    All required parameters must be populated in order to send to Azure.

    :param action_type: Required. Constant filled by server.
    :type action_type: str
    :param logic_app_resource_id: The triggered Logic App Azure Resource ID.
     This can also reside on other subscriptions, given that you have
     permissions to trigger the Logic App
    :type logic_app_resource_id: str
    :param uri: The Logic App trigger URI endpoint (it will not be included in
     any response).
    :type uri: str
    """

    _validation = {
        'action_type': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'logic_app_resource_id': {'key': 'logicAppResourceId', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutomationActionLogicApp, self).__init__(**kwargs)
        self.logic_app_resource_id = kwargs.get('logic_app_resource_id', None)
        self.uri = kwargs.get('uri', None)
        self.action_type = 'LogicApp'


class AutomationActionWorkspace(AutomationAction):
    """The Log Analytics Workspace to which event data will be exported. Security
    alerts data will reside in the 'SecurityAlert' table and the assessments
    data will reside in the 'SecurityRecommendation' table (under the
    'Security'/'SecurityCenterFree' solutions). Note that in order to view the
    data in the workspace, the Security Center Log Analytics free/standard
    solution needs to be enabled on that workspace. To learn more about
    Security Center continuous export capabilities, visit
    https://aka.ms/ASCExportLearnMore.

    All required parameters must be populated in order to send to Azure.

    :param action_type: Required. Constant filled by server.
    :type action_type: str
    :param workspace_resource_id: The fully qualified Log Analytics Workspace
     Azure Resource ID.
    :type workspace_resource_id: str
    """

    _validation = {
        'action_type': {'required': True},
    }

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutomationActionWorkspace, self).__init__(**kwargs)
        self.workspace_resource_id = kwargs.get('workspace_resource_id', None)
        self.action_type = 'Workspace'


class AutomationRuleSet(Model):
    """A rule set which evaluates all its rules upon an event interception. Only
    when all the included rules in the rule set will be evaluated as 'true',
    will the event trigger the defined actions.

    :param rules:
    :type rules: list[~azure.mgmt.security.models.AutomationTriggeringRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[AutomationTriggeringRule]'},
    }

    def __init__(self, **kwargs):
        super(AutomationRuleSet, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)


class AutomationScope(Model):
    """A single automation scope.

    :param description: The resources scope description.
    :type description: str
    :param scope_path: The resources scope path. Can be the subscription on
     which the automation is defined on or a resource group under that
     subscription (fully qualified Azure resource IDs).
    :type scope_path: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'scope_path': {'key': 'scopePath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutomationScope, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.scope_path = kwargs.get('scope_path', None)


class AutomationSource(Model):
    """The source event types which evaluate the security automation set of rules.
    For example - security alerts and security assessments. To learn more about
    the supported security events data models schemas - please visit
    https://aka.ms/ASCAutomationSchemas.

    :param event_source: A valid event source type. Possible values include:
     'Assessments', 'Alerts'
    :type event_source: str or ~azure.mgmt.security.models.EventSource
    :param rule_sets: A set of rules which evaluate upon event interception. A
     logical disjunction is applied between defined rule sets (logical 'or').
    :type rule_sets: list[~azure.mgmt.security.models.AutomationRuleSet]
    """

    _attribute_map = {
        'event_source': {'key': 'eventSource', 'type': 'str'},
        'rule_sets': {'key': 'ruleSets', 'type': '[AutomationRuleSet]'},
    }

    def __init__(self, **kwargs):
        super(AutomationSource, self).__init__(**kwargs)
        self.event_source = kwargs.get('event_source', None)
        self.rule_sets = kwargs.get('rule_sets', None)


class AutomationTriggeringRule(Model):
    """A rule which is evaluated upon event interception. The rule is configured
    by comparing a specific value from the event model to an expected value.
    This comparison is done by using one of the supported operators set.

    :param property_jpath: The JPath of the entity model property that should
     be checked.
    :type property_jpath: str
    :param property_type: The data type of the compared operands (string,
     integer, floating point number or a boolean [true/false]]. Possible values
     include: 'String', 'Integer', 'Number', 'Boolean'
    :type property_type: str or ~azure.mgmt.security.models.PropertyType
    :param expected_value: The expected value.
    :type expected_value: str
    :param operator: A valid comparer operator to use. A case-insensitive
     comparison will be applied for String PropertyType. Possible values
     include: 'Equals', 'GreaterThan', 'GreaterThanOrEqualTo', 'LesserThan',
     'LesserThanOrEqualTo', 'NotEquals', 'Contains', 'StartsWith', 'EndsWith'
    :type operator: str or ~azure.mgmt.security.models.Operator
    """

    _attribute_map = {
        'property_jpath': {'key': 'propertyJPath', 'type': 'str'},
        'property_type': {'key': 'propertyType', 'type': 'str'},
        'expected_value': {'key': 'expectedValue', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutomationTriggeringRule, self).__init__(**kwargs)
        self.property_jpath = kwargs.get('property_jpath', None)
        self.property_type = kwargs.get('property_type', None)
        self.expected_value = kwargs.get('expected_value', None)
        self.operator = kwargs.get('operator', None)


class AutomationValidationStatus(Model):
    """The security automation model state property bag.

    :param is_valid: Indicates whether the model is valid or not.
    :type is_valid: bool
    :param message: The validation message.
    :type message: str
    """

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutomationValidationStatus, self).__init__(**kwargs)
        self.is_valid = kwargs.get('is_valid', None)
        self.message = kwargs.get('message', None)


class AutoProvisioningSetting(Resource):
    """Auto provisioning setting.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param auto_provision: Required. Describes what kind of security agent
     provisioning action to take. Possible values include: 'On', 'Off'
    :type auto_provision: str or ~azure.mgmt.security.models.AutoProvision
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'auto_provision': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'auto_provision': {'key': 'properties.autoProvision', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutoProvisioningSetting, self).__init__(**kwargs)
        self.auto_provision = kwargs.get('auto_provision', None)


class ResourceDetails(Model):
    """Details of the resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: OnPremiseResourceDetails, AzureResourceDetails

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Constant filled by server.
    :type source: str
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
    }

    _subtype_map = {
        'source': {'OnPremise': 'OnPremiseResourceDetails', 'Azure': 'AzureResourceDetails'}
    }

    def __init__(self, **kwargs):
        super(ResourceDetails, self).__init__(**kwargs)
        self.source = None


class AzureResourceDetails(ResourceDetails):
    """Details of the Azure resource that was assessed.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Constant filled by server.
    :type source: str
    :ivar id: Azure resource Id of the assessed resource
    :vartype id: str
    """

    _validation = {
        'source': {'required': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureResourceDetails, self).__init__(**kwargs)
        self.id = None
        self.source = 'Azure'


class AzureResourceLink(Model):
    """Describes an Azure resource with kind.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Azure resource Id
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureResourceLink, self).__init__(**kwargs)
        self.id = None


class CefExternalSecuritySolution(ExternalSecuritySolution):
    """Represents a security solution which sends CEF logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param properties:
    :type properties: ~azure.mgmt.security.models.CefSolutionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CefSolutionProperties'},
    }

    def __init__(self, **kwargs):
        super(CefExternalSecuritySolution, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.kind = 'CEF'


class CefSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for CEF solutions.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :param hostname:
    :type hostname: str
    :param agent:
    :type agent: str
    :param last_event_received:
    :type last_event_received: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
        'hostname': {'key': 'hostname', 'type': 'str'},
        'agent': {'key': 'agent', 'type': 'str'},
        'last_event_received': {'key': 'lastEventReceived', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CefSolutionProperties, self).__init__(**kwargs)
        self.hostname = kwargs.get('hostname', None)
        self.agent = kwargs.get('agent', None)
        self.last_event_received = kwargs.get('last_event_received', None)


class CloudError(Model):
    """Error response structure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for
     display in a user interface.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class Compliance(Resource):
    """Compliance of a scope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar assessment_timestamp_utc_date: The timestamp when the Compliance
     calculation was conducted.
    :vartype assessment_timestamp_utc_date: datetime
    :ivar resource_count: The resource count of the given subscription for
     which the Compliance calculation was conducted (needed for Management
     Group Compliance calculation).
    :vartype resource_count: int
    :ivar assessment_result: An array of segment, which is the actually the
     compliance assessment.
    :vartype assessment_result:
     list[~azure.mgmt.security.models.ComplianceSegment]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'assessment_timestamp_utc_date': {'readonly': True},
        'resource_count': {'readonly': True},
        'assessment_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'assessment_timestamp_utc_date': {'key': 'properties.assessmentTimestampUtcDate', 'type': 'iso-8601'},
        'resource_count': {'key': 'properties.resourceCount', 'type': 'int'},
        'assessment_result': {'key': 'properties.assessmentResult', 'type': '[ComplianceSegment]'},
    }

    def __init__(self, **kwargs):
        super(Compliance, self).__init__(**kwargs)
        self.assessment_timestamp_utc_date = None
        self.resource_count = None
        self.assessment_result = None


class ComplianceResult(Resource):
    """a compliance result.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar resource_status: The status of the resource regarding a single
     assessment. Possible values include: 'Healthy', 'NotApplicable',
     'OffByPolicy', 'NotHealthy'
    :vartype resource_status: str or
     ~azure.mgmt.security.models.ResourceStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_status': {'key': 'properties.resourceStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ComplianceResult, self).__init__(**kwargs)
        self.resource_status = None


class ComplianceSegment(Model):
    """A segment of a compliance assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar segment_type: The segment type, e.g. compliant, non-compliance,
     insufficient coverage, N/A, etc.
    :vartype segment_type: str
    :ivar percentage: The size (%) of the segment.
    :vartype percentage: float
    """

    _validation = {
        'segment_type': {'readonly': True},
        'percentage': {'readonly': True},
    }

    _attribute_map = {
        'segment_type': {'key': 'segmentType', 'type': 'str'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ComplianceSegment, self).__init__(**kwargs)
        self.segment_type = None
        self.percentage = None


class ConnectableResource(Model):
    """Describes the allowed inbound and outbound traffic of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The Azure resource id
    :vartype id: str
    :ivar inbound_connected_resources: The list of Azure resources that the
     resource has inbound allowed connection from
    :vartype inbound_connected_resources:
     list[~azure.mgmt.security.models.ConnectedResource]
    :ivar outbound_connected_resources: The list of Azure resources that the
     resource has outbound allowed connection to
    :vartype outbound_connected_resources:
     list[~azure.mgmt.security.models.ConnectedResource]
    """

    _validation = {
        'id': {'readonly': True},
        'inbound_connected_resources': {'readonly': True},
        'outbound_connected_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'inbound_connected_resources': {'key': 'inboundConnectedResources', 'type': '[ConnectedResource]'},
        'outbound_connected_resources': {'key': 'outboundConnectedResources', 'type': '[ConnectedResource]'},
    }

    def __init__(self, **kwargs):
        super(ConnectableResource, self).__init__(**kwargs)
        self.id = None
        self.inbound_connected_resources = None
        self.outbound_connected_resources = None


class ConnectedResource(Model):
    """Describes properties of a connected resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar connected_resource_id: The Azure resource id of the connected
     resource
    :vartype connected_resource_id: str
    :ivar tcp_ports: The allowed tcp ports
    :vartype tcp_ports: str
    :ivar udp_ports: The allowed udp ports
    :vartype udp_ports: str
    """

    _validation = {
        'connected_resource_id': {'readonly': True},
        'tcp_ports': {'readonly': True},
        'udp_ports': {'readonly': True},
    }

    _attribute_map = {
        'connected_resource_id': {'key': 'connectedResourceId', 'type': 'str'},
        'tcp_ports': {'key': 'tcpPorts', 'type': 'str'},
        'udp_ports': {'key': 'udpPorts', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConnectedResource, self).__init__(**kwargs)
        self.connected_resource_id = None
        self.tcp_ports = None
        self.udp_ports = None


class ConnectedWorkspace(Model):
    """Represents an OMS workspace to which the solution is connected.

    :param id: Azure resource ID of the connected OMS workspace
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConnectedWorkspace, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ConnectionToIpNotAllowed(AllowlistCustomAlertRule):
    """Outbound connection to an ip that isn't allowed. Allow list consists of
    ipv4 or ipv6 range in CIDR notation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :ivar value_type: The value type of the items in the list. Possible values
     include: 'IpCidr', 'String'
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :param allowlist_values: Required. The values to allow. The format of the
     values depends on the rule type.
    :type allowlist_values: list[str]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'value_type': {'readonly': True},
        'allowlist_values': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'allowlist_values': {'key': 'allowlistValues', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ConnectionToIpNotAllowed, self).__init__(**kwargs)
        self.rule_type = 'ConnectionToIpNotAllowed'


class ContainerRegistryVulnerabilityProperties(AdditionalData):
    """Additional context fields for container registry Vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param assessed_resource_type: Required. Constant filled by server.
    :type assessed_resource_type: str
    :ivar type: Vulnerability Type. e.g: Vulnerability, Potential
     Vulnerability, Information Gathered, Vulnerability
    :vartype type: str
    :ivar cvss: Dictionary from cvss version to cvss details object
    :vartype cvss: dict[str, ~azure.mgmt.security.models.CVSS]
    :ivar patchable: Indicates whether a patch is available or not
    :vartype patchable: bool
    :ivar cve: List of CVEs
    :vartype cve: list[~azure.mgmt.security.models.CVE]
    :ivar published_time: Published time
    :vartype published_time: datetime
    :ivar vendor_references:
    :vartype vendor_references:
     list[~azure.mgmt.security.models.VendorReference]
    :ivar repository_name: Name of the repository which the vulnerable image
     belongs to
    :vartype repository_name: str
    :ivar image_digest: Digest of the vulnerable image
    :vartype image_digest: str
    """

    _validation = {
        'assessed_resource_type': {'required': True},
        'type': {'readonly': True},
        'cvss': {'readonly': True},
        'patchable': {'readonly': True},
        'cve': {'readonly': True},
        'published_time': {'readonly': True},
        'vendor_references': {'readonly': True},
        'repository_name': {'readonly': True},
        'image_digest': {'readonly': True},
    }

    _attribute_map = {
        'assessed_resource_type': {'key': 'assessedResourceType', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cvss': {'key': 'cvss', 'type': '{CVSS}'},
        'patchable': {'key': 'patchable', 'type': 'bool'},
        'cve': {'key': 'cve', 'type': '[CVE]'},
        'published_time': {'key': 'publishedTime', 'type': 'iso-8601'},
        'vendor_references': {'key': 'vendorReferences', 'type': '[VendorReference]'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'image_digest': {'key': 'imageDigest', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerRegistryVulnerabilityProperties, self).__init__(**kwargs)
        self.type = None
        self.cvss = None
        self.patchable = None
        self.cve = None
        self.published_time = None
        self.vendor_references = None
        self.repository_name = None
        self.image_digest = None
        self.assessed_resource_type = 'ContainerRegistryVulnerability'


class CVE(Model):
    """CVE details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar title: CVE title
    :vartype title: str
    :ivar link: Link url
    :vartype link: str
    """

    _validation = {
        'title': {'readonly': True},
        'link': {'readonly': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CVE, self).__init__(**kwargs)
        self.title = None
        self.link = None


class CVSS(Model):
    """CVSS details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar base: CVSS base
    :vartype base: float
    """

    _validation = {
        'base': {'readonly': True},
    }

    _attribute_map = {
        'base': {'key': 'base', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(CVSS, self).__init__(**kwargs)
        self.base = None


class SettingResource(Resource):
    """The kind of the security setting.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Setting

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'Setting': 'Setting'}
    }

    def __init__(self, **kwargs):
        super(SettingResource, self).__init__(**kwargs)
        self.kind = None
        self.kind = 'SettingResource'


class Setting(SettingResource):
    """Represents a security setting in Azure Security Center.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DataExportSettings

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'DataExportSettings': 'DataExportSettings'}
    }

    def __init__(self, **kwargs):
        super(Setting, self).__init__(**kwargs)
        self.kind = 'Setting'


class DataExportSettings(Setting):
    """Represents a data export setting.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param enabled: Required. Is the data export setting is enabled
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(DataExportSettings, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.kind = 'DataExportSettings'


class DenylistCustomAlertRule(ListCustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert
    type) is denied.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :ivar value_type: The value type of the items in the list. Possible values
     include: 'IpCidr', 'String'
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :param denylist_values: Required. The values to deny. The format of the
     values depends on the rule type.
    :type denylist_values: list[str]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'value_type': {'readonly': True},
        'denylist_values': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'denylist_values': {'key': 'denylistValues', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DenylistCustomAlertRule, self).__init__(**kwargs)
        self.denylist_values = kwargs.get('denylist_values', None)
        self.rule_type = 'DenylistCustomAlertRule'


class DeviceSecurityGroup(Resource):
    """The device security group resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param threshold_rules: The list of custom alert threshold rules.
    :type threshold_rules:
     list[~azure.mgmt.security.models.ThresholdCustomAlertRule]
    :param time_window_rules: The list of custom alert time-window rules.
    :type time_window_rules:
     list[~azure.mgmt.security.models.TimeWindowCustomAlertRule]
    :param allowlist_rules: The allow-list custom alert rules.
    :type allowlist_rules:
     list[~azure.mgmt.security.models.AllowlistCustomAlertRule]
    :param denylist_rules: The deny-list custom alert rules.
    :type denylist_rules:
     list[~azure.mgmt.security.models.DenylistCustomAlertRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'threshold_rules': {'key': 'properties.thresholdRules', 'type': '[ThresholdCustomAlertRule]'},
        'time_window_rules': {'key': 'properties.timeWindowRules', 'type': '[TimeWindowCustomAlertRule]'},
        'allowlist_rules': {'key': 'properties.allowlistRules', 'type': '[AllowlistCustomAlertRule]'},
        'denylist_rules': {'key': 'properties.denylistRules', 'type': '[DenylistCustomAlertRule]'},
    }

    def __init__(self, **kwargs):
        super(DeviceSecurityGroup, self).__init__(**kwargs)
        self.threshold_rules = kwargs.get('threshold_rules', None)
        self.time_window_rules = kwargs.get('time_window_rules', None)
        self.allowlist_rules = kwargs.get('allowlist_rules', None)
        self.denylist_rules = kwargs.get('denylist_rules', None)


class DirectMethodInvokesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of direct method invokes is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(DirectMethodInvokesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'DirectMethodInvokesNotInAllowedRange'


class DiscoveredSecuritySolution(Model):
    """DiscoveredSecuritySolution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param security_family: Required. The security family of the discovered
     solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
    :type security_family: str or ~azure.mgmt.security.models.SecurityFamily
    :param offer: Required. The security solutions' image offer
    :type offer: str
    :param publisher: Required. The security solutions' image publisher
    :type publisher: str
    :param sku: Required. The security solutions' image sku
    :type sku: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'security_family': {'required': True},
        'offer': {'required': True},
        'publisher': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'security_family': {'key': 'properties.securityFamily', 'type': 'str'},
        'offer': {'key': 'properties.offer', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DiscoveredSecuritySolution, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.security_family = kwargs.get('security_family', None)
        self.offer = kwargs.get('offer', None)
        self.publisher = kwargs.get('publisher', None)
        self.sku = kwargs.get('sku', None)


class EffectiveNetworkSecurityGroups(Model):
    """Describes the Network Security Groups effective on a network interface.

    :param network_interface: The Azure resource ID of the network interface
    :type network_interface: str
    :param network_security_groups: The Network Security Groups effective on
     the network interface
    :type network_security_groups: list[str]
    """

    _attribute_map = {
        'network_interface': {'key': 'networkInterface', 'type': 'str'},
        'network_security_groups': {'key': 'networkSecurityGroups', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(EffectiveNetworkSecurityGroups, self).__init__(**kwargs)
        self.network_interface = kwargs.get('network_interface', None)
        self.network_security_groups = kwargs.get('network_security_groups', None)


class ETag(Model):
    """Entity tag is used for comparing two or more entities from the same
    requested resource.

    :param etag: Entity tag is used for comparing two or more entities from
     the same requested resource.
    :type etag: str
    """

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ETag, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)


class ExternalSecuritySolutionKind1(Model):
    """Describes an Azure resource with kind.

    :param kind: The kind of the external solution. Possible values include:
     'CEF', 'ATA', 'AAD'
    :type kind: str or
     ~azure.mgmt.security.models.ExternalSecuritySolutionKind
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExternalSecuritySolutionKind1, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)


class FailedLocalLoginsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of failed local logins is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(FailedLocalLoginsNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'FailedLocalLoginsNotInAllowedRange'


class FileUploadsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of file uploads is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(FileUploadsNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'FileUploadsNotInAllowedRange'


class HttpC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(HttpC2DMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'HttpC2DMessagesNotInAllowedRange'


class HttpC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (HTTP protocol) is not in
    allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(HttpC2DRejectedMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'HttpC2DRejectedMessagesNotInAllowedRange'


class HttpD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(HttpD2CMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'HttpD2CMessagesNotInAllowedRange'


class InformationProtectionKeyword(Model):
    """The information type keyword.

    :param pattern: The keyword pattern.
    :type pattern: str
    :param custom: Indicates whether the keyword is custom or not.
    :type custom: bool
    :param can_be_numeric: Indicates whether the keyword can be applied on
     numeric types or not.
    :type can_be_numeric: bool
    :param excluded: Indicates whether the keyword is excluded or not.
    :type excluded: bool
    """

    _attribute_map = {
        'pattern': {'key': 'pattern', 'type': 'str'},
        'custom': {'key': 'custom', 'type': 'bool'},
        'can_be_numeric': {'key': 'canBeNumeric', 'type': 'bool'},
        'excluded': {'key': 'excluded', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(InformationProtectionKeyword, self).__init__(**kwargs)
        self.pattern = kwargs.get('pattern', None)
        self.custom = kwargs.get('custom', None)
        self.can_be_numeric = kwargs.get('can_be_numeric', None)
        self.excluded = kwargs.get('excluded', None)


class InformationProtectionPolicy(Resource):
    """Information protection policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar last_modified_utc: Describes the last UTC time the policy was
     modified.
    :vartype last_modified_utc: datetime
    :ivar version: Describes the version of the policy.
    :vartype version: str
    :param labels: Dictionary of sensitivity labels.
    :type labels: dict[str, ~azure.mgmt.security.models.SensitivityLabel]
    :param information_types: The sensitivity information types.
    :type information_types: dict[str,
     ~azure.mgmt.security.models.InformationType]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_modified_utc': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'labels': {'key': 'properties.labels', 'type': '{SensitivityLabel}'},
        'information_types': {'key': 'properties.informationTypes', 'type': '{InformationType}'},
    }

    def __init__(self, **kwargs):
        super(InformationProtectionPolicy, self).__init__(**kwargs)
        self.last_modified_utc = None
        self.version = None
        self.labels = kwargs.get('labels', None)
        self.information_types = kwargs.get('information_types', None)


class InformationType(Model):
    """The information type.

    :param display_name: The name of the information type.
    :type display_name: str
    :param description: The description of the information type.
    :type description: str
    :param order: The order of the information type.
    :type order: int
    :param recommended_label_id: The recommended label id to be associated
     with this information type.
    :type recommended_label_id: str
    :param enabled: Indicates whether the information type is enabled or not.
    :type enabled: bool
    :param custom: Indicates whether the information type is custom or not.
    :type custom: bool
    :param keywords: The information type keywords.
    :type keywords:
     list[~azure.mgmt.security.models.InformationProtectionKeyword]
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'order': {'key': 'order', 'type': 'int'},
        'recommended_label_id': {'key': 'recommendedLabelId', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'custom': {'key': 'custom', 'type': 'bool'},
        'keywords': {'key': 'keywords', 'type': '[InformationProtectionKeyword]'},
    }

    def __init__(self, **kwargs):
        super(InformationType, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.order = kwargs.get('order', None)
        self.recommended_label_id = kwargs.get('recommended_label_id', None)
        self.enabled = kwargs.get('enabled', None)
        self.custom = kwargs.get('custom', None)
        self.keywords = kwargs.get('keywords', None)


class IoTSecurityAggregatedAlert(Model):
    """Security Solution Aggregated Alert information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar alert_type: Name of the alert type.
    :vartype alert_type: str
    :ivar alert_display_name: Display name of the alert type.
    :vartype alert_display_name: str
    :ivar aggregated_date_utc: Date of detection.
    :vartype aggregated_date_utc: date
    :ivar vendor_name: Name of the organization that raised the alert.
    :vartype vendor_name: str
    :ivar reported_severity: Assessed alert severity. Possible values include:
     'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar remediation_steps: Recommended steps for remediation.
    :vartype remediation_steps: str
    :ivar description: Description of the suspected vulnerability and meaning.
    :vartype description: str
    :ivar count: Number of alerts occurrences within the aggregated time
     window.
    :vartype count: int
    :ivar effected_resource_type: Azure resource ID of the resource that
     received the alerts.
    :vartype effected_resource_type: str
    :ivar system_source: The type of the alerted resource (Azure, Non-Azure).
    :vartype system_source: str
    :ivar action_taken: IoT Security solution alert response.
    :vartype action_taken: str
    :ivar log_analytics_query: Log analytics query for getting the list of
     affected devices/alerts.
    :vartype log_analytics_query: str
    :ivar top_devices_list: 10 devices with the highest number of occurrences
     of this alert type, on this day.
    :vartype top_devices_list:
     list[~azure.mgmt.security.models.IoTSecurityAggregatedAlertPropertiesTopDevicesListItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'alert_type': {'readonly': True},
        'alert_display_name': {'readonly': True},
        'aggregated_date_utc': {'readonly': True},
        'vendor_name': {'readonly': True},
        'reported_severity': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'description': {'readonly': True},
        'count': {'readonly': True},
        'effected_resource_type': {'readonly': True},
        'system_source': {'readonly': True},
        'action_taken': {'readonly': True},
        'log_analytics_query': {'readonly': True},
        'top_devices_list': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'alert_type': {'key': 'properties.alertType', 'type': 'str'},
        'alert_display_name': {'key': 'properties.alertDisplayName', 'type': 'str'},
        'aggregated_date_utc': {'key': 'properties.aggregatedDateUtc', 'type': 'date'},
        'vendor_name': {'key': 'properties.vendorName', 'type': 'str'},
        'reported_severity': {'key': 'properties.reportedSeverity', 'type': 'str'},
        'remediation_steps': {'key': 'properties.remediationSteps', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'effected_resource_type': {'key': 'properties.effectedResourceType', 'type': 'str'},
        'system_source': {'key': 'properties.systemSource', 'type': 'str'},
        'action_taken': {'key': 'properties.actionTaken', 'type': 'str'},
        'log_analytics_query': {'key': 'properties.logAnalyticsQuery', 'type': 'str'},
        'top_devices_list': {'key': 'properties.topDevicesList', 'type': '[IoTSecurityAggregatedAlertPropertiesTopDevicesListItem]'},
    }

    def __init__(self, **kwargs):
        super(IoTSecurityAggregatedAlert, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.alert_type = None
        self.alert_display_name = None
        self.aggregated_date_utc = None
        self.vendor_name = None
        self.reported_severity = None
        self.remediation_steps = None
        self.description = None
        self.count = None
        self.effected_resource_type = None
        self.system_source = None
        self.action_taken = None
        self.log_analytics_query = None
        self.top_devices_list = None


class IoTSecurityAggregatedAlertPropertiesTopDevicesListItem(Model):
    """IoTSecurityAggregatedAlertPropertiesTopDevicesListItem.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar device_id: Name of the device.
    :vartype device_id: str
    :ivar alerts_count: Number of alerts raised for this device.
    :vartype alerts_count: int
    :ivar last_occurrence: Most recent time this alert was raised for this
     device, on this day.
    :vartype last_occurrence: str
    """

    _validation = {
        'device_id': {'readonly': True},
        'alerts_count': {'readonly': True},
        'last_occurrence': {'readonly': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'alerts_count': {'key': 'alertsCount', 'type': 'int'},
        'last_occurrence': {'key': 'lastOccurrence', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IoTSecurityAggregatedAlertPropertiesTopDevicesListItem, self).__init__(**kwargs)
        self.device_id = None
        self.alerts_count = None
        self.last_occurrence = None


class IoTSecurityAggregatedRecommendation(Model):
    """IoT Security solution recommendation information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param recommendation_name: Name of the recommendation.
    :type recommendation_name: str
    :ivar recommendation_display_name: Display name of the recommendation
     type.
    :vartype recommendation_display_name: str
    :ivar description: Description of the suspected vulnerability and meaning.
    :vartype description: str
    :ivar recommendation_type_id: Recommendation-type GUID.
    :vartype recommendation_type_id: str
    :ivar detected_by: Name of the organization that made the recommendation.
    :vartype detected_by: str
    :ivar remediation_steps: Recommended steps for remediation
    :vartype remediation_steps: str
    :ivar reported_severity: Assessed recommendation severity. Possible values
     include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar healthy_devices: Number of healthy devices within the IoT Security
     solution.
    :vartype healthy_devices: int
    :ivar unhealthy_device_count: Number of unhealthy devices within the IoT
     Security solution.
    :vartype unhealthy_device_count: int
    :ivar log_analytics_query: Log analytics query for getting the list of
     affected devices/alerts.
    :vartype log_analytics_query: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'recommendation_display_name': {'readonly': True},
        'description': {'readonly': True},
        'recommendation_type_id': {'readonly': True},
        'detected_by': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'reported_severity': {'readonly': True},
        'healthy_devices': {'readonly': True},
        'unhealthy_device_count': {'readonly': True},
        'log_analytics_query': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'recommendation_name': {'key': 'properties.recommendationName', 'type': 'str'},
        'recommendation_display_name': {'key': 'properties.recommendationDisplayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'recommendation_type_id': {'key': 'properties.recommendationTypeId', 'type': 'str'},
        'detected_by': {'key': 'properties.detectedBy', 'type': 'str'},
        'remediation_steps': {'key': 'properties.remediationSteps', 'type': 'str'},
        'reported_severity': {'key': 'properties.reportedSeverity', 'type': 'str'},
        'healthy_devices': {'key': 'properties.healthyDevices', 'type': 'int'},
        'unhealthy_device_count': {'key': 'properties.unhealthyDeviceCount', 'type': 'int'},
        'log_analytics_query': {'key': 'properties.logAnalyticsQuery', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IoTSecurityAggregatedRecommendation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.recommendation_name = kwargs.get('recommendation_name', None)
        self.recommendation_display_name = None
        self.description = None
        self.recommendation_type_id = None
        self.detected_by = None
        self.remediation_steps = None
        self.reported_severity = None
        self.healthy_devices = None
        self.unhealthy_device_count = None
        self.log_analytics_query = None


class IoTSecurityAlertedDevice(Model):
    """Statistical information about the number of alerts per device during last
    set number of days.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar device_id: Device identifier.
    :vartype device_id: str
    :ivar alerts_count: Number of alerts raised for this device.
    :vartype alerts_count: int
    """

    _validation = {
        'device_id': {'readonly': True},
        'alerts_count': {'readonly': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'alerts_count': {'key': 'alertsCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(IoTSecurityAlertedDevice, self).__init__(**kwargs)
        self.device_id = None
        self.alerts_count = None


class IoTSecurityDeviceAlert(Model):
    """Statistical information about the number of alerts per alert type during
    last set number of days.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar alert_display_name: Display name of the alert
    :vartype alert_display_name: str
    :ivar reported_severity: Assessed Alert severity. Possible values include:
     'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar alerts_count: Number of alerts raised for this alert type.
    :vartype alerts_count: int
    """

    _validation = {
        'alert_display_name': {'readonly': True},
        'reported_severity': {'readonly': True},
        'alerts_count': {'readonly': True},
    }

    _attribute_map = {
        'alert_display_name': {'key': 'alertDisplayName', 'type': 'str'},
        'reported_severity': {'key': 'reportedSeverity', 'type': 'str'},
        'alerts_count': {'key': 'alertsCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(IoTSecurityDeviceAlert, self).__init__(**kwargs)
        self.alert_display_name = None
        self.reported_severity = None
        self.alerts_count = None


class IoTSecurityDeviceRecommendation(Model):
    """Statistical information about the number of recommendations per device, per
    recommendation type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar recommendation_display_name: Display name of the recommendation.
    :vartype recommendation_display_name: str
    :ivar reported_severity: Assessed recommendation severity. Possible values
     include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar devices_count: Number of devices with this recommendation.
    :vartype devices_count: int
    """

    _validation = {
        'recommendation_display_name': {'readonly': True},
        'reported_severity': {'readonly': True},
        'devices_count': {'readonly': True},
    }

    _attribute_map = {
        'recommendation_display_name': {'key': 'recommendationDisplayName', 'type': 'str'},
        'reported_severity': {'key': 'reportedSeverity', 'type': 'str'},
        'devices_count': {'key': 'devicesCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(IoTSecurityDeviceRecommendation, self).__init__(**kwargs)
        self.recommendation_display_name = None
        self.reported_severity = None
        self.devices_count = None


class IoTSecuritySolutionAnalyticsModel(Resource):
    """Security analytics of your IoT Security solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar metrics: Security analytics of your IoT Security solution.
    :vartype metrics: ~azure.mgmt.security.models.IoTSeverityMetrics
    :ivar unhealthy_device_count: Number of unhealthy devices within your IoT
     Security solution.
    :vartype unhealthy_device_count: int
    :ivar devices_metrics: List of device metrics by the aggregation date.
    :vartype devices_metrics:
     list[~azure.mgmt.security.models.IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]
    :param top_alerted_devices: List of the 3 devices with the most alerts.
    :type top_alerted_devices:
     list[~azure.mgmt.security.models.IoTSecurityAlertedDevice]
    :param most_prevalent_device_alerts: List of the 3 most prevalent device
     alerts.
    :type most_prevalent_device_alerts:
     list[~azure.mgmt.security.models.IoTSecurityDeviceAlert]
    :param most_prevalent_device_recommendations: List of the 3 most prevalent
     device recommendations.
    :type most_prevalent_device_recommendations:
     list[~azure.mgmt.security.models.IoTSecurityDeviceRecommendation]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'metrics': {'readonly': True},
        'unhealthy_device_count': {'readonly': True},
        'devices_metrics': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metrics': {'key': 'properties.metrics', 'type': 'IoTSeverityMetrics'},
        'unhealthy_device_count': {'key': 'properties.unhealthyDeviceCount', 'type': 'int'},
        'devices_metrics': {'key': 'properties.devicesMetrics', 'type': '[IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]'},
        'top_alerted_devices': {'key': 'properties.topAlertedDevices', 'type': '[IoTSecurityAlertedDevice]'},
        'most_prevalent_device_alerts': {'key': 'properties.mostPrevalentDeviceAlerts', 'type': '[IoTSecurityDeviceAlert]'},
        'most_prevalent_device_recommendations': {'key': 'properties.mostPrevalentDeviceRecommendations', 'type': '[IoTSecurityDeviceRecommendation]'},
    }

    def __init__(self, **kwargs):
        super(IoTSecuritySolutionAnalyticsModel, self).__init__(**kwargs)
        self.metrics = None
        self.unhealthy_device_count = None
        self.devices_metrics = None
        self.top_alerted_devices = kwargs.get('top_alerted_devices', None)
        self.most_prevalent_device_alerts = kwargs.get('most_prevalent_device_alerts', None)
        self.most_prevalent_device_recommendations = kwargs.get('most_prevalent_device_recommendations', None)


class IoTSecuritySolutionAnalyticsModelList(Model):
    """List of Security analytics of your IoT Security solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of Security analytics of your IoT Security
     solution
    :type value:
     list[~azure.mgmt.security.models.IoTSecuritySolutionAnalyticsModel]
    :ivar next_link: When there is too much alert data for one page, use this
     URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IoTSecuritySolutionAnalyticsModel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IoTSecuritySolutionAnalyticsModelList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem(Model):
    """IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem.

    :param date_property: Aggregation of IoT Security solution device alert
     metrics by date.
    :type date_property: datetime
    :param devices_metrics: Device alert count by severity.
    :type devices_metrics: ~azure.mgmt.security.models.IoTSeverityMetrics
    """

    _attribute_map = {
        'date_property': {'key': 'date', 'type': 'iso-8601'},
        'devices_metrics': {'key': 'devicesMetrics', 'type': 'IoTSeverityMetrics'},
    }

    def __init__(self, **kwargs):
        super(IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem, self).__init__(**kwargs)
        self.date_property = kwargs.get('date_property', None)
        self.devices_metrics = kwargs.get('devices_metrics', None)


class IoTSecuritySolutionModel(Model):
    """IoT Security solution configuration and resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param location: The resource location.
    :type location: str
    :param workspace: Workspace resource ID
    :type workspace: str
    :param display_name: Required. Resource display name.
    :type display_name: str
    :param status: Status of the IoT Security solution. Possible values
     include: 'Enabled', 'Disabled'. Default value: "Enabled" .
    :type status: str or ~azure.mgmt.security.models.SecuritySolutionStatus
    :param export: List of additional options for exporting to workspace data.
    :type export: list[str or ~azure.mgmt.security.models.ExportData]
    :param disabled_data_sources: Disabled data sources. Disabling these data
     sources compromises the system.
    :type disabled_data_sources: list[str or
     ~azure.mgmt.security.models.DataSource]
    :param iot_hubs: Required. IoT Hub resource IDs
    :type iot_hubs: list[str]
    :param user_defined_resources:
    :type user_defined_resources:
     ~azure.mgmt.security.models.UserDefinedResourcesProperties
    :ivar auto_discovered_resources: List of resources that were automatically
     discovered as relevant to the security solution.
    :vartype auto_discovered_resources: list[str]
    :param recommendations_configuration:
    :type recommendations_configuration:
     list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
    :param unmasked_ip_logging_status: Unmasked IP address logging status.
     Possible values include: 'Disabled', 'Enabled'. Default value: "Disabled"
     .
    :type unmasked_ip_logging_status: str or
     ~azure.mgmt.security.models.UnmaskedIpLoggingStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'required': True},
        'iot_hubs': {'required': True},
        'auto_discovered_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'workspace': {'key': 'properties.workspace', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'export': {'key': 'properties.export', 'type': '[str]'},
        'disabled_data_sources': {'key': 'properties.disabledDataSources', 'type': '[str]'},
        'iot_hubs': {'key': 'properties.iotHubs', 'type': '[str]'},
        'user_defined_resources': {'key': 'properties.userDefinedResources', 'type': 'UserDefinedResourcesProperties'},
        'auto_discovered_resources': {'key': 'properties.autoDiscoveredResources', 'type': '[str]'},
        'recommendations_configuration': {'key': 'properties.recommendationsConfiguration', 'type': '[RecommendationConfigurationProperties]'},
        'unmasked_ip_logging_status': {'key': 'properties.unmaskedIpLoggingStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IoTSecuritySolutionModel, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)
        self.workspace = kwargs.get('workspace', None)
        self.display_name = kwargs.get('display_name', None)
        self.status = kwargs.get('status', "Enabled")
        self.export = kwargs.get('export', None)
        self.disabled_data_sources = kwargs.get('disabled_data_sources', None)
        self.iot_hubs = kwargs.get('iot_hubs', None)
        self.user_defined_resources = kwargs.get('user_defined_resources', None)
        self.auto_discovered_resources = None
        self.recommendations_configuration = kwargs.get('recommendations_configuration', None)
        self.unmasked_ip_logging_status = kwargs.get('unmasked_ip_logging_status', "Disabled")


class IoTSeverityMetrics(Model):
    """IoT Security solution analytics severity metrics.

    :param high: Count of high severity alerts/recommendations.
    :type high: int
    :param medium: Count of medium severity alerts/recommendations.
    :type medium: int
    :param low: Count of low severity alerts/recommendations.
    :type low: int
    """

    _attribute_map = {
        'high': {'key': 'high', 'type': 'int'},
        'medium': {'key': 'medium', 'type': 'int'},
        'low': {'key': 'low', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(IoTSeverityMetrics, self).__init__(**kwargs)
        self.high = kwargs.get('high', None)
        self.medium = kwargs.get('medium', None)
        self.low = kwargs.get('low', None)


class JitNetworkAccessPolicy(Model):
    """JitNetworkAccessPolicy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Kind of the resource
    :type kind: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param virtual_machines: Required. Configurations for
     Microsoft.Compute/virtualMachines resource type.
    :type virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyVirtualMachine]
    :param requests:
    :type requests: list[~azure.mgmt.security.models.JitNetworkAccessRequest]
    :ivar provisioning_state: Gets the provisioning state of the Just-in-Time
     policy.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'virtual_machines': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[JitNetworkAccessPolicyVirtualMachine]'},
        'requests': {'key': 'properties.requests', 'type': '[JitNetworkAccessRequest]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessPolicy, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kind = kwargs.get('kind', None)
        self.location = None
        self.virtual_machines = kwargs.get('virtual_machines', None)
        self.requests = kwargs.get('requests', None)
        self.provisioning_state = None


class JitNetworkAccessPolicyInitiatePort(Model):
    """JitNetworkAccessPolicyInitiatePort.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param allowed_source_address_prefix: Source of the allowed traffic. If
     omitted, the request will be for the source IP address of the initiate
     request.
    :type allowed_source_address_prefix: str
    :param end_time_utc: Required. The time to close the request in UTC
    :type end_time_utc: datetime
    """

    _validation = {
        'number': {'required': True},
        'end_time_utc': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessPolicyInitiatePort, self).__init__(**kwargs)
        self.number = kwargs.get('number', None)
        self.allowed_source_address_prefix = kwargs.get('allowed_source_address_prefix', None)
        self.end_time_utc = kwargs.get('end_time_utc', None)


class JitNetworkAccessPolicyInitiateRequest(Model):
    """JitNetworkAccessPolicyInitiateRequest.

    All required parameters must be populated in order to send to Azure.

    :param virtual_machines: Required. A list of virtual machines & ports to
     open access for
    :type virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiateVirtualMachine]
    :param justification: The justification for making the initiate request
    :type justification: str
    """

    _validation = {
        'virtual_machines': {'required': True},
    }

    _attribute_map = {
        'virtual_machines': {'key': 'virtualMachines', 'type': '[JitNetworkAccessPolicyInitiateVirtualMachine]'},
        'justification': {'key': 'justification', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessPolicyInitiateRequest, self).__init__(**kwargs)
        self.virtual_machines = kwargs.get('virtual_machines', None)
        self.justification = kwargs.get('justification', None)


class JitNetworkAccessPolicyInitiateVirtualMachine(Model):
    """JitNetworkAccessPolicyInitiateVirtualMachine.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID of the virtual machine that is linked to
     this policy
    :type id: str
    :param ports: Required. The ports to open for the resource with the `id`
    :type ports:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiatePort]
    """

    _validation = {
        'id': {'required': True},
        'ports': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[JitNetworkAccessPolicyInitiatePort]'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessPolicyInitiateVirtualMachine, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.ports = kwargs.get('ports', None)


class JitNetworkAccessPolicyVirtualMachine(Model):
    """JitNetworkAccessPolicyVirtualMachine.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID of the virtual machine that is linked to
     this policy
    :type id: str
    :param ports: Required. Port configurations for the virtual machine
    :type ports: list[~azure.mgmt.security.models.JitNetworkAccessPortRule]
    :param public_ip_address: Public IP address of the Azure Firewall that is
     linked to this policy, if applicable
    :type public_ip_address: str
    """

    _validation = {
        'id': {'required': True},
        'ports': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[JitNetworkAccessPortRule]'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessPolicyVirtualMachine, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.ports = kwargs.get('ports', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)


class JitNetworkAccessPortRule(Model):
    """JitNetworkAccessPortRule.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param protocol: Required. Possible values include: 'TCP', 'UDP', 'All'
    :type protocol: str or ~azure.mgmt.security.models.Protocol
    :param allowed_source_address_prefix: Mutually exclusive with the
     "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR,
     for example "192.168.0.3" or "192.168.0.0/16".
    :type allowed_source_address_prefix: str
    :param allowed_source_address_prefixes: Mutually exclusive with the
     "allowedSourceAddressPrefix" parameter.
    :type allowed_source_address_prefixes: list[str]
    :param max_request_access_duration: Required. Maximum duration requests
     can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1
     day
    :type max_request_access_duration: str
    """

    _validation = {
        'number': {'required': True},
        'protocol': {'required': True},
        'max_request_access_duration': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'allowed_source_address_prefixes': {'key': 'allowedSourceAddressPrefixes', 'type': '[str]'},
        'max_request_access_duration': {'key': 'maxRequestAccessDuration', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessPortRule, self).__init__(**kwargs)
        self.number = kwargs.get('number', None)
        self.protocol = kwargs.get('protocol', None)
        self.allowed_source_address_prefix = kwargs.get('allowed_source_address_prefix', None)
        self.allowed_source_address_prefixes = kwargs.get('allowed_source_address_prefixes', None)
        self.max_request_access_duration = kwargs.get('max_request_access_duration', None)


class JitNetworkAccessRequest(Model):
    """JitNetworkAccessRequest.

    All required parameters must be populated in order to send to Azure.

    :param virtual_machines: Required.
    :type virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessRequestVirtualMachine]
    :param start_time_utc: Required. The start time of the request in UTC
    :type start_time_utc: datetime
    :param requestor: Required. The identity of the person who made the
     request
    :type requestor: str
    :param justification: The justification for making the initiate request
    :type justification: str
    """

    _validation = {
        'virtual_machines': {'required': True},
        'start_time_utc': {'required': True},
        'requestor': {'required': True},
    }

    _attribute_map = {
        'virtual_machines': {'key': 'virtualMachines', 'type': '[JitNetworkAccessRequestVirtualMachine]'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'requestor': {'key': 'requestor', 'type': 'str'},
        'justification': {'key': 'justification', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessRequest, self).__init__(**kwargs)
        self.virtual_machines = kwargs.get('virtual_machines', None)
        self.start_time_utc = kwargs.get('start_time_utc', None)
        self.requestor = kwargs.get('requestor', None)
        self.justification = kwargs.get('justification', None)


class JitNetworkAccessRequestPort(Model):
    """JitNetworkAccessRequestPort.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param allowed_source_address_prefix: Mutually exclusive with the
     "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR,
     for example "192.168.0.3" or "192.168.0.0/16".
    :type allowed_source_address_prefix: str
    :param allowed_source_address_prefixes: Mutually exclusive with the
     "allowedSourceAddressPrefix" parameter.
    :type allowed_source_address_prefixes: list[str]
    :param end_time_utc: Required. The date & time at which the request ends
     in UTC
    :type end_time_utc: datetime
    :param status: Required. The status of the port. Possible values include:
     'Revoked', 'Initiated'
    :type status: str or ~azure.mgmt.security.models.Status
    :param status_reason: Required. A description of why the `status` has its
     value. Possible values include: 'Expired', 'UserRequested',
     'NewerRequestInitiated'
    :type status_reason: str or ~azure.mgmt.security.models.StatusReason
    :param mapped_port: The port which is mapped to this port's `number` in
     the Azure Firewall, if applicable
    :type mapped_port: int
    """

    _validation = {
        'number': {'required': True},
        'end_time_utc': {'required': True},
        'status': {'required': True},
        'status_reason': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'allowed_source_address_prefixes': {'key': 'allowedSourceAddressPrefixes', 'type': '[str]'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'status_reason': {'key': 'statusReason', 'type': 'str'},
        'mapped_port': {'key': 'mappedPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessRequestPort, self).__init__(**kwargs)
        self.number = kwargs.get('number', None)
        self.allowed_source_address_prefix = kwargs.get('allowed_source_address_prefix', None)
        self.allowed_source_address_prefixes = kwargs.get('allowed_source_address_prefixes', None)
        self.end_time_utc = kwargs.get('end_time_utc', None)
        self.status = kwargs.get('status', None)
        self.status_reason = kwargs.get('status_reason', None)
        self.mapped_port = kwargs.get('mapped_port', None)


class JitNetworkAccessRequestVirtualMachine(Model):
    """JitNetworkAccessRequestVirtualMachine.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID of the virtual machine that is linked to
     this policy
    :type id: str
    :param ports: Required. The ports that were opened for the virtual machine
    :type ports: list[~azure.mgmt.security.models.JitNetworkAccessRequestPort]
    """

    _validation = {
        'id': {'required': True},
        'ports': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[JitNetworkAccessRequestPort]'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessRequestVirtualMachine, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.ports = kwargs.get('ports', None)


class Kind(Model):
    """Describes an Azure resource with kind.

    :param kind: Kind of the resource
    :type kind: str
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Kind, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)


class LocalUserNotAllowed(AllowlistCustomAlertRule):
    """Login by a local user that isn't allowed. Allow list consists of login
    names to allow.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :ivar value_type: The value type of the items in the list. Possible values
     include: 'IpCidr', 'String'
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :param allowlist_values: Required. The values to allow. The format of the
     values depends on the rule type.
    :type allowlist_values: list[str]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'value_type': {'readonly': True},
        'allowlist_values': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'allowlist_values': {'key': 'allowlistValues', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(LocalUserNotAllowed, self).__init__(**kwargs)
        self.rule_type = 'LocalUserNotAllowed'


class Location(Model):
    """Describes an Azure resource with location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location: Location where the resource is stored
    :vartype location: str
    """

    _validation = {
        'location': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Location, self).__init__(**kwargs)
        self.location = None


class MqttC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(MqttC2DMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'MqttC2DMessagesNotInAllowedRange'


class MqttC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (MQTT protocol) is not in
    allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(MqttC2DRejectedMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'MqttC2DRejectedMessagesNotInAllowedRange'


class MqttD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(MqttD2CMessagesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'MqttD2CMessagesNotInAllowedRange'


class OnPremiseResourceDetails(ResourceDetails):
    """Details of the On Premise resource that was assessed.

    All required parameters must be populated in order to send to Azure.

    :param source: Required. Constant filled by server.
    :type source: str
    :param workspace_id: Required. Azure resource Id of the workspace the
     machine is attached to
    :type workspace_id: str
    :param vmuuid: Required. The unique Id of the machine
    :type vmuuid: str
    :param source_computer_id: Required. The oms agent Id installed on the
     machine
    :type source_computer_id: str
    :param machine_name: Required. The name of the machine
    :type machine_name: str
    """

    _validation = {
        'source': {'required': True},
        'workspace_id': {'required': True},
        'vmuuid': {'required': True},
        'source_computer_id': {'required': True},
        'machine_name': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'vmuuid': {'key': 'vmuuid', 'type': 'str'},
        'source_computer_id': {'key': 'sourceComputerId', 'type': 'str'},
        'machine_name': {'key': 'machineName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OnPremiseResourceDetails, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.vmuuid = kwargs.get('vmuuid', None)
        self.source_computer_id = kwargs.get('source_computer_id', None)
        self.machine_name = kwargs.get('machine_name', None)
        self.source = 'OnPremise'


class Operation(Model):
    """Possible operation in the REST API of Microsoft.Security.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the operation
    :vartype name: str
    :ivar origin: Where the operation is originated
    :vartype origin: str
    :param display:
    :type display: ~azure.mgmt.security.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.origin = None
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """Security operation display.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar operation: The display name of the security operation.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class PathRecommendation(Model):
    """Represents a path that is recommended to be allowed and its properties.

    :param path: The full path to whitelist
    :type path: str
    :param action: Possible values include: 'Recommended', 'Add', 'Remove'
    :type action: str or ~azure.mgmt.security.models.enum
    :param type: Possible values include: 'File', 'FileHash',
     'PublisherSignature', 'ProductSignature', 'BinarySignature',
     'VersionAndAboveSignature'
    :type type: str or ~azure.mgmt.security.models.enum
    :param publisher_info:
    :type publisher_info: ~azure.mgmt.security.models.PublisherInfo
    :param common: Whether the path is commonly run on the machine
    :type common: bool
    :param user_sids:
    :type user_sids: list[str]
    :param usernames:
    :type usernames: list[~azure.mgmt.security.models.UserRecommendation]
    :param file_type: Possible values include: 'Exe', 'Dll', 'Msi', 'Script',
     'Executable', 'Unknown'
    :type file_type: str or ~azure.mgmt.security.models.enum
    :param configuration_status: Possible values include: 'Configured',
     'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
    :type configuration_status: str or ~azure.mgmt.security.models.enum
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'publisher_info': {'key': 'publisherInfo', 'type': 'PublisherInfo'},
        'common': {'key': 'common', 'type': 'bool'},
        'user_sids': {'key': 'userSids', 'type': '[str]'},
        'usernames': {'key': 'usernames', 'type': '[UserRecommendation]'},
        'file_type': {'key': 'fileType', 'type': 'str'},
        'configuration_status': {'key': 'configurationStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PathRecommendation, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.action = kwargs.get('action', None)
        self.type = kwargs.get('type', None)
        self.publisher_info = kwargs.get('publisher_info', None)
        self.common = kwargs.get('common', None)
        self.user_sids = kwargs.get('user_sids', None)
        self.usernames = kwargs.get('usernames', None)
        self.file_type = kwargs.get('file_type', None)
        self.configuration_status = kwargs.get('configuration_status', None)


class Pricing(Resource):
    """Azure Security Center is provided in two pricing tiers: free and standard,
    with the standard tier available with a trial period. The standard tier
    offers advanced security capabilities, while the free tier offers basic
    security features.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param pricing_tier: Required. The pricing tier value. Azure Security
     Center is provided in two pricing tiers: free and standard, with the
     standard tier available with a trial period. The standard tier offers
     advanced security capabilities, while the free tier offers basic security
     features. Possible values include: 'Free', 'Standard'
    :type pricing_tier: str or ~azure.mgmt.security.models.PricingTier
    :ivar free_trial_remaining_time: The duration left for the subscriptions
     free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
    :vartype free_trial_remaining_time: timedelta
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'pricing_tier': {'required': True},
        'free_trial_remaining_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'pricing_tier': {'key': 'properties.pricingTier', 'type': 'str'},
        'free_trial_remaining_time': {'key': 'properties.freeTrialRemainingTime', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(Pricing, self).__init__(**kwargs)
        self.pricing_tier = kwargs.get('pricing_tier', None)
        self.free_trial_remaining_time = None


class PricingList(Model):
    """List of pricing configurations response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of pricing configurations
    :type value: list[~azure.mgmt.security.models.Pricing]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Pricing]'},
    }

    def __init__(self, **kwargs):
        super(PricingList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ProcessNotAllowed(AllowlistCustomAlertRule):
    """Execution of a process that isn't allowed. Allow list consists of process
    names to allow.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :ivar value_type: The value type of the items in the list. Possible values
     include: 'IpCidr', 'String'
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :param allowlist_values: Required. The values to allow. The format of the
     values depends on the rule type.
    :type allowlist_values: list[str]
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'value_type': {'readonly': True},
        'allowlist_values': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'allowlist_values': {'key': 'allowlistValues', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ProcessNotAllowed, self).__init__(**kwargs)
        self.rule_type = 'ProcessNotAllowed'


class ProtectionMode(Model):
    """The protection mode of the collection/file types. Exe/Msi/Script are used
    for Windows, Executable is used for Linux.

    :param exe: Possible values include: 'Audit', 'Enforce', 'None'
    :type exe: str or ~azure.mgmt.security.models.enum
    :param msi: Possible values include: 'Audit', 'Enforce', 'None'
    :type msi: str or ~azure.mgmt.security.models.enum
    :param script: Possible values include: 'Audit', 'Enforce', 'None'
    :type script: str or ~azure.mgmt.security.models.enum
    :param executable: Possible values include: 'Audit', 'Enforce', 'None'
    :type executable: str or ~azure.mgmt.security.models.enum
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'msi': {'key': 'msi', 'type': 'str'},
        'script': {'key': 'script', 'type': 'str'},
        'executable': {'key': 'executable', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProtectionMode, self).__init__(**kwargs)
        self.exe = kwargs.get('exe', None)
        self.msi = kwargs.get('msi', None)
        self.script = kwargs.get('script', None)
        self.executable = kwargs.get('executable', None)


class PublisherInfo(Model):
    """Represents the publisher information of a process/rule.

    :param publisher_name: The Subject field of the x.509 certificate used to
     sign the code, using the following fields -  O = Organization, L =
     Locality, S = State or Province, and C = Country
    :type publisher_name: str
    :param product_name: The product name taken from the file's version
     resource
    :type product_name: str
    :param binary_name: The "OriginalName" field taken from the file's version
     resource
    :type binary_name: str
    :param version: The binary file version taken from the file's version
     resource
    :type version: str
    """

    _attribute_map = {
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'product_name': {'key': 'productName', 'type': 'str'},
        'binary_name': {'key': 'binaryName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PublisherInfo, self).__init__(**kwargs)
        self.publisher_name = kwargs.get('publisher_name', None)
        self.product_name = kwargs.get('product_name', None)
        self.binary_name = kwargs.get('binary_name', None)
        self.version = kwargs.get('version', None)


class QueuePurgesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device queue purges is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(QueuePurgesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'QueuePurgesNotInAllowedRange'


class RecommendationConfigurationProperties(Model):
    """The type of IoT Security recommendation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param recommendation_type: Required. The type of IoT Security
     recommendation. Possible values include: 'IoT_ACRAuthentication',
     'IoT_AgentSendsUnutilizedMessages', 'IoT_Baseline',
     'IoT_EdgeHubMemOptimize', 'IoT_EdgeLoggingOptions',
     'IoT_InconsistentModuleSettings', 'IoT_InstallAgent',
     'IoT_IPFilter_DenyAll', 'IoT_IPFilter_PermissiveRule', 'IoT_OpenPorts',
     'IoT_PermissiveFirewallPolicy', 'IoT_PermissiveInputFirewallRules',
     'IoT_PermissiveOutputFirewallRules', 'IoT_PrivilegedDockerOptions',
     'IoT_SharedCredentials', 'IoT_VulnerableTLSCipherSuite'
    :type recommendation_type: str or
     ~azure.mgmt.security.models.RecommendationType
    :ivar name:
    :vartype name: str
    :param status: Required. Recommendation status. When the recommendation
     status is disabled recommendations are not generated. Possible values
     include: 'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.security.models.RecommendationConfigStatus
    """

    _validation = {
        'recommendation_type': {'required': True},
        'name': {'readonly': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'recommendation_type': {'key': 'recommendationType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RecommendationConfigurationProperties, self).__init__(**kwargs)
        self.recommendation_type = kwargs.get('recommendation_type', None)
        self.name = None
        self.status = kwargs.get('status', "Enabled")


class RegulatoryComplianceAssessment(Resource):
    """Regulatory compliance assessment details and state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar description: The description of the regulatory compliance assessment
    :vartype description: str
    :ivar assessment_type: The expected type of assessment contained in the
     AssessmentDetailsLink
    :vartype assessment_type: str
    :ivar assessment_details_link: Link to more detailed assessment results
     data. The response type will be according to the assessmentType field
    :vartype assessment_details_link: str
    :param state: Aggregative state based on the assessment's scanned
     resources states. Possible values include: 'Passed', 'Failed', 'Skipped',
     'Unsupported'
    :type state: str or ~azure.mgmt.security.models.State
    :ivar passed_resources: The given assessment's related resources count
     with passed state.
    :vartype passed_resources: int
    :ivar failed_resources: The given assessment's related resources count
     with failed state.
    :vartype failed_resources: int
    :ivar skipped_resources: The given assessment's related resources count
     with skipped state.
    :vartype skipped_resources: int
    :ivar unsupported_resources: The given assessment's related resources
     count with unsupported state.
    :vartype unsupported_resources: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'assessment_type': {'readonly': True},
        'assessment_details_link': {'readonly': True},
        'passed_resources': {'readonly': True},
        'failed_resources': {'readonly': True},
        'skipped_resources': {'readonly': True},
        'unsupported_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'assessment_type': {'key': 'properties.assessmentType', 'type': 'str'},
        'assessment_details_link': {'key': 'properties.assessmentDetailsLink', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'passed_resources': {'key': 'properties.passedResources', 'type': 'int'},
        'failed_resources': {'key': 'properties.failedResources', 'type': 'int'},
        'skipped_resources': {'key': 'properties.skippedResources', 'type': 'int'},
        'unsupported_resources': {'key': 'properties.unsupportedResources', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RegulatoryComplianceAssessment, self).__init__(**kwargs)
        self.description = None
        self.assessment_type = None
        self.assessment_details_link = None
        self.state = kwargs.get('state', None)
        self.passed_resources = None
        self.failed_resources = None
        self.skipped_resources = None
        self.unsupported_resources = None


class RegulatoryComplianceControl(Resource):
    """Regulatory compliance control details and state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar description: The description of the regulatory compliance control
    :vartype description: str
    :param state: Aggregative state based on the control's supported
     assessments states. Possible values include: 'Passed', 'Failed',
     'Skipped', 'Unsupported'
    :type state: str or ~azure.mgmt.security.models.State
    :ivar passed_assessments: The number of supported regulatory compliance
     assessments of the given control with a passed state
    :vartype passed_assessments: int
    :ivar failed_assessments: The number of supported regulatory compliance
     assessments of the given control with a failed state
    :vartype failed_assessments: int
    :ivar skipped_assessments: The number of supported regulatory compliance
     assessments of the given control with a skipped state
    :vartype skipped_assessments: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'passed_assessments': {'readonly': True},
        'failed_assessments': {'readonly': True},
        'skipped_assessments': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'passed_assessments': {'key': 'properties.passedAssessments', 'type': 'int'},
        'failed_assessments': {'key': 'properties.failedAssessments', 'type': 'int'},
        'skipped_assessments': {'key': 'properties.skippedAssessments', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RegulatoryComplianceControl, self).__init__(**kwargs)
        self.description = None
        self.state = kwargs.get('state', None)
        self.passed_assessments = None
        self.failed_assessments = None
        self.skipped_assessments = None


class RegulatoryComplianceStandard(Resource):
    """Regulatory compliance standard details and state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param state: Aggregative state based on the standard's supported controls
     states. Possible values include: 'Passed', 'Failed', 'Skipped',
     'Unsupported'
    :type state: str or ~azure.mgmt.security.models.State
    :ivar passed_controls: The number of supported regulatory compliance
     controls of the given standard with a passed state
    :vartype passed_controls: int
    :ivar failed_controls: The number of supported regulatory compliance
     controls of the given standard with a failed state
    :vartype failed_controls: int
    :ivar skipped_controls: The number of supported regulatory compliance
     controls of the given standard with a skipped state
    :vartype skipped_controls: int
    :ivar unsupported_controls: The number of regulatory compliance controls
     of the given standard which are unsupported by automated assessments
    :vartype unsupported_controls: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'passed_controls': {'readonly': True},
        'failed_controls': {'readonly': True},
        'skipped_controls': {'readonly': True},
        'unsupported_controls': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'passed_controls': {'key': 'properties.passedControls', 'type': 'int'},
        'failed_controls': {'key': 'properties.failedControls', 'type': 'int'},
        'skipped_controls': {'key': 'properties.skippedControls', 'type': 'int'},
        'unsupported_controls': {'key': 'properties.unsupportedControls', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RegulatoryComplianceStandard, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.passed_controls = None
        self.failed_controls = None
        self.skipped_controls = None
        self.unsupported_controls = None


class Rule(Model):
    """Describes remote addresses that is recommended to communicate with the
    Azure resource on some (Protocol, Port, Direction). All other remote
    addresses are recommended to be blocked.

    :param name: The name of the rule
    :type name: str
    :param direction: The rule's direction. Possible values include:
     'Inbound', 'Outbound'
    :type direction: str or ~azure.mgmt.security.models.Direction
    :param destination_port: The rule's destination port
    :type destination_port: int
    :param protocols: The rule's transport protocols
    :type protocols: list[str or
     ~azure.mgmt.security.models.TransportProtocol]
    :param ip_addresses: The remote IP addresses that should be able to
     communicate with the Azure resource on the rule's destination port and
     protocol
    :type ip_addresses: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'int'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'ip_addresses': {'key': 'ipAddresses', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(Rule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.direction = kwargs.get('direction', None)
        self.destination_port = kwargs.get('destination_port', None)
        self.protocols = kwargs.get('protocols', None)
        self.ip_addresses = kwargs.get('ip_addresses', None)


class ScopeElement(Model):
    """A more specific scope used to identify the alerts to suppress.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param field: The alert entity type to suppress by.
    :type field: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'field': {'key': 'field', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ScopeElement, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.field = kwargs.get('field', None)


class SecureScoreControlDefinitionItem(Resource):
    """Information about the security control.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar display_name: User friendly display name of the control
    :vartype display_name: str
    :ivar description: User friendly description of the control
    :vartype description: str
    :ivar max_score: Maximum control score (0..10)
    :vartype max_score: int
    :ivar source: Source object from which the control was created
    :vartype source:
     ~azure.mgmt.security.models.SecureScoreControlDefinitionSource
    :ivar assessment_definitions: Array of assessments metadata IDs that are
     included in this security control
    :vartype assessment_definitions:
     list[~azure.mgmt.security.models.AzureResourceLink]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True, 'max_length': 256},
        'max_score': {'readonly': True, 'maximum': 10, 'minimum': 0},
        'source': {'readonly': True},
        'assessment_definitions': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'max_score': {'key': 'properties.maxScore', 'type': 'int'},
        'source': {'key': 'properties.source', 'type': 'SecureScoreControlDefinitionSource'},
        'assessment_definitions': {'key': 'properties.assessmentDefinitions', 'type': '[AzureResourceLink]'},
    }

    def __init__(self, **kwargs):
        super(SecureScoreControlDefinitionItem, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.max_score = None
        self.source = None
        self.assessment_definitions = None


class SecureScoreControlDefinitionSource(Model):
    """The type of the security control (For example, BuiltIn).

    :param source_type: The type of security control (for example, BuiltIn).
     Possible values include: 'BuiltIn', 'Custom'
    :type source_type: str or ~azure.mgmt.security.models.ControlType
    """

    _attribute_map = {
        'source_type': {'key': 'sourceType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecureScoreControlDefinitionSource, self).__init__(**kwargs)
        self.source_type = kwargs.get('source_type', None)


class SecureScoreControlDetails(Resource):
    """Details of the security control, its score, and the health status of the
    relevant resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar display_name: User friendly display name of the control
    :vartype display_name: str
    :ivar max: Maximum score available
    :vartype max: int
    :ivar current: Current score
    :vartype current: float
    :ivar healthy_resource_count: Number of healthy resources in the control
    :vartype healthy_resource_count: int
    :ivar unhealthy_resource_count: Number of unhealthy resources in the
     control
    :vartype unhealthy_resource_count: int
    :ivar not_applicable_resource_count: Number of not applicable resources in
     the control
    :vartype not_applicable_resource_count: int
    :param definition:
    :type definition:
     ~azure.mgmt.security.models.SecureScoreControlDefinitionItem
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'max': {'readonly': True, 'minimum': 0},
        'current': {'readonly': True, 'minimum': 0},
        'healthy_resource_count': {'readonly': True},
        'unhealthy_resource_count': {'readonly': True},
        'not_applicable_resource_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'max': {'key': 'properties.score.max', 'type': 'int'},
        'current': {'key': 'properties.score.current', 'type': 'float'},
        'healthy_resource_count': {'key': 'properties.healthyResourceCount', 'type': 'int'},
        'unhealthy_resource_count': {'key': 'properties.unhealthyResourceCount', 'type': 'int'},
        'not_applicable_resource_count': {'key': 'properties.notApplicableResourceCount', 'type': 'int'},
        'definition': {'key': 'properties.definition', 'type': 'SecureScoreControlDefinitionItem'},
    }

    def __init__(self, **kwargs):
        super(SecureScoreControlDetails, self).__init__(**kwargs)
        self.display_name = None
        self.max = None
        self.current = None
        self.healthy_resource_count = None
        self.unhealthy_resource_count = None
        self.not_applicable_resource_count = None
        self.definition = kwargs.get('definition', None)


class SecureScoreControlScore(Model):
    """Calculation result data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar max: Maximum control score (0..10)
    :vartype max: int
    :ivar current: Actual score for the control = (achieved points / total
     points) * max score. if total points is zeroed, the return number is 0.00
    :vartype current: float
    """

    _validation = {
        'max': {'readonly': True, 'maximum': 10, 'minimum': 0},
        'current': {'readonly': True, 'maximum': 10, 'minimum': 0},
    }

    _attribute_map = {
        'max': {'key': 'max', 'type': 'int'},
        'current': {'key': 'current', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(SecureScoreControlScore, self).__init__(**kwargs)
        self.max = None
        self.current = None


class SecureScoreItem(Resource):
    """Secure score item data model.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar display_name: The initiative’s name
    :vartype display_name: str
    :ivar max: Maximum score available
    :vartype max: int
    :ivar current: Current score
    :vartype current: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'max': {'readonly': True, 'minimum': 0},
        'current': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'max': {'key': 'properties.score.max', 'type': 'int'},
        'current': {'key': 'properties.score.current', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(SecureScoreItem, self).__init__(**kwargs)
        self.display_name = None
        self.max = None
        self.current = None


class SecurityAssessment(Resource):
    """Security assessment on a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param resource_details: Required.
    :type resource_details: ~azure.mgmt.security.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment
    :vartype display_name: str
    :param status: Required.
    :type status: ~azure.mgmt.security.models.AssessmentStatus
    :param additional_data: Additional data regarding the assessment
    :type additional_data: dict[str, str]
    :param links:
    :type links: ~azure.mgmt.security.models.AssessmentLinks
    :param metadata:
    :type metadata:
     ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
    :param partners_data:
    :type partners_data:
     ~azure.mgmt.security.models.SecurityAssessmentPartnerData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_details': {'required': True},
        'display_name': {'readonly': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_details': {'key': 'properties.resourceDetails', 'type': 'ResourceDetails'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'AssessmentStatus'},
        'additional_data': {'key': 'properties.additionalData', 'type': '{str}'},
        'links': {'key': 'properties.links', 'type': 'AssessmentLinks'},
        'metadata': {'key': 'properties.metadata', 'type': 'SecurityAssessmentMetadataProperties'},
        'partners_data': {'key': 'properties.partnersData', 'type': 'SecurityAssessmentPartnerData'},
    }

    def __init__(self, **kwargs):
        super(SecurityAssessment, self).__init__(**kwargs)
        self.resource_details = kwargs.get('resource_details', None)
        self.display_name = None
        self.status = kwargs.get('status', None)
        self.additional_data = kwargs.get('additional_data', None)
        self.links = kwargs.get('links', None)
        self.metadata = kwargs.get('metadata', None)
        self.partners_data = kwargs.get('partners_data', None)


class SecurityAssessmentMetadata(Resource):
    """Security assessment metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param display_name: Required. User friendly display name of the
     assessment
    :type display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition
     that turns this assessment calculation on
    :vartype policy_definition_id: str
    :param description: Human readable description of the assessment
    :type description: str
    :param remediation_description: Human readable description of what you
     should do to mitigate this security issue
    :type remediation_description: str
    :param category:
    :type category: list[str or ~azure.mgmt.security.models.Category]
    :param severity: Required. The severity level of the assessment. Possible
     values include: 'Low', 'Medium', 'High'
    :type severity: str or ~azure.mgmt.security.models.Severity
    :param user_impact: The user impact of the assessment. Possible values
     include: 'Low', 'Moderate', 'High'
    :type user_impact: str or ~azure.mgmt.security.models.UserImpact
    :param implementation_effort: The implementation effort required to
     remediate this assessment. Possible values include: 'Low', 'Moderate',
     'High'
    :type implementation_effort: str or
     ~azure.mgmt.security.models.ImplementationEffort
    :param threats:
    :type threats: list[str or ~azure.mgmt.security.models.Threats]
    :param preview: True if this assessment is in preview release status
    :type preview: bool
    :param assessment_type: Required. BuiltIn if the assessment based on
     built-in Azure Policy definition, Custom if the assessment based on custom
     Azure Policy definition. Possible values include: 'BuiltIn',
     'CustomPolicy', 'CustomerManaged', 'VerifiedPartner'
    :type assessment_type: str or ~azure.mgmt.security.models.AssessmentType
    :param partner_data:
    :type partner_data:
     ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'required': True},
        'policy_definition_id': {'readonly': True},
        'severity': {'required': True},
        'assessment_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'policy_definition_id': {'key': 'properties.policyDefinitionId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'remediation_description': {'key': 'properties.remediationDescription', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': '[str]'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'user_impact': {'key': 'properties.userImpact', 'type': 'str'},
        'implementation_effort': {'key': 'properties.implementationEffort', 'type': 'str'},
        'threats': {'key': 'properties.threats', 'type': '[str]'},
        'preview': {'key': 'properties.preview', 'type': 'bool'},
        'assessment_type': {'key': 'properties.assessmentType', 'type': 'str'},
        'partner_data': {'key': 'properties.partnerData', 'type': 'SecurityAssessmentMetadataPartnerData'},
    }

    def __init__(self, **kwargs):
        super(SecurityAssessmentMetadata, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.policy_definition_id = None
        self.description = kwargs.get('description', None)
        self.remediation_description = kwargs.get('remediation_description', None)
        self.category = kwargs.get('category', None)
        self.severity = kwargs.get('severity', None)
        self.user_impact = kwargs.get('user_impact', None)
        self.implementation_effort = kwargs.get('implementation_effort', None)
        self.threats = kwargs.get('threats', None)
        self.preview = kwargs.get('preview', None)
        self.assessment_type = kwargs.get('assessment_type', None)
        self.partner_data = kwargs.get('partner_data', None)


class SecurityAssessmentMetadataPartnerData(Model):
    """Describes the partner that created the assessment.

    All required parameters must be populated in order to send to Azure.

    :param partner_name: Required. Name of the company of the partner
    :type partner_name: str
    :param product_name: Name of the product of the partner that created the
     assessment
    :type product_name: str
    :param secret: Required. Secret to authenticate the partner and verify it
     created the assessment - write only
    :type secret: str
    """

    _validation = {
        'partner_name': {'required': True},
        'secret': {'required': True},
    }

    _attribute_map = {
        'partner_name': {'key': 'partnerName', 'type': 'str'},
        'product_name': {'key': 'productName', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityAssessmentMetadataPartnerData, self).__init__(**kwargs)
        self.partner_name = kwargs.get('partner_name', None)
        self.product_name = kwargs.get('product_name', None)
        self.secret = kwargs.get('secret', None)


class SecurityAssessmentMetadataProperties(Model):
    """Describes properties of an assessment metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_name: Required. User friendly display name of the
     assessment
    :type display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition
     that turns this assessment calculation on
    :vartype policy_definition_id: str
    :param description: Human readable description of the assessment
    :type description: str
    :param remediation_description: Human readable description of what you
     should do to mitigate this security issue
    :type remediation_description: str
    :param category:
    :type category: list[str or ~azure.mgmt.security.models.Category]
    :param severity: Required. The severity level of the assessment. Possible
     values include: 'Low', 'Medium', 'High'
    :type severity: str or ~azure.mgmt.security.models.Severity
    :param user_impact: The user impact of the assessment. Possible values
     include: 'Low', 'Moderate', 'High'
    :type user_impact: str or ~azure.mgmt.security.models.UserImpact
    :param implementation_effort: The implementation effort required to
     remediate this assessment. Possible values include: 'Low', 'Moderate',
     'High'
    :type implementation_effort: str or
     ~azure.mgmt.security.models.ImplementationEffort
    :param threats:
    :type threats: list[str or ~azure.mgmt.security.models.Threats]
    :param preview: True if this assessment is in preview release status
    :type preview: bool
    :param assessment_type: Required. BuiltIn if the assessment based on
     built-in Azure Policy definition, Custom if the assessment based on custom
     Azure Policy definition. Possible values include: 'BuiltIn',
     'CustomPolicy', 'CustomerManaged', 'VerifiedPartner'
    :type assessment_type: str or ~azure.mgmt.security.models.AssessmentType
    :param partner_data:
    :type partner_data:
     ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        'display_name': {'required': True},
        'policy_definition_id': {'readonly': True},
        'severity': {'required': True},
        'assessment_type': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'policy_definition_id': {'key': 'policyDefinitionId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'remediation_description': {'key': 'remediationDescription', 'type': 'str'},
        'category': {'key': 'category', 'type': '[str]'},
        'severity': {'key': 'severity', 'type': 'str'},
        'user_impact': {'key': 'userImpact', 'type': 'str'},
        'implementation_effort': {'key': 'implementationEffort', 'type': 'str'},
        'threats': {'key': 'threats', 'type': '[str]'},
        'preview': {'key': 'preview', 'type': 'bool'},
        'assessment_type': {'key': 'assessmentType', 'type': 'str'},
        'partner_data': {'key': 'partnerData', 'type': 'SecurityAssessmentMetadataPartnerData'},
    }

    def __init__(self, **kwargs):
        super(SecurityAssessmentMetadataProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.policy_definition_id = None
        self.description = kwargs.get('description', None)
        self.remediation_description = kwargs.get('remediation_description', None)
        self.category = kwargs.get('category', None)
        self.severity = kwargs.get('severity', None)
        self.user_impact = kwargs.get('user_impact', None)
        self.implementation_effort = kwargs.get('implementation_effort', None)
        self.threats = kwargs.get('threats', None)
        self.preview = kwargs.get('preview', None)
        self.assessment_type = kwargs.get('assessment_type', None)
        self.partner_data = kwargs.get('partner_data', None)


class SecurityAssessmentPartnerData(Model):
    """Data regarding 3rd party partner integration.

    All required parameters must be populated in order to send to Azure.

    :param partner_name: Required. Name of the company of the partner
    :type partner_name: str
    :param secret: Required. secret to authenticate the partner - write only
    :type secret: str
    """

    _validation = {
        'partner_name': {'required': True},
        'secret': {'required': True},
    }

    _attribute_map = {
        'partner_name': {'key': 'partnerName', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityAssessmentPartnerData, self).__init__(**kwargs)
        self.partner_name = kwargs.get('partner_name', None)
        self.secret = kwargs.get('secret', None)


class SecurityContact(Resource):
    """Contact details for security issues.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param email: Required. The email of this security contact
    :type email: str
    :param phone: The phone number of this security contact
    :type phone: str
    :param alert_notifications: Required. Whether to send security alerts
     notifications to the security contact. Possible values include: 'On',
     'Off'
    :type alert_notifications: str or
     ~azure.mgmt.security.models.AlertNotifications
    :param alerts_to_admins: Required. Whether to send security alerts
     notifications to subscription admins. Possible values include: 'On', 'Off'
    :type alerts_to_admins: str or ~azure.mgmt.security.models.AlertsToAdmins
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'email': {'required': True},
        'alert_notifications': {'required': True},
        'alerts_to_admins': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'phone': {'key': 'properties.phone', 'type': 'str'},
        'alert_notifications': {'key': 'properties.alertNotifications', 'type': 'str'},
        'alerts_to_admins': {'key': 'properties.alertsToAdmins', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityContact, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)
        self.phone = kwargs.get('phone', None)
        self.alert_notifications = kwargs.get('alert_notifications', None)
        self.alerts_to_admins = kwargs.get('alerts_to_admins', None)


class SecuritySubAssessment(Resource):
    """Security sub-assessment on a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar security_sub_assessment_id: Vulnerability ID
    :vartype security_sub_assessment_id: str
    :ivar display_name: User friendly display name of the sub-assessment
    :vartype display_name: str
    :param status:
    :type status: ~azure.mgmt.security.models.SubAssessmentStatus
    :ivar remediation: Information on how to remediate this sub-assessment
    :vartype remediation: str
    :ivar impact: Description of the impact of this sub-assessment
    :vartype impact: str
    :ivar category: Category of the sub-assessment
    :vartype category: str
    :ivar description: Human readable description of the assessment status
    :vartype description: str
    :ivar time_generated: The date and time the sub-assessment was generated
    :vartype time_generated: datetime
    :param resource_details:
    :type resource_details: ~azure.mgmt.security.models.ResourceDetails
    :param additional_data:
    :type additional_data: ~azure.mgmt.security.models.AdditionalData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'security_sub_assessment_id': {'readonly': True},
        'display_name': {'readonly': True},
        'remediation': {'readonly': True},
        'impact': {'readonly': True},
        'category': {'readonly': True},
        'description': {'readonly': True},
        'time_generated': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'security_sub_assessment_id': {'key': 'properties.id', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'SubAssessmentStatus'},
        'remediation': {'key': 'properties.remediation', 'type': 'str'},
        'impact': {'key': 'properties.impact', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'time_generated': {'key': 'properties.timeGenerated', 'type': 'iso-8601'},
        'resource_details': {'key': 'properties.resourceDetails', 'type': 'ResourceDetails'},
        'additional_data': {'key': 'properties.additionalData', 'type': 'AdditionalData'},
    }

    def __init__(self, **kwargs):
        super(SecuritySubAssessment, self).__init__(**kwargs)
        self.security_sub_assessment_id = None
        self.display_name = None
        self.status = kwargs.get('status', None)
        self.remediation = None
        self.impact = None
        self.category = None
        self.description = None
        self.time_generated = None
        self.resource_details = kwargs.get('resource_details', None)
        self.additional_data = kwargs.get('additional_data', None)


class SecurityTask(Resource):
    """Security task that we recommend to do in order to strengthen security.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar state: State of the task (Active, Resolved etc.)
    :vartype state: str
    :ivar creation_time_utc: The time this task was discovered in UTC
    :vartype creation_time_utc: datetime
    :param security_task_parameters:
    :type security_task_parameters:
     ~azure.mgmt.security.models.SecurityTaskParameters
    :ivar last_state_change_time_utc: The time this task's details were last
     changed in UTC
    :vartype last_state_change_time_utc: datetime
    :ivar sub_state: Additional data on the state of the task
    :vartype sub_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'creation_time_utc': {'readonly': True},
        'last_state_change_time_utc': {'readonly': True},
        'sub_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time_utc': {'key': 'properties.creationTimeUtc', 'type': 'iso-8601'},
        'security_task_parameters': {'key': 'properties.securityTaskParameters', 'type': 'SecurityTaskParameters'},
        'last_state_change_time_utc': {'key': 'properties.lastStateChangeTimeUtc', 'type': 'iso-8601'},
        'sub_state': {'key': 'properties.subState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityTask, self).__init__(**kwargs)
        self.state = None
        self.creation_time_utc = None
        self.security_task_parameters = kwargs.get('security_task_parameters', None)
        self.last_state_change_time_utc = None
        self.sub_state = None


class SecurityTaskParameters(Model):
    """Changing set of properties, depending on the task type that is derived from
    the name field.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar name: Name of the task type
    :vartype name: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityTaskParameters, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.name = None


class SensitivityLabel(Model):
    """The sensitivity label.

    :param display_name: The name of the sensitivity label.
    :type display_name: str
    :param description: The description of the sensitivity label.
    :type description: str
    :param rank: The rank of the sensitivity label. Possible values include:
     'None', 'Low', 'Medium', 'High', 'Critical'
    :type rank: str or ~azure.mgmt.security.models.Rank
    :param order: The order of the sensitivity label.
    :type order: int
    :param enabled: Indicates whether the label is enabled or not.
    :type enabled: bool
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rank': {'key': 'rank', 'type': 'Rank'},
        'order': {'key': 'order', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SensitivityLabel, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.rank = kwargs.get('rank', None)
        self.order = kwargs.get('order', None)
        self.enabled = kwargs.get('enabled', None)


class ServerVulnerabilityAssessment(Resource):
    """Describes the server vulnerability assessment details on a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar provisioning_state: The provisioningState of the vulnerability
     assessment capability on the VM. Possible values include: 'Succeeded',
     'Failed', 'Canceled', 'Provisioning', 'Deprovisioning'
    :vartype provisioning_state: str or ~azure.mgmt.security.models.enum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServerVulnerabilityAssessment, self).__init__(**kwargs)
        self.provisioning_state = None


class ServerVulnerabilityAssessmentsList(Model):
    """List of server vulnerability assessments.

    :param value:
    :type value:
     list[~azure.mgmt.security.models.ServerVulnerabilityAssessment]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerVulnerabilityAssessment]'},
    }

    def __init__(self, **kwargs):
        super(ServerVulnerabilityAssessmentsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ServerVulnerabilityProperties(AdditionalData):
    """Additional context fields for server vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param assessed_resource_type: Required. Constant filled by server.
    :type assessed_resource_type: str
    :ivar type: Vulnerability Type. e.g: Vulnerability, Potential
     Vulnerability, Information Gathered
    :vartype type: str
    :ivar cvss: Dictionary from cvss version to cvss details object
    :vartype cvss: dict[str, ~azure.mgmt.security.models.CVSS]
    :ivar patchable: Indicates whether a patch is available or not
    :vartype patchable: bool
    :ivar cve: List of CVEs
    :vartype cve: list[~azure.mgmt.security.models.CVE]
    :ivar threat: Threat name
    :vartype threat: str
    :ivar published_time: Published time
    :vartype published_time: datetime
    :ivar vendor_references:
    :vartype vendor_references:
     list[~azure.mgmt.security.models.VendorReference]
    """

    _validation = {
        'assessed_resource_type': {'required': True},
        'type': {'readonly': True},
        'cvss': {'readonly': True},
        'patchable': {'readonly': True},
        'cve': {'readonly': True},
        'threat': {'readonly': True},
        'published_time': {'readonly': True},
        'vendor_references': {'readonly': True},
    }

    _attribute_map = {
        'assessed_resource_type': {'key': 'assessedResourceType', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'cvss': {'key': 'cvss', 'type': '{CVSS}'},
        'patchable': {'key': 'patchable', 'type': 'bool'},
        'cve': {'key': 'cve', 'type': '[CVE]'},
        'threat': {'key': 'threat', 'type': 'str'},
        'published_time': {'key': 'publishedTime', 'type': 'iso-8601'},
        'vendor_references': {'key': 'vendorReferences', 'type': '[VendorReference]'},
    }

    def __init__(self, **kwargs):
        super(ServerVulnerabilityProperties, self).__init__(**kwargs)
        self.type = None
        self.cvss = None
        self.patchable = None
        self.cve = None
        self.threat = None
        self.published_time = None
        self.vendor_references = None
        self.assessed_resource_type = 'ServerVulnerabilityAssessment'


class SqlServerVulnerabilityProperties(AdditionalData):
    """Details of the resource that was assessed.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param assessed_resource_type: Required. Constant filled by server.
    :type assessed_resource_type: str
    :ivar type: The resource type the sub assessment refers to in its resource
     details
    :vartype type: str
    :ivar query: The T-SQL query that runs on your SQL database to perform the
     particular check
    :vartype query: str
    """

    _validation = {
        'assessed_resource_type': {'required': True},
        'type': {'readonly': True},
        'query': {'readonly': True},
    }

    _attribute_map = {
        'assessed_resource_type': {'key': 'assessedResourceType', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlServerVulnerabilityProperties, self).__init__(**kwargs)
        self.type = None
        self.query = None
        self.assessed_resource_type = 'SqlServerVulnerability'


class SubAssessmentStatus(Model):
    """Status of the sub-assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Programmatic code for the status of the assessment. Possible
     values include: 'Healthy', 'Unhealthy', 'NotApplicable'
    :vartype code: str or ~azure.mgmt.security.models.SubAssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status
    :vartype cause: str
    :ivar description: Human readable description of the assessment status
    :vartype description: str
    :ivar severity: The sub-assessment severity level. Possible values
     include: 'Low', 'Medium', 'High'
    :vartype severity: str or ~azure.mgmt.security.models.Severity
    """

    _validation = {
        'code': {'readonly': True},
        'cause': {'readonly': True},
        'description': {'readonly': True},
        'severity': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'cause': {'key': 'cause', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubAssessmentStatus, self).__init__(**kwargs)
        self.code = None
        self.cause = None
        self.description = None
        self.severity = None


class SuppressionAlertsScope(Model):
    """SuppressionAlertsScope.

    All required parameters must be populated in order to send to Azure.

    :param all_of: Required. All the conditions inside need to be true in
     order to suppress the alert
    :type all_of: list[~azure.mgmt.security.models.ScopeElement]
    """

    _validation = {
        'all_of': {'required': True},
    }

    _attribute_map = {
        'all_of': {'key': 'allOf', 'type': '[ScopeElement]'},
    }

    def __init__(self, **kwargs):
        super(SuppressionAlertsScope, self).__init__(**kwargs)
        self.all_of = kwargs.get('all_of', None)


class Tags(Model):
    """A list of key value pairs that describe the resource.

    :param tags: A list of key value pairs that describe the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Tags, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class TagsResource(Model):
    """A container holding only the Tags for a resource, allowing the user to
    update the tags.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TagsResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class TopologyResource(Model):
    """TopologyResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :ivar calculated_date_time: The UTC time on which the topology was
     calculated
    :vartype calculated_date_time: datetime
    :ivar topology_resources: Azure resources which are part of this topology
     resource
    :vartype topology_resources:
     list[~azure.mgmt.security.models.TopologySingleResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'calculated_date_time': {'readonly': True},
        'topology_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'calculated_date_time': {'key': 'properties.calculatedDateTime', 'type': 'iso-8601'},
        'topology_resources': {'key': 'properties.topologyResources', 'type': '[TopologySingleResource]'},
    }

    def __init__(self, **kwargs):
        super(TopologyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.calculated_date_time = None
        self.topology_resources = None


class TopologySingleResource(Model):
    """TopologySingleResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_id: Azure resource id
    :vartype resource_id: str
    :ivar severity: The security severity of the resource
    :vartype severity: str
    :ivar recommendations_exist: Indicates if the resource has security
     recommendations
    :vartype recommendations_exist: bool
    :ivar network_zones: Indicates the resource connectivity level to the
     Internet (InternetFacing, Internal ,etc.)
    :vartype network_zones: str
    :ivar topology_score: Score of the resource based on its security severity
    :vartype topology_score: int
    :ivar location: The location of this resource
    :vartype location: str
    :ivar parents: Azure resources connected to this resource which are in
     higher level in the topology view
    :vartype parents:
     list[~azure.mgmt.security.models.TopologySingleResourceParent]
    :ivar children: Azure resources connected to this resource which are in
     lower level in the topology view
    :vartype children:
     list[~azure.mgmt.security.models.TopologySingleResourceChild]
    """

    _validation = {
        'resource_id': {'readonly': True},
        'severity': {'readonly': True},
        'recommendations_exist': {'readonly': True},
        'network_zones': {'readonly': True},
        'topology_score': {'readonly': True},
        'location': {'readonly': True},
        'parents': {'readonly': True},
        'children': {'readonly': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'recommendations_exist': {'key': 'recommendationsExist', 'type': 'bool'},
        'network_zones': {'key': 'networkZones', 'type': 'str'},
        'topology_score': {'key': 'topologyScore', 'type': 'int'},
        'location': {'key': 'location', 'type': 'str'},
        'parents': {'key': 'parents', 'type': '[TopologySingleResourceParent]'},
        'children': {'key': 'children', 'type': '[TopologySingleResourceChild]'},
    }

    def __init__(self, **kwargs):
        super(TopologySingleResource, self).__init__(**kwargs)
        self.resource_id = None
        self.severity = None
        self.recommendations_exist = None
        self.network_zones = None
        self.topology_score = None
        self.location = None
        self.parents = None
        self.children = None


class TopologySingleResourceChild(Model):
    """TopologySingleResourceChild.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_id: Azure resource id which serves as child resource in
     topology view
    :vartype resource_id: str
    """

    _validation = {
        'resource_id': {'readonly': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TopologySingleResourceChild, self).__init__(**kwargs)
        self.resource_id = None


class TopologySingleResourceParent(Model):
    """TopologySingleResourceParent.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_id: Azure resource id which serves as parent resource in
     topology view
    :vartype resource_id: str
    """

    _validation = {
        'resource_id': {'readonly': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TopologySingleResourceParent, self).__init__(**kwargs)
        self.resource_id = None


class TwinUpdatesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of twin updates is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(TwinUpdatesNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'TwinUpdatesNotInAllowedRange'


class UnauthorizedOperationsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of unauthorized operations is not in allowed range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :param is_enabled: Required. Status of the custom alert.
    :type is_enabled: bool
    :param rule_type: Required. Constant filled by server.
    :type rule_type: str
    :param min_threshold: Required. The minimum threshold.
    :type min_threshold: int
    :param max_threshold: Required. The maximum threshold.
    :type max_threshold: int
    :param time_window_size: Required. The time window size in iso8601 format.
    :type time_window_size: timedelta
    """

    _validation = {
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'is_enabled': {'required': True},
        'rule_type': {'required': True},
        'min_threshold': {'required': True},
        'max_threshold': {'required': True},
        'time_window_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'min_threshold': {'key': 'minThreshold', 'type': 'int'},
        'max_threshold': {'key': 'maxThreshold', 'type': 'int'},
        'time_window_size': {'key': 'timeWindowSize', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(UnauthorizedOperationsNotInAllowedRange, self).__init__(**kwargs)
        self.rule_type = 'UnauthorizedOperationsNotInAllowedRange'


class UpdateIotSecuritySolutionData(TagsResource):
    """UpdateIotSecuritySolutionData.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param user_defined_resources:
    :type user_defined_resources:
     ~azure.mgmt.security.models.UserDefinedResourcesProperties
    :param recommendations_configuration:
    :type recommendations_configuration:
     list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'user_defined_resources': {'key': 'properties.userDefinedResources', 'type': 'UserDefinedResourcesProperties'},
        'recommendations_configuration': {'key': 'properties.recommendationsConfiguration', 'type': '[RecommendationConfigurationProperties]'},
    }

    def __init__(self, **kwargs):
        super(UpdateIotSecuritySolutionData, self).__init__(**kwargs)
        self.user_defined_resources = kwargs.get('user_defined_resources', None)
        self.recommendations_configuration = kwargs.get('recommendations_configuration', None)


class UserDefinedResourcesProperties(Model):
    """Properties of the IoT Security solution's user defined resources.

    All required parameters must be populated in order to send to Azure.

    :param query: Required. Azure Resource Graph query which represents the
     security solution's user defined resources. Required to start with "where
     type != "Microsoft.Devices/IotHubs""
    :type query: str
    :param query_subscriptions: Required. List of Azure subscription ids on
     which the user defined resources query should be executed.
    :type query_subscriptions: list[str]
    """

    _validation = {
        'query': {'required': True},
        'query_subscriptions': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'query_subscriptions': {'key': 'querySubscriptions', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(UserDefinedResourcesProperties, self).__init__(**kwargs)
        self.query = kwargs.get('query', None)
        self.query_subscriptions = kwargs.get('query_subscriptions', None)


class UserRecommendation(Model):
    """Represents a user that is recommended to be allowed for a certain rule.

    :param username: Represents a user that is recommended to be allowed for a
     certain rule
    :type username: str
    :param recommendation_action: Possible values include: 'Recommended',
     'Add', 'Remove'
    :type recommendation_action: str or ~azure.mgmt.security.models.enum
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'recommendation_action': {'key': 'recommendationAction', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserRecommendation, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.recommendation_action = kwargs.get('recommendation_action', None)


class VendorReference(Model):
    """Vendor reference.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar title: Link title
    :vartype title: str
    :ivar link: Link url
    :vartype link: str
    """

    _validation = {
        'title': {'readonly': True},
        'link': {'readonly': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VendorReference, self).__init__(**kwargs)
        self.title = None
        self.link = None


class VmRecommendation(Model):
    """Represents a machine that is part of a VM/server group.

    :param configuration_status: Possible values include: 'Configured',
     'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
    :type configuration_status: str or ~azure.mgmt.security.models.enum
    :param recommendation_action: Possible values include: 'Recommended',
     'Add', 'Remove'
    :type recommendation_action: str or ~azure.mgmt.security.models.enum
    :param resource_id:
    :type resource_id: str
    :param enforcement_support: Possible values include: 'Supported',
     'NotSupported', 'Unknown'
    :type enforcement_support: str or ~azure.mgmt.security.models.enum
    """

    _attribute_map = {
        'configuration_status': {'key': 'configurationStatus', 'type': 'str'},
        'recommendation_action': {'key': 'recommendationAction', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'enforcement_support': {'key': 'enforcementSupport', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VmRecommendation, self).__init__(**kwargs)
        self.configuration_status = kwargs.get('configuration_status', None)
        self.recommendation_action = kwargs.get('recommendation_action', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.enforcement_support = kwargs.get('enforcement_support', None)


class WorkspaceSetting(Resource):
    """Configures where to store the OMS agent data for workspaces under a scope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param workspace_id: Required. The full Azure ID of the workspace to save
     the data in
    :type workspace_id: str
    :param scope: Required. All the VMs in this scope will send their security
     data to the mentioned workspace unless overridden by a setting with more
     specific scope
    :type scope: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'workspace_id': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkspaceSetting, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.scope = kwargs.get('scope', None)
