# SPDX-License-Identifier: AGPL-3.0-or-later
# Copyright (C) 2021 Andrew Rechnitzer
# Copyright (C) 2022 Colin B. Macdonald

from plom.scan import with_scanner_messenger


@with_scanner_messenger
def get_bundle_list(*, msgr):
    return msgr.listBundles()


@with_scanner_messenger
def print_bundle_list(*, msgr, table_width=88):
    print("# Bundle info\n")
    bundle_list = msgr.listBundles()
    if len(bundle_list) == 0:
        print("No bundles in database.")
        return

    bundle_list.sort(key=lambda X: X["name"])

    head = ["Bundle name", "no. Pages", "md5sum"]
    N = table_width - 48
    print(f"{head[0]:{N}} | {head[1]:9} | {head[2]:32}")
    print("-" * table_width)
    for X in bundle_list:
        md5sum = "None" if X["md5sum"] is None else X["md5sum"]
        print(f"{X['name']:{N}} | {X['numberOfPages']:9} | {md5sum:32}")
        #
        if X["name"] == "__replacements__system__":
            msg = "(autogenerated, system use only)"
            print(f"{msg:{N}} | {'':9} |")
            print("-" * table_width)
