"""This module defines the enum APICodes.

SPDX-License-Identifier: AGPL-3.0-only OR BSD-3-Clause-Clear
"""
from enum import Enum


class APICodes(str, Enum):
    INCORRECT_PERMISSION = "INCORRECT_PERMISSION"
    NOT_LOGGED_IN = "NOT_LOGGED_IN"
    OBJECT_ID_NOT_FOUND = "OBJECT_ID_NOT_FOUND"
    OBJECT_WRONG_TYPE = "OBJECT_WRONG_TYPE"
    MISSING_REQUIRED_PARAM = "MISSING_REQUIRED_PARAM"
    INVALID_PARAM = "INVALID_PARAM"
    REQUEST_TOO_LARGE = "REQUEST_TOO_LARGE"
    LOGIN_FAILURE = "LOGIN_FAILURE"
    INACTIVE_USER = "INACTIVE_USER"
    INVALID_URL = "INVALID_URL"
    OBJECT_NOT_FOUND = "OBJECT_NOT_FOUND"
    BLOCKED_ASSIGNMENT = "BLOCKED_ASSIGNMENT"
    INVALID_CREDENTIALS = "INVALID_CREDENTIALS"
    INVALID_STATE = "INVALID_STATE"
    INVALID_OAUTH_REQUEST = "INVALID_OAUTH_REQUEST"
    DISABLED_SETTING = "DISABLED_SETTING"
    UNKOWN_ERROR = "UNKOWN_ERROR"
    INVALID_FILE_IN_ARCHIVE = "INVALID_FILE_IN_ARCHIVE"
    NO_FILES_SUBMITTED = "NO_FILES_SUBMITTED"
    RATE_LIMIT_EXCEEDED = "RATE_LIMIT_EXCEEDED"
    OBJECT_ALREADY_EXISTS = "OBJECT_ALREADY_EXISTS"
    INVALID_ARCHIVE = "INVALID_ARCHIVE"
    ROUTE_NOT_FOUND = "ROUTE_NOT_FOUND"
    WEAK_PASSWORD = "WEAK_PASSWORD"
    INSUFFICIENT_GROUP_SIZE = "INSUFFICIENT_GROUP_SIZE"
    ASSIGNMENT_RESULT_GROUP_NOT_READY = "ASSIGNMENT_RESULT_GROUP_NOT_READY"
    ASSIGNMENT_GROUP_FULL = "ASSIGNMENT_GROUP_FULL"
    UNSUPPORTED = "UNSUPPORTED"
    ASSIGNMENT_DEADLINE_UNSET = "ASSIGNMENT_DEADLINE_UNSET"
    PARSING_FAILED = "PARSING_FAILED"
    UNSAFE_ARCHIVE = "UNSAFE_ARCHIVE"
    LOCKED_UPDATE = "LOCKED_UPDATE"
    NOT_NEWEST_SUBMSSION = "NOT_NEWEST_SUBMSSION"
    UPLOAD_TYPE_DISABLED = "UPLOAD_TYPE_DISABLED"
    WEBHOOK_DIFFERENT_BRANCH = "WEBHOOK_DIFFERENT_BRANCH"
    WEBHOOK_UNKNOWN_EVENT_TYPE = "WEBHOOK_UNKNOWN_EVENT_TYPE"
    WEBHOOK_UNKOWN_TYPE = "WEBHOOK_UNKOWN_TYPE"
    WEBHOOK_INVALID_REQUEST = "WEBHOOK_INVALID_REQUEST"
    WEBHOOK_UNKNOWN_REQUEST = "WEBHOOK_UNKNOWN_REQUEST"
    WEBHOOK_DISABLED = "WEBHOOK_DISABLED"
    OBJECT_EXPIRED = "OBJECT_EXPIRED"
    TOO_MANY_SUBMISSIONS = "TOO_MANY_SUBMISSIONS"
    COOL_OFF_PERIOD_ACTIVE = "COOL_OFF_PERIOD_ACTIVE"
    MAILING_FAILED = "MAILING_FAILED"
    LTI1_3_ERROR = "LTI1_3_ERROR"
    LTI1_3_COOKIE_ERROR = "LTI1_3_COOKIE_ERROR"
    LTI1_1_ERROR = "LTI1_1_ERROR"
    IMAGE_BEING_CREATED = "IMAGE_BEING_CREATED"
    OBJECT_TOO_NEW = "OBJECT_TOO_NEW"
    SKIPPED_RESULT = "SKIPPED_RESULT"
    LIMIT_REACHED = "LIMIT_REACHED"
    TOKEN_REVOKED = "TOKEN_REVOKED"
    REPO_ALREADY_CONNECTED = "REPO_ALREADY_CONNECTED"
    REPO_CONNECTION_LIMIT_REACHED = "REPO_CONNECTION_LIMIT_REACHED"
    MALFORMED_COMMUNITY_LIBRARY_ITEM = "MALFORMED_COMMUNITY_LIBRARY_ITEM"
    ASSIGNMENT_HAS_STUDENT_SUBMISSIONS = "ASSIGNMENT_HAS_STUDENT_SUBMISSIONS"
