from sklearn.ensemble import GradientBoostingClassifier
from automlkiller.models.model_factory import ModelFactory
from automlkiller.utils import np_list_arange, UniformDistribution, IntUniformDistribution

@ModelFactory.register('classification-gradientboostingclassifier')
class GradientBoostingClassifierContainer(GradientBoostingClassifier):
    def __init__(self, **kwargs):
        super(GradientBoostingClassifierContainer, self).__init__(**kwargs)
        tune_grid = {
            "n_estimators": np_list_arange(10, 300, 10, inclusive=True),
            "learning_rate": np_list_arange(0.001, 0.5, 0.001, inclusive=True),
            "subsample": np_list_arange(0.2, 1, 0.05, inclusive=True),
            "min_samples_split": [2, 4, 5, 7, 9, 10],
            "min_samples_leaf": [1, 2, 3, 4, 5],
            "max_depth": np_list_arange(1, 11, 1, inclusive=True),
            "min_impurity_decrease": [
                0,
                0.0001,
                0.001,
                0.01,
                0.0002,
                0.002,
                0.02,
                0.0005,
                0.005,
                0.05,
                0.1,
                0.2,
                0.3,
                0.4,
                0.5,
            ],
            "max_features": [1.0, "sqrt", "log2"],
        }
        tune_distributions = {
            "n_estimators": IntUniformDistribution(10, 300),
            "learning_rate": UniformDistribution(0.000001, 0.5, log=True),
            "subsample": UniformDistribution(0.2, 1),
            "min_samples_split": IntUniformDistribution(2, 10),
            "min_samples_leaf": IntUniformDistribution(1, 5),
            "max_depth": IntUniformDistribution(1, 11),
            "min_impurity_decrease": UniformDistribution(0.000000001, 0.5, log=True),
            "max_features": UniformDistribution(0.4, 1),
        }
        self.tune_grid = tune_grid
        self.tune_distributions = tune_distributions
        self.estimator =  GradientBoostingClassifier(**kwargs)
