# flake8: noqa

"""
    Karrio API

    The version of the OpenAPI document: 2021.11
    Contact: hello@karrio.io
    Generated by: https://openapi-generator.tech
"""


__version__ = "2021.10"

import typing

# import ApiClient
from karrio.api_client import ApiClient

# import Configuration
from karrio.configuration import Configuration

# import exceptions
from karrio.exceptions import OpenApiException
from karrio.exceptions import ApiAttributeError
from karrio.exceptions import ApiTypeError
from karrio.exceptions import ApiValueError
from karrio.exceptions import ApiKeyError
from karrio.exceptions import ApiException

# import apis into sdk package
from karrio.api.api_api import APIApi
from karrio.api.addresses_api import AddressesApi
from karrio.api.carriers_api import CarriersApi
from karrio.api.customs_api import CustomsApi
from karrio.api.parcels_api import ParcelsApi
from karrio.api.pickups_api import PickupsApi
from karrio.api.proxy_api import ProxyApi
from karrio.api.orders_api import OrdersApi
from karrio.api.shipments_api import ShipmentsApi
from karrio.api.trackers_api import TrackersApi
from karrio.api.webhooks_api import WebhooksApi


api_key = None
api_key_prefix = 'Token'
host = 'https://api.karrio.io'
api_client = None
configuration = Configuration()


def init_client():
    global api_client
    global configuration
    if (api_client is not None) and (configuration.host == host) \
            and (configuration.api_key['Token'] == f'{api_key}'):
        return api_client

    configuration = Configuration()
    configuration.host = host
    configuration.api_key['Token'] = f'{api_key}'
    configuration.api_key_prefix['Token'] = f'{api_key_prefix}'
    
    api_client = ApiClient(configuration)

    return api_client


def define_api(api_class: typing.Type):
    class _API(api_class):
        def __init__(self):
            pass

        def __getattribute__(self, item):
            return getattr(api_class(init_client()), item)

    return _API()


api = define_api(APIApi)
addresses = define_api(AddressesApi)
carriers = define_api(CarriersApi)
customs = define_api(CustomsApi)
parcels = define_api(ParcelsApi)
pickups = define_api(PickupsApi)
proxy = define_api(ProxyApi)
orders = define_api(OrdersApi)
shipments = define_api(ShipmentsApi)
trackers = define_api(TrackersApi)
webhooks = define_api(WebhooksApi)
